/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.persist.cmd.Add;
import io.ballerina.persist.cmd.Generate;
import io.ballerina.persist.cmd.Init;
import io.ballerina.persist.cmd.Migrate;
import io.ballerina.persist.cmd.Pull;
import io.ballerina.persist.cmd.Push;
import java.io.PrintStream;
import picocli.CommandLine;

@CommandLine.Command(name="persist", description={"generate database configurations."}, subcommands={Init.class, Generate.class, Push.class, Migrate.class, Add.class, Pull.class})
public class PersistCmd
implements BLauncherCmd {
    private static final PrintStream errStream = System.err;
    private static final int EXIT_CODE_0 = 0;
    private static final int EXIT_CODE_2 = 2;
    private static final ExitHandler DEFAULT_EXIT_HANDLER = code -> Runtime.getRuntime().exit(code);
    private final ExitHandler exitHandler;
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;

    public PersistCmd() {
        this(DEFAULT_EXIT_HANDLER);
    }

    public PersistCmd(ExitHandler exitHandler) {
        this.exitHandler = exitHandler;
    }

    private void exit(int code) {
        this.exitHandler.exit(code);
    }

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)this.getName(), (ClassLoader)PersistCmd.class.getClassLoader());
            errStream.println(commandUsageInfo);
            this.exit(0);
            return;
        }
        String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"persist", (ClassLoader)PersistCmd.class.getClassLoader());
        errStream.println(commandUsageInfo);
        this.exit(2);
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    public String getName() {
        return "persist";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Perform operations on Ballerina Persistent Layer").append(System.lineSeparator());
        out.append(System.lineSeparator());
    }

    public void printUsage(StringBuilder stringBuilder) {
        stringBuilder.append("  ballerina persist").append(System.lineSeparator());
    }

    @FunctionalInterface
    public static interface ExitHandler {
        public void exit(int var1);
    }
}

