/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.persist.BalException;
import io.ballerina.persist.configuration.PersistConfiguration;
import io.ballerina.persist.models.Module;
import io.ballerina.persist.nodegenerator.syntax.utils.TomlSyntaxUtils;
import io.ballerina.persist.utils.BalProjectUtils;
import io.ballerina.persist.utils.JdbcDriverLoader;
import io.ballerina.persist.utils.ScriptRunner;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.util.ProjectUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import picocli.CommandLine;

@CommandLine.Command(name="push", description={"Create database tables corresponding to user-defined entities"})
public class Push
implements BLauncherCmd {
    private final PrintStream errStream = System.err;
    private static final String COMMAND_IDENTIFIER = "persist-push";
    private final String sourcePath;
    private String datastore;
    private String createDatabaseSqlFormat;
    private String jdbcUrlWithDatabaseFormat;
    private String driverClass;
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;

    public Push() {
        this("");
    }

    public Push(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public void execute() {
        BuildProject balProject;
        String packageName;
        List<Path> schemaFilePaths;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)COMMAND_IDENTIFIER, (ClassLoader)Push.class.getClassLoader());
            this.errStream.println(commandUsageInfo);
            return;
        }
        try {
            BalProjectUtils.validateBallerinaProject(Paths.get(this.sourcePath, new String[0]));
        }
        catch (BalException e) {
            this.errStream.println(e.getMessage());
            return;
        }
        try {
            HashMap<String, String> ballerinaTomlConfig = TomlSyntaxUtils.readBallerinaTomlConfig(Paths.get(this.sourcePath, "Ballerina.toml"));
            this.datastore = ballerinaTomlConfig.get("options.datastore").trim();
        }
        catch (BalException e) {
            this.errStream.printf("ERROR: failed to locate Ballerina.toml: %s%n", e.getMessage());
            return;
        }
        if (this.datastore.equals("mysql")) {
            this.jdbcUrlWithDatabaseFormat = "jdbc:%s://%s:%s/%s";
            this.createDatabaseSqlFormat = "CREATE DATABASE IF NOT EXISTS %s";
            this.driverClass = "com.mysql.cj.jdbc.Driver";
        } else if (this.datastore.equals("mssql")) {
            this.jdbcUrlWithDatabaseFormat = "jdbc:%s://%s:%s;databaseName=%s;trustServerCertificate=true;encrypt=false";
            this.createDatabaseSqlFormat = "IF NOT EXISTS(SELECT name FROM sys.databases WHERE name = '%1$s') CREATE DATABASE %1$s;";
            this.driverClass = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        } else if (this.datastore.equals("postgresql")) {
            this.jdbcUrlWithDatabaseFormat = "jdbc:%s://%s:%s/%s";
            this.createDatabaseSqlFormat = "CREATE DATABASE %s;";
            this.driverClass = "org.postgresql.Driver";
        } else {
            this.errStream.printf("ERROR: unsupported data store: '%s'%n", this.datastore);
            return;
        }
        Path persistDir = Paths.get(this.sourcePath, "persist");
        if (!Files.isDirectory(persistDir, LinkOption.NOFOLLOW_LINKS)) {
            this.errStream.println("ERROR: the persist directory inside the Ballerina project does not exist. run `bal persist init` to initiate the project before generation");
            return;
        }
        try (Stream<Path> stream = Files.list(persistDir);){
            schemaFilePaths = stream.filter(file -> !Files.isDirectory(file, new LinkOption[0])).filter(file -> file.toString().toLowerCase(Locale.ENGLISH).endsWith(".bal")).toList();
        }
        catch (IOException e) {
            this.errStream.printf("ERROR: failed to list the model definition files in the persist directory. %s%n", e.getMessage());
            return;
        }
        if (schemaFilePaths.isEmpty()) {
            this.errStream.println("ERROR: the persist directory does not contain any model definition file. run `bal persist init` to initiate the project before generation.");
            return;
        }
        try {
            packageName = TomlSyntaxUtils.readPackageName(this.sourcePath);
        }
        catch (BalException e) {
            this.errStream.println(e.getMessage());
            return;
        }
        try {
            balProject = BuildProject.load((Path)Paths.get(this.sourcePath, new String[0]).toAbsolutePath());
        }
        catch (ProjectException e) {
            this.errStream.println("ERROR: failed to load the Ballerina project. " + e.getMessage());
            return;
        }
        schemaFilePaths.forEach(arg_0 -> this.lambda$execute$2(packageName, (Project)balProject, arg_0));
    }

    private Connection getDBConnection(Driver driver, PersistConfiguration persistConfigurations, boolean withDB) throws SQLException {
        String host = persistConfigurations.getDbConfig().getHost();
        int port = persistConfigurations.getDbConfig().getPort();
        String user = persistConfigurations.getDbConfig().getUsername();
        String password = persistConfigurations.getDbConfig().getPassword();
        String database = persistConfigurations.getDbConfig().getDatabase();
        String provider = persistConfigurations.getProvider();
        String url = withDB ? String.format(this.jdbcUrlWithDatabaseFormat, provider, host, port, database) : String.format("jdbc:%s://%s:%s/", provider, host, port);
        Properties props = new Properties();
        if (user != null) {
            props.put("user", user);
        }
        if (password != null) {
            props.put("password", password);
        }
        return driver.connect(url, props);
    }

    private JdbcDriverLoader getJdbcDriverLoader(Project balProject) throws BalException {
        JdbcDriverLoader driverLoader = null;
        Path driverDirectoryPath = this.getDriverPath(balProject).getParent();
        if (Objects.nonNull(driverDirectoryPath)) {
            Path driverPath = driverDirectoryPath.toAbsolutePath();
            URL[] urls = new URL[]{};
            try {
                driverLoader = new JdbcDriverLoader(urls, driverPath);
            }
            catch (IOException e) {
                throw new BalException("could not load the driver from the driver path. " + e.getMessage());
            }
        }
        return driverLoader;
    }

    private Driver getJdbcDriver(JdbcDriverLoader driverLoader) throws BalException {
        Driver driver;
        try {
            Class<?> drvClass = driverLoader.loadClass(this.driverClass);
            driver = (Driver)drvClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new BalException("required database driver class not found. " + e.getMessage());
        }
        catch (InstantiationException | InvocationTargetException e) {
            throw new BalException("the database driver instantiation is failed. " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new BalException("access denied while trying to instantiation the database driver. " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new BalException("method not found while trying to instantiate jdbc driver. " + e.getMessage());
        }
        return driver;
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    public String getName() {
        return "persist";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Create databases and tables for the entity records defined in the Ballerina project").append(System.lineSeparator());
        out.append(System.lineSeparator());
    }

    public void printUsage(StringBuilder stringBuilder) {
        stringBuilder.append("  ballerina persist db push").append(System.lineSeparator());
    }

    private Path getDriverPath(Project balProject) throws BalException {
        Optional<ResolvedPackageDependency> postgresqlDriverDependency;
        Optional<ResolvedPackageDependency> mssqlDriverDependency;
        ResolvedPackageDependency root;
        DependencyGraph resolvedPackageDependencyDependencyGraph = balProject.currentPackage().getResolution().dependencyGraph();
        Optional<ResolvedPackageDependency> mysqlDriverDependency = resolvedPackageDependencyDependencyGraph.getDirectDependencies((Object)(root = (ResolvedPackageDependency)resolvedPackageDependencyDependencyGraph.getRoot())).stream().filter(resolvedPackageDependency -> resolvedPackageDependency.packageInstance().descriptor().toString().contains("ballerinax/mysql.driver")).findFirst();
        if (mysqlDriverDependency.isPresent()) {
            Package mysqlDriverPackage = mysqlDriverDependency.get().packageInstance();
            List<Map<String, Object>> dependencies = Push.getDependencies(mysqlDriverPackage);
            for (Map<String, Object> dependency : dependencies) {
                if (!dependency.get("path").toString().contains("mysql-connector")) continue;
                String relativeLibPath = dependency.get("path").toString();
                return mysqlDriverPackage.project().sourceRoot().resolve(relativeLibPath);
            }
        }
        if ((mssqlDriverDependency = resolvedPackageDependencyDependencyGraph.getDirectDependencies((Object)root).stream().filter(resolvedPackageDependency -> resolvedPackageDependency.packageInstance().descriptor().toString().contains("ballerinax/mssql.driver")).findFirst()).isPresent()) {
            Package mssqlDriverPackage = mssqlDriverDependency.get().packageInstance();
            List<Map<String, Object>> dependencies = Push.getDependencies(mssqlDriverPackage);
            for (Map map : dependencies) {
                if (!map.get("path").toString().contains("mssql-jdbc")) continue;
                String relativeLibPath = map.get("path").toString();
                return mssqlDriverPackage.project().sourceRoot().resolve(relativeLibPath);
            }
        }
        if ((postgresqlDriverDependency = resolvedPackageDependencyDependencyGraph.getDirectDependencies((Object)root).stream().filter(resolvedPackageDependency -> resolvedPackageDependency.packageInstance().descriptor().toString().contains("ballerinax/postgresql.driver")).findFirst()).isPresent()) {
            Package postgresqlDriverPackage = postgresqlDriverDependency.get().packageInstance();
            List<Map<String, Object>> dependencies = Push.getDependencies(postgresqlDriverPackage);
            for (Map<String, Object> dependency : dependencies) {
                if (!dependency.get("path").toString().contains("postgresql")) continue;
                String relativeLibPath = dependency.get("path").toString();
                return postgresqlDriverPackage.project().sourceRoot().resolve(relativeLibPath);
            }
        }
        throw new BalException("failed to retrieve driver path in the local cache.");
    }

    private static List<Map<String, Object>> getDependencies(Package driverPackage) {
        ArrayList<Map<String, Object>> dependencies = new ArrayList<Map<String, Object>>();
        for (JvmTarget jvmTarget : JvmTarget.values()) {
            PackageManifest.Platform platform = driverPackage.manifest().platform(jvmTarget.code());
            if (platform == null) continue;
            dependencies.addAll(platform.dependencies());
        }
        return dependencies;
    }

    /*
     * Loose catch block
     */
    private /* synthetic */ void lambda$execute$2(String packageName, Project balProject, Path file) {
        block48: {
            PersistConfiguration persistConfigurations;
            Path generatedSourceDirPath;
            Module entityModule;
            String submodule = "";
            try {
                BalProjectUtils.validateSchemaFile(file);
                entityModule = BalProjectUtils.getEntities(file);
                generatedSourceDirPath = Paths.get(this.sourcePath, "generated");
                HashMap<String, String> persistConfig = TomlSyntaxUtils.readBallerinaTomlConfig(Paths.get(this.sourcePath, "Ballerina.toml"));
                if (!persistConfig.get("targetModule").equals(packageName)) {
                    if (!persistConfig.get("targetModule").startsWith(packageName + ".")) {
                        this.errStream.println("ERROR: invalid module name : '" + persistConfig.get("module") + "' :\nmodule name should follow the template <package_name>.<module_name>");
                        return;
                    }
                    submodule = persistConfig.get("targetModule").split("\\.")[1];
                    if (!ProjectUtils.validateModuleName((String)submodule)) {
                        this.errStream.println("ERROR: invalid module name : '" + submodule + "' :\nmodule name can only contain alphanumerics, underscores and periods");
                        return;
                    }
                    if (!ProjectUtils.validateNameLength((String)submodule)) {
                        this.errStream.println("ERROR: invalid module name : '" + submodule + "' :\nmaximum length of module name is 256 characters");
                        return;
                    }
                    generatedSourceDirPath = generatedSourceDirPath.resolve(submodule);
                }
                if (entityModule.getEntityMap().isEmpty()) {
                    this.errStream.printf("ERROR: the model definition file(%s) does not contain any valid entity.%n", file.getFileName());
                    return;
                }
            }
            catch (BalException e) {
                this.errStream.printf("ERROR: failed to read entity definitions. %s%n", e.getMessage());
                return;
            }
            try {
                Path ballerinaTomlPath = Paths.get(this.sourcePath, "Ballerina.toml");
                persistConfigurations = TomlSyntaxUtils.readDatabaseConfigurations(ballerinaTomlPath);
            }
            catch (BalException e) {
                this.errStream.printf("ERROR: failed to load db configurations for the data model(%s). %s%n ", entityModule.getModuleName(), e.getMessage());
                return;
            }
            try {
                Throwable throwable2222;
                JdbcDriverLoader driverLoader = this.getJdbcDriverLoader(balProject);
                try {
                    Driver driver;
                    block45: {
                        driver = this.getJdbcDriver(driverLoader);
                        String query = String.format(this.createDatabaseSqlFormat, persistConfigurations.getDbConfig().getDatabase());
                        try (Connection connection = this.getDBConnection(driver, persistConfigurations, false);){
                            ScriptRunner sr = new ScriptRunner(connection);
                            sr.runQuery(query);
                        }
                        catch (SQLException e) {
                            if (this.datastore.equals("postgresql") && e.getMessage().contains("already exists")) break block45;
                            this.errStream.printf("ERROR: failed to create the database(%s). %s%n", persistConfigurations.getDbConfig().getDatabase(), e.getMessage());
                            if (driverLoader != null) {
                                driverLoader.close();
                            }
                            return;
                        }
                    }
                    this.errStream.printf("Created database '%s'.%n", persistConfigurations.getDbConfig().getDatabase());
                    String sqlFilePath = generatedSourceDirPath.resolve("script.sql").toAbsolutePath().toString();
                    try (Connection connection = this.getDBConnection(driver, persistConfigurations, true);
                         BufferedReader fileReader = new BufferedReader(new FileReader(sqlFilePath, StandardCharsets.UTF_8));){
                        ScriptRunner sr = new ScriptRunner(connection);
                        sr.runScript(fileReader);
                    }
                    catch (IOException e) {
                        this.errStream.printf("ERROR: failed to read SQL schema file(%s). %s%n ", sqlFilePath, e.getMessage());
                        if (driverLoader != null) {
                            driverLoader.close();
                        }
                        return;
                    }
                    catch (Exception e) {
                        block47: {
                            this.errStream.printf("ERROR: failed to read the SQL schema file(%s). %s%n", sqlFilePath, e.getMessage());
                            if (driverLoader == null) break block47;
                            driverLoader.close();
                        }
                        return;
                    }
                    this.errStream.printf("Created tables for definition in %s in the database '%s'. %n", file.getFileName(), persistConfigurations.getDbConfig().getDatabase());
                    break block48;
                    {
                        catch (Throwable throwable2222) {
                            throw throwable2222;
                        }
                    }
                }
                finally {
                    if (driverLoader != null) {
                        try {
                            driverLoader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2222.addSuppressed(throwable3);
                        }
                    }
                }
            }
            catch (BalException e) {
                this.errStream.printf("ERROR: failed to execute the SQL scripts for the definition file(%s). %s%n", file.getFileName(), e.getMessage());
            }
            catch (IOException e) {
                this.errStream.printf("ERROR: failed to load the database driver. %s%n", e.getMessage());
            }
        }
    }
}

