/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.inflector;

import io.ballerina.persist.inflector.Singularizer;
import java.util.Arrays;
import java.util.Locale;

public class CaseConverter {
    private CaseConverter() {
    }

    public static String toPascalCase(String word) {
        return CaseConverter.arrayToPascalCase(CaseConverter.split(word));
    }

    public static String toCamelCase(String word) {
        String pascalsCase = CaseConverter.arrayToPascalCase(CaseConverter.split(word));
        return pascalsCase.substring(0, 1).toLowerCase(Locale.ENGLISH) + pascalsCase.substring(1);
    }

    public static String toSingularPascalCase(String word) {
        String[] words = CaseConverter.split(word);
        words = (String[])Arrays.stream(words).map(Singularizer::singularize).toArray(String[]::new);
        return CaseConverter.arrayToPascalCase(words);
    }

    private static String arrayToPascalCase(String[] words) {
        StringBuilder result = new StringBuilder();
        for (String item : words) {
            if (item.isEmpty()) continue;
            result.append(Character.toUpperCase(item.charAt(0)));
            result.append(item.substring(1).toLowerCase(Locale.ENGLISH));
        }
        return result.toString();
    }

    private static String[] split(String value) {
        String splitUpperUpperRe = "([\\p{Ll}\\d])(\\p{Lu})";
        String splitLowerUpperRe = "([\\p{Ll}\\d])(\\p{Lu})";
        String splitReplaceValue = "$1\u0000$2";
        String result = value.replaceAll(splitLowerUpperRe, splitReplaceValue).replaceAll(splitUpperUpperRe, splitReplaceValue);
        String defaultStripRegexp = "[^\\p{L}\\d]+";
        result = result.replaceAll(defaultStripRegexp, "\u0000");
        int start = 0;
        int end = result.length();
        while (result.charAt(start) == '\u0000') {
            ++start;
        }
        while (result.charAt(end - 1) == '\u0000') {
            --end;
        }
        return (String[])Arrays.stream(result.substring(start, end).split("\u0000")).map(String::trim).map(String::toLowerCase).toArray(String[]::new);
    }

    public static String toUpperSnakeCase(String word) {
        CharSequence[] words = CaseConverter.split(word);
        words = (String[])Arrays.stream(words).map(String::toUpperCase).toArray(String[]::new);
        return String.join((CharSequence)"_", words);
    }
}

