/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.introspect;

import io.ballerina.persist.BalException;
import io.ballerina.persist.configuration.PersistConfiguration;
import io.ballerina.persist.inflector.CaseConverter;
import io.ballerina.persist.inflector.Pluralizer;
import io.ballerina.persist.introspectiondto.SqlColumn;
import io.ballerina.persist.introspectiondto.SqlEnum;
import io.ballerina.persist.introspectiondto.SqlForeignKey;
import io.ballerina.persist.introspectiondto.SqlTable;
import io.ballerina.persist.models.Entity;
import io.ballerina.persist.models.EntityField;
import io.ballerina.persist.models.Enum;
import io.ballerina.persist.models.EnumMember;
import io.ballerina.persist.models.Index;
import io.ballerina.persist.models.Module;
import io.ballerina.persist.models.Relation;
import io.ballerina.persist.models.SqlType;
import io.ballerina.persist.nodegenerator.DriverResolver;
import io.ballerina.persist.utils.DatabaseConnector;
import io.ballerina.persist.utils.JdbcDriverLoader;
import io.ballerina.persist.utils.ScriptRunner;
import io.ballerina.projects.Project;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class Introspector {
    protected DatabaseConnector databaseConnector;
    protected PersistConfiguration persistConfigurations;
    private List<SqlTable> tables;
    private List<SqlEnum> sqlEnums;
    private final Module.Builder moduleBuilder;
    private final Map<String, Entity> entityMap;
    private final List<SqlForeignKey> sqlForeignKeys;
    protected PrintStream errStream = System.err;

    protected abstract String getTablesQuery();

    protected abstract String getColumnsQuery(String var1);

    protected abstract String getIndexesQuery(String var1);

    protected abstract String getForeignKeysQuery(String var1);

    protected abstract String getEnumsQuery();

    protected abstract String getBalType(SqlType var1);

    protected abstract boolean isEnumType(SqlColumn var1);

    protected abstract List<String> extractEnumValues(String var1);

    protected Introspector() {
        this.tables = new ArrayList<SqlTable>();
        this.entityMap = new HashMap<String, Entity>();
        this.sqlForeignKeys = new ArrayList<SqlForeignKey>();
        this.sqlEnums = new ArrayList<SqlEnum>();
        this.moduleBuilder = Module.newBuilder("db");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Module introspectDatabase(PersistConfiguration persistConfiguration) throws BalException {
        this.persistConfigurations = persistConfiguration;
        DriverResolver driverResolver = new DriverResolver(this.persistConfigurations.getSourcePath(), this.persistConfigurations.getProvider());
        try {
            Project driverProject = driverResolver.resolveDriverDependencies();
            try (Connection connection = this.prepareDatabaseConnection(driverProject);){
                this.readDatabaseSchema(connection);
            }
            catch (SQLException e) {
                throw new BalException("failed to read database schema: " + e.getMessage());
            }
            this.mapDatabaseSchemaToModule();
            Module module = this.moduleBuilder.build();
            return module;
        }
        finally {
            driverResolver.deleteDriverFile();
        }
    }

    private Connection prepareDatabaseConnection(Project driverProject) throws BalException {
        JdbcDriverLoader driverLoader = this.databaseConnector.getJdbcDriverLoader(driverProject);
        Driver driver = this.databaseConnector.getJdbcDriver(driverLoader);
        try {
            return this.databaseConnector.getConnection(driver, this.persistConfigurations, true);
        }
        catch (SQLException e) {
            throw new BalException("failed to connect to the database: " + e.getMessage());
        }
    }

    public void readDatabaseSchema(Connection connection) throws SQLException {
        ScriptRunner sr = new ScriptRunner(connection);
        this.tables = sr.getSQLTables(this.getTablesQuery());
        this.sqlEnums = sr.getSQLEnums(this.getEnumsQuery());
        for (SqlTable table : this.tables) {
            sr.readColumnsOfSQLTable(table, this.getColumnsQuery(table.getTableName()));
            this.sqlForeignKeys.addAll(sr.readForeignKeysOfSQLTable(table, this.getForeignKeysQuery(table.getTableName())));
            sr.readIndexesOfSQLTable(table, this.getIndexesQuery(table.getTableName()));
        }
    }

    public void mapDatabaseSchemaToModule() throws BalException {
        this.mapEnums();
        this.mapEntities();
        this.entityMap.forEach(this.moduleBuilder::addEntity);
    }

    private void mapEnums() {
        this.sqlEnums.forEach(sqlEnum -> {
            String enumName = this.createEnumName(sqlEnum.getEnumTableName(), sqlEnum.getEnumColumnName());
            Enum.Builder enumBuilder = Enum.newBuilder(enumName);
            this.extractEnumValues(sqlEnum.getFullEnumText()).forEach(enumValue -> enumBuilder.addMember(new EnumMember(CaseConverter.toUpperSnakeCase(enumValue), (String)enumValue)));
            this.moduleBuilder.addEnum(enumName, enumBuilder.build());
        });
    }

    private void mapEntities() throws BalException {
        HashMap<String, Entity.Builder> entityBuilderMap = new HashMap<String, Entity.Builder>();
        this.tables.forEach(table -> {
            String entityName = CaseConverter.toSingularPascalCase(table.getTableName());
            Entity.Builder entityBuilder = Entity.newBuilder(entityName);
            entityBuilder.setTableName(table.getTableName());
            ArrayList<EntityField> keys = new ArrayList<EntityField>();
            ArrayList fields = new ArrayList();
            table.getColumns().forEach(column -> {
                EntityField.Builder fieldBuilder = EntityField.newBuilder(CaseConverter.toCamelCase(column.getColumnName()));
                fieldBuilder.setFieldColumnName(column.getColumnName());
                fieldBuilder.setArrayType(false);
                if (this.isEnumType((SqlColumn)column)) {
                    fieldBuilder.setType(this.createEnumName(table.getTableName(), column.getColumnName()));
                } else {
                    String maxLen = column.getCharacterMaximumLength();
                    SqlType sqlType = new SqlType(column.getDataType().toUpperCase(Locale.ENGLISH), column.getFullDataType(), column.getColumnDefault(), column.getNumericPrecision() != null ? Integer.parseInt(column.getNumericPrecision()) : 0, column.getNumericScale() != null ? Integer.parseInt(column.getNumericScale()) : 0, maxLen != null ? Integer.parseUnsignedInt(maxLen) : 0, this.persistConfigurations.getProvider());
                    String balType = this.getBalType(sqlType);
                    fieldBuilder.setType(balType);
                    fieldBuilder.setSqlType(sqlType);
                    fieldBuilder.setArrayType(sqlType.isArrayType());
                }
                fieldBuilder.setOptionalType(column.getIsNullable().equals("YES"));
                fieldBuilder.setIsDbGenerated(column.isDbGenerated());
                EntityField entityField = fieldBuilder.build();
                entityBuilder.addField(entityField);
                fields.add(entityField);
                if (column.getIsPrimaryKey().booleanValue()) {
                    keys.add(entityField);
                }
            });
            table.getIndexes().forEach(sqlIndex -> {
                ArrayList<EntityField> indexFields = new ArrayList<EntityField>();
                sqlIndex.getColumnNames().forEach(columnName -> fields.forEach(entityField -> {
                    if (entityField.getFieldColumnName().equals(columnName)) {
                        indexFields.add((EntityField)entityField);
                    }
                }));
                Index index = new Index(sqlIndex.getIndexName(), indexFields, sqlIndex.getUnique());
                if (index.isUnique()) {
                    entityBuilder.addUniqueIndex(index);
                } else {
                    entityBuilder.addIndex(index);
                }
            });
            entityBuilder.setKeys(keys);
            entityBuilderMap.put(entityBuilder.getEntityName(), entityBuilder);
        });
        HashMap<CallSite, Integer> ownerFieldNames = new HashMap<CallSite, Integer>();
        HashMap<CallSite, Integer> assocFieldNames = new HashMap<CallSite, Integer>();
        for (SqlForeignKey sqlForeignKey : this.sqlForeignKeys) {
            Object assocFieldName;
            Entity.Builder ownerEntityBuilder = (Entity.Builder)entityBuilderMap.get(CaseConverter.toSingularPascalCase(sqlForeignKey.getTableName()));
            Entity.Builder assocEntityBuilder = (Entity.Builder)entityBuilderMap.get(CaseConverter.toSingularPascalCase(sqlForeignKey.getReferencedTableName()));
            if (!new HashSet<String>(sqlForeignKey.getReferencedColumnNames()).containsAll(assocEntityBuilder.getKeys().stream().map(EntityField::getFieldColumnName).toList())) {
                throw new BalException("bal persist does not support foreign key references to unique keys.");
            }
            boolean isReferenceMany = this.inferRelationshipCardinality(ownerEntityBuilder.build(), sqlForeignKey) == Relation.RelationType.MANY;
            Object object = assocFieldName = isReferenceMany ? Pluralizer.pluralize(ownerEntityBuilder.getEntityName().toLowerCase(Locale.ENGLISH)) : ownerEntityBuilder.getEntityName().toLowerCase(Locale.ENGLISH);
            if (assocFieldNames.containsKey(assocEntityBuilder.getEntityName() + (String)assocFieldName)) {
                assocFieldNames.put((CallSite)((Object)(assocEntityBuilder.getEntityName() + (String)assocFieldName)), (Integer)assocFieldNames.get(assocEntityBuilder.getEntityName() + (String)assocFieldName) + 1);
                assocFieldName = (String)assocFieldName + String.valueOf(assocFieldNames.get(assocEntityBuilder.getEntityName() + (String)assocFieldName));
            } else {
                assocFieldNames.put((CallSite)((Object)(assocEntityBuilder.getEntityName() + (String)assocFieldName)), 0);
            }
            EntityField.Builder assocFieldBuilder = EntityField.newBuilder((String)assocFieldName);
            assocFieldBuilder.setType(ownerEntityBuilder.getEntityName());
            Object ownerFieldName = assocEntityBuilder.getEntityName().toLowerCase(Locale.ENGLISH);
            if (ownerFieldNames.containsKey(ownerEntityBuilder.getEntityName() + (String)ownerFieldName)) {
                ownerFieldNames.put((CallSite)((Object)(ownerEntityBuilder.getEntityName() + (String)ownerFieldName)), (Integer)ownerFieldNames.get(ownerEntityBuilder.getEntityName() + (String)ownerFieldName) + 1);
                ownerFieldName = (String)ownerFieldName + String.valueOf(ownerFieldNames.get(ownerEntityBuilder.getEntityName() + (String)ownerFieldName));
            } else {
                ownerFieldNames.put((CallSite)((Object)(ownerEntityBuilder.getEntityName() + (String)ownerFieldName)), 0);
            }
            EntityField.Builder ownerFieldBuilder = EntityField.newBuilder((String)ownerFieldName);
            ownerFieldBuilder.setType(assocEntityBuilder.getEntityName());
            assocFieldBuilder.setArrayType(isReferenceMany);
            assocFieldBuilder.setOptionalType(!isReferenceMany);
            ownerFieldBuilder.setRelationRefs(sqlForeignKey.getColumnNames().stream().map(columnName -> ownerEntityBuilder.build().getFieldByColumnName((String)columnName).getFieldName()).toList());
            EntityField ownerField = ownerFieldBuilder.build();
            assocEntityBuilder.addField(assocFieldBuilder.build());
            ownerEntityBuilder.addField(ownerField);
        }
        entityBuilderMap.forEach((key, value) -> this.entityMap.put((String)key, value.build()));
    }

    private String createEnumName(String tableName, String columnName) {
        return CaseConverter.toSingularPascalCase(tableName) + CaseConverter.toSingularPascalCase(columnName);
    }

    private Relation.RelationType inferRelationshipCardinality(Entity ownerEntity, SqlForeignKey foreignKey) {
        ArrayList ownerColumns = new ArrayList();
        foreignKey.getColumnNames().forEach(columnName -> ownerColumns.add(ownerEntity.getFieldByColumnName((String)columnName)));
        boolean isUniqueIndexPresent = ownerEntity.getUniqueIndexes().stream().anyMatch(index -> index.getFields().equals(ownerColumns));
        if (ownerEntity.getKeys().equals(ownerColumns)) {
            return Relation.RelationType.ONE;
        }
        if (isUniqueIndexPresent) {
            return Relation.RelationType.ONE;
        }
        return Relation.RelationType.MANY;
    }

    protected String getBalTypeForCommonDataTypes(SqlType sqlType) {
        return switch (sqlType.getTypeName()) {
            case "INT", "INTEGER", "TINYINT", "SMALLINT", "MEDIUMINT", "BIGINT", "SERIAL", "BIGSERIAL", "INT4", "INT2", "INT8" -> "int";
            case "BOOLEAN", "BOOL" -> "boolean";
            case "DECIMAL", "NUMERIC" -> "decimal";
            case "DOUBLE", "FLOAT", "FLOAT4", "FLOAT8" -> "float";
            case "DATE" -> "time:Date";
            case "TIME", "TIMETZ" -> "time:TimeOfDay";
            case "TIMESTAMP", "TIMESTAMPTZ" -> "time:Utc";
            case "DATETIME2", "DATETIME" -> "time:Civil";
            case "VARCHAR", "CHAR", "CHARACTER", "BPCHAR", "TEXT", "MEDIUMTEXT", "LONGTEXT", "TINYTEXT" -> "string";
            case "LONGBLOB", "MEDIUMBLOB", "TINYBLOB", "BINARY", "VARBINARY", "BLOB", "BYTEA" -> "byte";
            default -> {
                this.errStream.println("WARNING Unsupported SQL type found: " + sqlType.getFullDataType());
                yield "Unsupported";
            }
        };
    }
}

