/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.introspect;

import io.ballerina.persist.introspect.Introspector;
import io.ballerina.persist.introspectiondto.SqlColumn;
import io.ballerina.persist.models.SqlType;
import io.ballerina.persist.utils.DatabaseConnector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MySqlIntrospector
extends Introspector {
    public MySqlIntrospector() {
        this.databaseConnector = new DatabaseConnector("jdbc:%s://%s:%s/%s", "com.mysql.cj.jdbc.Driver");
    }

    @Override
    public String getTablesQuery() {
        String formatQuery = "SELECT DISTINCT\n    table_info.table_name AS table_name,\n    table_info.create_options AS create_options,\n    table_info.table_comment AS table_comment\nFROM\n    information_schema.tables AS table_info\n    JOIN information_schema.columns AS column_info\n    ON column_info.table_name = table_info.table_name\nWHERE\n    table_info.table_schema= '%s' AND\n    column_info.table_schema = '%s' AND\n    table_info.table_type = 'BASE TABLE'\nORDER BY\n    table_info.table_name;\n";
        formatQuery = formatQuery.replace("\r\n", "%n");
        return String.format(formatQuery, this.persistConfigurations.getDbConfig().getDatabase(), this.persistConfigurations.getDbConfig().getDatabase());
    }

    @Override
    public String getColumnsQuery(String tableName) {
        String formatQuery = "SELECT\n    column_name column_name,\n    data_type data_type,\n    column_type full_data_type,\n    character_maximum_length character_maximum_length,\n    numeric_precision numeric_precision,\n    numeric_scale numeric_scale,\n    datetime_precision datetime_precision,\n    column_default column_default,\n    is_nullable is_nullable,\n    extra extra,\n    table_name table_name,\n    column_key column_key,\n    IF(column_comment = '', NULL, column_comment) AS column_comment,\n    IF(extra = 'auto_increment', 1, 0) AS dbgenerated,\n    NULL AS check_constraint\nFROM\n    information_schema.columns\nWHERE\n    table_schema = '%s'\n    AND table_name = '%s'\nORDER BY\n    ordinal_position ASC;\n";
        formatQuery = formatQuery.replace("\r\n", "%n");
        return String.format(formatQuery, this.persistConfigurations.getDbConfig().getDatabase(), tableName);
    }

    @Override
    public String getIndexesQuery(String tableName) {
        String formatQuery = "SELECT\n    table_name AS table_name,\n    index_name AS index_name,\n    column_name AS column_name,\n    seq_in_index AS seq_in_index,\n    collation AS column_order,\n    IF(non_unique = '1', 0, 1) AS is_unique\nFROM\n    information_schema.statistics\nWHERE\n    table_schema = '%s'\n    AND table_name = '%s'\n    AND index_name != 'PRIMARY'\nORDER BY\n    BINARY index_name,\n    seq_in_index;\n";
        formatQuery = formatQuery.replace("\r\n", "%n");
        return String.format(formatQuery, this.persistConfigurations.getDbConfig().getDatabase(), tableName);
    }

    @Override
    public String getForeignKeysQuery(String tableName) {
        String formatQuery = "SELECT\n    kcu.constraint_name constraint_name,\n    kcu.column_name column_name,\n    kcu.referenced_table_name referenced_table_name,\n    kcu.referenced_column_name referenced_column_name,\n    kcu.ordinal_position ordinal_position,\n    kcu.table_name table_name,\n    rc.delete_rule delete_rule,\n    rc.update_rule update_rule\nFROM\n    information_schema.key_column_usage AS kcu\n    INNER JOIN information_schema.referential_constraints AS rc ON\n    BINARY kcu.constraint_name = BINARY rc.constraint_name\nWHERE\n    BINARY kcu.table_schema = '%s'\n    AND rc.constraint_schema = '%s'\n    AND kcu.table_name = '%s'\n    AND kcu.referenced_column_name IS NOT NULL\nORDER BY\n    BINARY kcu.table_schema,\n    BINARY kcu.table_name,\n    BINARY kcu.constraint_name,\n    kcu.ordinal_position;\n";
        formatQuery = formatQuery.replace("\r\n", "%n");
        return String.format(formatQuery, this.persistConfigurations.getDbConfig().getDatabase(), this.persistConfigurations.getDbConfig().getDatabase(), tableName);
    }

    @Override
    protected String getEnumsQuery() {
        String formatQuery = "SELECT\n    column_name column_name,\n    column_type full_enum_type,\n    table_name table_name\nFROM\n    information_schema.columns\nWHERE\n    table_schema = '%s'\n    AND data_type = 'enum'\nORDER BY\n    ordinal_position ASC;\n";
        formatQuery = formatQuery.replace("\r\n", "%n");
        return String.format(formatQuery, this.persistConfigurations.getDbConfig().getDatabase());
    }

    @Override
    protected boolean isEnumType(SqlColumn column) {
        return "enum".equalsIgnoreCase(column.getDataType());
    }

    @Override
    protected List<String> extractEnumValues(String enumString) {
        ArrayList<String> enumValues = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\((.*?)\\)");
        Matcher matcher = pattern.matcher(enumString);
        if (matcher.find()) {
            String valuesInsideParentheses = matcher.group(1);
            String[] valuesArray = valuesInsideParentheses.split(",");
            Arrays.stream(valuesArray).map(value -> {
                value = value.trim();
                value = value.replace("'", "");
                return value.trim();
            }).forEach(enumValues::add);
        }
        return enumValues;
    }

    @Override
    protected String getBalType(SqlType sqlType) {
        if (Objects.equals(sqlType.getFullDataType(), "tinyint(1)")) {
            return "boolean";
        }
        return this.getBalTypeForCommonDataTypes(sqlType);
    }
}

