/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.models;

import io.ballerina.persist.inflector.Pluralizer;
import io.ballerina.persist.models.EntityField;
import io.ballerina.persist.models.Index;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class Entity {
    private final List<EntityField> keys;
    private final String tableName;
    private final String schemaName;
    private final String entityName;
    private List<EntityField> fields;
    private final List<Index> indexes;
    private final List<Index> uniqueIndexes;
    private final boolean containsUnsupportedTypes;

    private Entity(String entityName, List<EntityField> keys, String resourceName, String schemaName, List<EntityField> fields, List<Index> indexes, List<Index> uniqueIndexes, boolean containsUnsupportedTypes) {
        this.entityName = entityName;
        this.keys = Collections.unmodifiableList(keys);
        this.tableName = resourceName;
        this.schemaName = schemaName;
        this.fields = Collections.unmodifiableList(fields);
        this.indexes = Collections.unmodifiableList(indexes);
        this.uniqueIndexes = Collections.unmodifiableList(uniqueIndexes);
        this.containsUnsupportedTypes = containsUnsupportedTypes;
    }

    public List<EntityField> getKeys() {
        return this.keys;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public List<EntityField> getFields() {
        return this.fields;
    }

    public String getClientResourceName() {
        return Pluralizer.pluralize(this.entityName.toLowerCase(Locale.ENGLISH));
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public List<Index> getUniqueIndexes() {
        return this.uniqueIndexes;
    }

    public EntityField getFieldByName(String fieldName) {
        for (EntityField field : this.fields) {
            if (!field.getFieldName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public boolean containsUnsupportedTypes() {
        return this.containsUnsupportedTypes;
    }

    public EntityField getFieldByColumnName(String columnName) {
        for (EntityField field : this.fields) {
            if (!field.getFieldColumnName().equals(columnName)) continue;
            return field;
        }
        return null;
    }

    public boolean shouldTableMappingGenerated() {
        if (this.tableName == null || this.tableName.isBlank()) {
            return false;
        }
        return !this.entityName.equals(this.tableName);
    }

    public void removeField(String fieldName) {
        ArrayList<EntityField> newFields = new ArrayList<EntityField>(this.fields);
        newFields.removeIf(field -> field.getFieldName().equals(fieldName));
        this.fields = Collections.unmodifiableList(newFields);
    }

    public static Builder newBuilder(String entityName) {
        return new Builder(entityName);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public static class Builder {
        String entityName;
        String tableName = null;
        String schemaName = null;
        List<EntityField> keys;
        List<EntityField> fieldList = null;
        List<Index> indexes;
        List<Index> uniqueIndexes;
        boolean containsUnsupportedTypes = false;

        private Builder(String entityName) {
            this.entityName = entityName;
            this.indexes = new ArrayList<Index>();
            this.uniqueIndexes = new ArrayList<Index>();
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public void setKeys(List<EntityField> keys) {
            this.keys = keys;
        }

        public void addField(EntityField field) {
            if (this.fieldList == null) {
                this.fieldList = new ArrayList<EntityField>();
            }
            this.fieldList.add(field);
        }

        public void addIndex(Index index) {
            this.indexes.add(index);
        }

        public void upsertIndex(String indexName, EntityField field) {
            ArrayList<EntityField> fields = new ArrayList<EntityField>();
            fields.add(field);
            Index existingIndex = this.indexes.stream().filter(i -> i.getIndexName().equals(indexName)).findFirst().orElse(null);
            if (existingIndex != null) {
                existingIndex.addField(field);
            } else {
                Index index = new Index(indexName, fields, false);
                this.indexes.add(index);
            }
        }

        public void upsertUniqueIndex(String indexName, EntityField field) {
            ArrayList<EntityField> fields = new ArrayList<EntityField>();
            fields.add(field);
            Index existingIndex = this.uniqueIndexes.stream().filter(i -> i.getIndexName().equals(indexName)).findFirst().orElse(null);
            if (existingIndex != null) {
                existingIndex.addField(field);
            } else {
                Index index = new Index(indexName, fields, true);
                this.uniqueIndexes.add(index);
            }
        }

        public void addUniqueIndex(Index index) {
            this.uniqueIndexes.add(index);
        }

        public void setContainsUnsupportedTypes(boolean containsUnsupportedTypes) {
            this.containsUnsupportedTypes = containsUnsupportedTypes;
        }

        public Entity build() {
            return new Entity(this.entityName, this.keys, this.tableName, this.schemaName, this.fieldList, this.indexes, this.uniqueIndexes, this.containsUnsupportedTypes);
        }

        public String getEntityName() {
            return this.entityName;
        }

        public List<EntityField> getKeys() {
            return Collections.unmodifiableList(this.keys);
        }
    }
}

