/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.models;

import io.ballerina.persist.models.Entity;
import io.ballerina.persist.models.Enum;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class Module {
    private final Map<String, Entity> entityMap;
    private final Map<String, Enum> enumMap;
    private final String moduleName;
    private final Set<String> importModulePrefixes;

    private Module(String moduleName, Set<String> importModulePrefixes, Map<String, Entity> entityMap, Map<String, Enum> enumMap) {
        this.moduleName = moduleName;
        this.importModulePrefixes = Collections.unmodifiableSet(importModulePrefixes);
        this.entityMap = Collections.unmodifiableMap(entityMap);
        this.enumMap = Collections.unmodifiableMap(enumMap);
    }

    public Map<String, Entity> getEntityMap() {
        return this.entityMap;
    }

    public Map<String, Enum> getEnumMap() {
        return this.enumMap;
    }

    public Set<String> getImportModulePrefixes() {
        return this.importModulePrefixes;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Optional<Entity> getEntityByTableName(String tableName) {
        return this.entityMap.values().stream().filter(item -> item.getTableName().equals(tableName)).findAny();
    }

    public static Builder newBuilder(String moduleName) {
        return new Builder(moduleName);
    }

    public static class Builder {
        String moduleName;
        Map<String, Entity> entityMap = new LinkedHashMap<String, Entity>();
        Map<String, Enum> enumMap = new LinkedHashMap<String, Enum>();
        private final Set<String> importModulePrefixes = new HashSet<String>();

        private Builder(String moduleName) {
            this.moduleName = moduleName;
        }

        public void addEntity(String key, Entity entity) {
            this.entityMap.put(key, entity);
        }

        public void addEnum(String key, Enum enumValue) {
            this.enumMap.put(key, enumValue);
        }

        public Map<String, Enum> getEnumsMap() {
            return this.enumMap;
        }

        public void addImportModulePrefix(String modulePrefix) {
            this.importModulePrefixes.add(modulePrefix);
        }

        public Module build() {
            return new Module(this.moduleName, this.importModulePrefixes, this.entityMap, this.enumMap);
        }
    }
}

