/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.models;

import java.util.Objects;

public class SqlType {
    private final String typeName;
    private final String fullDataType;
    private final String columnDefaultValue;
    private final int numericPrecision;
    private final int numericScale;
    private final int maxLength;
    private final String datastore;

    public SqlType(String typeName, String fullDataType, String columnDefaultValue, int numericPrecision, int numericScale, int maxCharLength, String datastore) {
        this.typeName = typeName;
        this.fullDataType = fullDataType;
        this.columnDefaultValue = columnDefaultValue;
        int precisionValue = 65;
        if (datastore.equals("mssql")) {
            precisionValue = 38;
        }
        this.numericPrecision = numericPrecision > 0 ? numericPrecision : precisionValue;
        this.numericScale = numericScale > 0 ? numericScale : 30;
        this.maxLength = maxCharLength > 0 ? maxCharLength : 191;
        this.datastore = datastore;
    }

    public SqlType(String typeName, String fullDataType, String columnDefaultValue, int numericPrecision, int numericScale, int maxCharLength) {
        this.typeName = typeName;
        this.fullDataType = fullDataType;
        this.columnDefaultValue = columnDefaultValue;
        this.numericPrecision = numericPrecision;
        this.numericScale = numericScale;
        this.maxLength = maxCharLength;
        this.datastore = null;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getNumericPrecision() {
        return this.numericPrecision;
    }

    public int getNumericScale() {
        return this.numericScale;
    }

    public String getColumnDefaultValue() {
        return this.columnDefaultValue;
    }

    public String getDatastore() {
        return this.datastore;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String getFullDataType() {
        return this.fullDataType;
    }

    public boolean isArrayType() {
        return this.typeName.equals("BLOB") || this.typeName.equals("LONGBLOB") || this.typeName.equals("MEDIUMBLOB") || this.typeName.equals("TINYBLOB") || this.typeName.equals("BINARY") || this.typeName.equals("BYTEA") || this.typeName.equals("VARBINARY");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlType sqlType = (SqlType)obj;
        return Objects.equals(this.typeName, sqlType.typeName) && Objects.equals(this.fullDataType, sqlType.fullDataType) && Objects.equals(this.columnDefaultValue, sqlType.columnDefaultValue) && Objects.equals(this.numericPrecision, sqlType.numericPrecision) && Objects.equals(this.numericScale, sqlType.numericScale) && Objects.equals(this.maxLength, sqlType.maxLength);
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.fullDataType, this.columnDefaultValue, this.numericPrecision, this.numericScale, this.maxLength);
    }
}

