/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.nodegenerator;

import io.ballerina.persist.BalException;
import io.ballerina.persist.nodegenerator.syntax.sources.DbModelGenSyntaxTree;
import io.ballerina.persist.utils.BalProjectUtils;
import io.ballerina.projects.Project;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ballerinalang.formatter.core.Formatter;

public class DriverResolver {
    private final Path driverImportFile;
    private final String datastore;

    public DriverResolver(String sourcePath, String datastore) {
        this.driverImportFile = Paths.get(sourcePath, "persist/driver.bal");
        this.datastore = datastore;
    }

    public Project resolveDriverDependencies() throws BalException {
        this.createDriverImportFile();
        return BalProjectUtils.buildDriverFile(this.driverImportFile);
    }

    private void createDriverImportFile() throws BalException {
        DbModelGenSyntaxTree dbModelGenSyntaxTree = new DbModelGenSyntaxTree();
        try {
            this.writeOutputFile(Formatter.format((String)dbModelGenSyntaxTree.createInitialDriverImportFile(this.datastore).toSourceCode()), this.driverImportFile);
        }
        catch (Exception e) {
            throw new BalException("failed to create driver import file: " + e.getMessage());
        }
    }

    private void writeOutputFile(String syntaxTree, Path outPath) throws IOException {
        try (PrintWriter writer = new PrintWriter(outPath.toString(), StandardCharsets.UTF_8);){
            writer.println(syntaxTree);
        }
    }

    public void deleteDriverFile() throws BalException {
        try {
            Files.deleteIfExists(this.driverImportFile);
        }
        catch (IOException e) {
            throw new BalException("failed to delete driver import file: " + e.getMessage());
        }
    }
}

