/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.nodegenerator.syntax.clients;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.persist.BalException;
import io.ballerina.persist.PersistToolsConstants;
import io.ballerina.persist.components.Client;
import io.ballerina.persist.components.Function;
import io.ballerina.persist.components.IfElse;
import io.ballerina.persist.components.TypeDescriptor;
import io.ballerina.persist.models.Entity;
import io.ballerina.persist.models.EntityField;
import io.ballerina.persist.models.Module;
import io.ballerina.persist.models.Relation;
import io.ballerina.persist.nodegenerator.syntax.clients.ClientSyntax;
import io.ballerina.persist.nodegenerator.syntax.constants.BalSyntaxConstants;
import io.ballerina.persist.nodegenerator.syntax.constants.SyntaxTokenConstants;
import io.ballerina.persist.nodegenerator.syntax.utils.BalSyntaxUtils;
import java.util.List;
import java.util.Objects;

public class DbClientSyntax
implements ClientSyntax {
    private final Module entityModule;
    private final String dbNamePrefix;
    private final String importPackage;
    private final String importDriver;
    private final String dbSpecifics;
    private final String nativeClass;
    private final String initDbClientMethodTemplate;
    private final String dataSource;

    public DbClientSyntax(Module entityModule, String datasource) throws BalException {
        this.entityModule = entityModule;
        this.dataSource = datasource;
        this.dbNamePrefix = PersistToolsConstants.SUPPORTED_VIA_JDBC_CONNECTOR.contains(datasource) ? "jdbc" : datasource;
        this.importPackage = PersistToolsConstants.SUPPORTED_VIA_JDBC_CONNECTOR.contains(datasource) ? "java.jdbc" : datasource;
        switch (datasource) {
            case "mysql": {
                this.importDriver = "mysql.driver";
                this.dbSpecifics = "psql:MYSQL_SPECIFICS";
                this.nativeClass = "MySQLProcessor";
                this.initDbClientMethodTemplate = BalSyntaxConstants.INIT_DB_CLIENT_WITH_PARAMS;
                break;
            }
            case "mssql": {
                this.importDriver = "mssql.driver";
                this.dbSpecifics = "psql:MSSQL_SPECIFICS";
                this.nativeClass = "MSSQLProcessor";
                this.initDbClientMethodTemplate = BalSyntaxConstants.INIT_DB_CLIENT_WITH_PARAMS;
                break;
            }
            case "postgresql": {
                this.importDriver = "postgresql.driver";
                this.dbSpecifics = "psql:POSTGRESQL_SPECIFICS";
                this.nativeClass = "PostgreSQLProcessor";
                this.initDbClientMethodTemplate = BalSyntaxConstants.POSTGRESQL_INIT_DB_CLIENT_WITH_PARAMS;
                break;
            }
            case "h2": {
                this.importDriver = "h2.driver";
                this.dbSpecifics = "psql:H2_SPECIFICS";
                this.nativeClass = "H2Processor";
                this.initDbClientMethodTemplate = BalSyntaxConstants.JDBC_URL_INIT_DB_CLIENT_WITH_PARAMS;
                break;
            }
            default: {
                throw new BalException("Unsupported datasource: " + datasource);
            }
        }
    }

    @Override
    public NodeList<ImportDeclarationNode> getImports() throws BalException {
        NodeList imports = BalSyntaxUtils.generateImport(this.entityModule);
        imports = imports.add((Node)BalSyntaxUtils.getImportDeclarationNode("ballerina", "sql", null));
        imports = imports.add((Node)BalSyntaxUtils.getImportDeclarationNode("ballerinax", this.importPackage, null));
        ImportPrefixNode prefix = NodeFactory.createImportPrefixNode((Token)SyntaxTokenConstants.SYNTAX_TREE_AS, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.UNDERSCORE_KEYWORD));
        imports = imports.add((Node)BalSyntaxUtils.getImportDeclarationNode("ballerinax", this.importDriver, prefix));
        IdentifierToken prefixToken = AbstractNodeFactory.createIdentifierToken((String)"psql");
        prefix = NodeFactory.createImportPrefixNode((Token)SyntaxTokenConstants.SYNTAX_TREE_AS, (Token)prefixToken);
        imports = imports.add((Node)BalSyntaxUtils.getImportDeclarationNode("ballerinax", "persist.sql", prefix));
        return imports;
    }

    @Override
    public NodeList<ModuleMemberDeclarationNode> getConstantVariables() {
        return BalSyntaxUtils.generateConstantVariables(this.entityModule);
    }

    @Override
    public Client getClientObject(Module entityModule, String clientName) {
        Client clientObject = BalSyntaxUtils.generateClientSignature(clientName, true);
        clientObject.addMember(NodeParser.parseObjectMember((String)String.format("private final %s:Client dbClient;", this.dbNamePrefix)), true);
        clientObject.addMember(NodeParser.parseObjectMember((String)"private final map<psql:SQLClient> persistClients;"), true);
        clientObject.addMember(this.generateMetadataRecord(entityModule), true);
        return clientObject;
    }

    @Override
    public FunctionDefinitionNode getInitFunction(Module entityModule) {
        Function init = new Function("init", SyntaxKind.OBJECT_METHOD_DEFINITION);
        init.addQualifiers(new String[]{"public", "isolated"});
        init.addReturns((TypeDescriptorNode)TypeDescriptor.getOptionalTypeDescriptorNode("", "persist:Error"));
        init.addStatement(NodeParser.parseStatement((String)String.format(this.initDbClientMethodTemplate, this.dbNamePrefix)));
        IfElse errorCheck = new IfElse(NodeParser.parseExpression((String)String.format("%s is error", "dbClient")));
        errorCheck.addIfStatement(NodeParser.parseStatement((String)String.format("return <persist:Error>error(%s.message());", "dbClient")));
        init.addIfElseStatement(errorCheck.getIfElseStatementNode());
        init.addStatement(NodeParser.parseStatement((String)"self.dbClient = dbClient;"));
        if (PersistToolsConstants.CUSTOM_SCHEMA_SUPPORTED_DB_PROVIDERS.contains(this.dataSource)) {
            init.addStatement(NodeParser.parseStatement((String)"// Update the metadata with the schema name"));
            IfElse schemaCheck = new IfElse(NodeParser.parseExpression((String)String.format("%s != ()", "defaultSchema")));
            schemaCheck.addIfStatement(NodeParser.parseStatement((String)"lock"));
            schemaCheck.addIfStatement(NodeParser.parseStatement((String)"{"));
            schemaCheck.addIfStatement(NodeParser.parseStatement((String)String.format("foreach string key in %s.keys() {", "self.metadata")));
            schemaCheck.addIfStatement(NodeParser.parseStatement((String)"psql:SQLMetadata metadata = self.metadata.get(key);"));
            IfElse schemaNameCheck = new IfElse(NodeParser.parseExpression((String)String.format("%s == ()", "metadata.schemaName")));
            schemaNameCheck.addIfStatement(NodeParser.parseStatement((String)String.format("%s = %s;", "metadata.schemaName", "defaultSchema")));
            schemaCheck.addIfStatement((StatementNode)schemaNameCheck.getIfElseStatementNode());
            schemaCheck.addIfStatement(NodeParser.parseStatement((String)"map<psql:JoinMetadata>? joinMetadataMap = metadata.joinMetadata;"));
            IfElse joinMetadataCheck = new IfElse(NodeParser.parseExpression((String)String.format("%s == ()", BalSyntaxConstants.JOIN_METADATA)));
            joinMetadataCheck.addIfStatement(NodeParser.parseStatement((String)"continue;"));
            schemaCheck.addIfStatement((StatementNode)joinMetadataCheck.getIfElseStatementNode());
            schemaCheck.addIfStatement(NodeParser.parseStatement((String)String.format("foreach [string, psql:JoinMetadata][_, joinMetadata] in %s.entries() {", BalSyntaxConstants.JOIN_METADATA)));
            IfElse joinSchemaNameCheck = new IfElse(NodeParser.parseExpression((String)String.format("%s == ()", "joinMetadata.refSchema")));
            joinSchemaNameCheck.addIfStatement(NodeParser.parseStatement((String)String.format("%s = %s;", "joinMetadata.refSchema", "defaultSchema")));
            schemaCheck.addIfStatement((StatementNode)joinSchemaNameCheck.getIfElseStatementNode());
            schemaCheck.addIfStatement(NodeParser.parseStatement((String)"}"));
            schemaCheck.addIfStatement(NodeParser.parseStatement((String)"}"));
            init.addStatement((StatementNode)schemaCheck.getIfElseStatementNode());
            init.addStatement(NodeParser.parseStatement((String)"}"));
        }
        StringBuilder persistClientMap = new StringBuilder();
        for (Entity entity : entityModule.getEntityMap().values()) {
            if (entity.containsUnsupportedTypes()) continue;
            if (persistClientMap.length() != 0) {
                persistClientMap.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
            }
            String constantName = BalSyntaxUtils.stripEscapeCharacter(BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName()));
            if (PersistToolsConstants.CUSTOM_SCHEMA_SUPPORTED_DB_PROVIDERS.contains(this.dataSource)) {
                persistClientMap.append(String.format("[%s]: check new (dbClient, self.metadata.get(%s).cloneReadOnly(), %s)", constantName, constantName, this.dbSpecifics));
                continue;
            }
            persistClientMap.append(String.format("[%s]: check new (dbClient, self.metadata.get(%s), %s)", constantName, constantName, this.dbSpecifics));
        }
        init.addStatement(NodeParser.parseStatement((String)String.format("self.persistClients = {%s};", persistClientMap)));
        return init.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getGetFunction(Entity entity) {
        return (FunctionDefinitionNode)NodeParser.parseObjectMember((String)String.format(BalSyntaxConstants.EXTERNAL_SQL_GET_METHOD_TEMPLATE, entity.getClientResourceName(), entity.getEntityName(), "sql", this.nativeClass));
    }

    @Override
    public FunctionDefinitionNode getGetByKeyFunction(Entity entity) {
        return BalSyntaxUtils.generateGetByKeyFunction(entity, this.nativeClass, "sql");
    }

    @Override
    public FunctionDefinitionNode getCloseFunction() {
        Function close = BalSyntaxUtils.generateCloseFunction();
        close.addStatement(NodeParser.parseStatement((String)"error? result = self.dbClient.close();"));
        IfElse errorCheck = new IfElse(NodeParser.parseExpression((String)String.format("%s is error", "result")));
        errorCheck.addIfStatement(NodeParser.parseStatement((String)String.format("return <persist:Error>error(%s.message());", "result")));
        close.addIfElseStatement(errorCheck.getIfElseStatementNode());
        close.addStatement(NodeParser.parseStatement((String)"return result;"));
        return close.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getPostFunction(Entity entity) {
        String parameterType = String.format("%sInsert", entity.getEntityName());
        List<EntityField> primaryKeys = entity.getKeys();
        Function create = BalSyntaxUtils.generatePostFunction(entity, primaryKeys, parameterType);
        DbClientSyntax.addFunctionBodyToPostResource(create, primaryKeys, BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName()), parameterType);
        return create.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getPutFunction(Entity entity) {
        StringBuilder filterKeys = new StringBuilder("{");
        StringBuilder path = new StringBuilder("/" + entity.getClientResourceName());
        Function update = BalSyntaxUtils.generatePutFunction(entity, filterKeys, path);
        update.addStatement(NodeParser.parseStatement((String)"psql:SQLClient sqlClient;"));
        String getPersistClientStatement = String.format("sqlClient = self.persistClients.get(%s);", BalSyntaxUtils.stripEscapeCharacter(BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName())));
        update.addStatement(NodeParser.parseStatement((String)String.format("lock {%s}", getPersistClientStatement)));
        String updateStatement = entity.getKeys().size() > 1 ? String.format("_ = check sqlClient.runUpdateQuery(%s, value);", filterKeys.substring(0, filterKeys.length() - 2).concat("}")) : String.format("_ = check sqlClient.runUpdateQuery(%s, value);", ((EntityField)entity.getKeys().stream().findFirst().get()).getFieldName());
        update.addStatement(NodeParser.parseStatement((String)updateStatement));
        update.addStatement(NodeParser.parseStatement((String)String.format("return self->%s.get();", path)));
        return update.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getDeleteFunction(Entity entity) {
        StringBuilder filterKeys = new StringBuilder("{");
        StringBuilder path = new StringBuilder("/" + entity.getClientResourceName());
        Function delete = BalSyntaxUtils.generateDeleteFunction(entity, filterKeys, path);
        delete.addStatement(NodeParser.parseStatement((String)String.format("%s result = check self->%s.get();", entity.getEntityName(), path)));
        delete.addStatement(NodeParser.parseStatement((String)"psql:SQLClient sqlClient;"));
        String getPersistClientStatement = String.format("sqlClient = self.persistClients.get(%s);", BalSyntaxUtils.stripEscapeCharacter(BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName())));
        delete.addStatement(NodeParser.parseStatement((String)String.format("lock {%s}", getPersistClientStatement)));
        String deleteStatement = entity.getKeys().size() > 1 ? String.format("_ = check sqlClient.runDeleteQuery(%s);", filterKeys.substring(0, filterKeys.length() - 2).concat("}")) : String.format("_ = check sqlClient.runDeleteQuery(%s);", ((EntityField)entity.getKeys().stream().findFirst().get()).getFieldName());
        delete.addStatement(NodeParser.parseStatement((String)deleteStatement));
        delete.addStatement(NodeParser.parseStatement((String)"return result;"));
        return delete.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getQueryNativeSQLFunction() {
        return (FunctionDefinitionNode)NodeParser.parseObjectMember((String)String.format(BalSyntaxConstants.QUERY_NATIVE_SQL_METHOD_TEMPLATE, this.nativeClass));
    }

    @Override
    public FunctionDefinitionNode getExecuteNativeSQLFunction() {
        return (FunctionDefinitionNode)NodeParser.parseObjectMember((String)String.format(BalSyntaxConstants.EXECUTE_NATIVE_SQL_METHOD_TEMPLATE, this.nativeClass));
    }

    private Node generateMetadataRecord(Module entityModule) {
        StringBuilder mapBuilder = new StringBuilder();
        for (Entity entity : entityModule.getEntityMap().values()) {
            if (entity.containsUnsupportedTypes()) continue;
            if (mapBuilder.length() != 0) {
                mapBuilder.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
            }
            StringBuilder entityMetaData = new StringBuilder();
            entityMetaData.append(String.format(BalSyntaxConstants.METADATA_RECORD_ENTITY_NAME_TEMPLATE, BalSyntaxUtils.stripEscapeCharacter(entity.getEntityName())));
            entityMetaData.append(String.format(BalSyntaxConstants.METADATA_RECORD_TABLE_NAME_TEMPLATE, BalSyntaxUtils.stripEscapeCharacter(entity.getTableName())));
            if (PersistToolsConstants.CUSTOM_SCHEMA_SUPPORTED_DB_PROVIDERS.contains(this.dataSource) && entity.getSchemaName() != null && !entity.getSchemaName().isEmpty()) {
                entityMetaData.append(String.format(BalSyntaxConstants.METADATA_RECORD_SCHEMA_NAME_TEMPLATE, BalSyntaxUtils.stripEscapeCharacter(entity.getSchemaName())));
            }
            StringBuilder fieldMetaData = new StringBuilder();
            StringBuilder associateFieldMetaData = new StringBuilder();
            boolean relationsExists = false;
            for (EntityField entityField : entity.getFields()) {
                if (entityField.getRelation() != null) {
                    relationsExists = true;
                    StringBuilder foreignKeyFields = new StringBuilder();
                    if (entityField.getRelation().isOwner()) {
                        if (fieldMetaData.length() != 0) {
                            fieldMetaData.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
                        }
                        for (Relation.Key key : entityField.getRelation().getKeyColumns()) {
                            if (foreignKeyFields.length() != 0) {
                                foreignKeyFields.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
                            }
                            foreignKeyFields.append(String.format("%s: {columnName: \"%s\"}", key.getField(), BalSyntaxUtils.stripEscapeCharacter(key.getColumnName())));
                        }
                    }
                    fieldMetaData.append((CharSequence)foreignKeyFields);
                    Entity associatedEntity = entityField.getRelation().getAssocEntity();
                    for (EntityField associatedEntityField : associatedEntity.getFields()) {
                        if (associatedEntityField.getRelation() == null) {
                            if (associateFieldMetaData.length() != 0) {
                                associateFieldMetaData.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
                            }
                            if (Objects.equals(associatedEntityField.getFieldName(), associatedEntityField.getFieldColumnName())) {
                                associateFieldMetaData.append(String.format((entityField.isArrayType() ? "\"%s[]" : "\"%s") + ".%s\": {relation: {entityName: \"%s\", refField: \"%s\"}}", BalSyntaxUtils.stripEscapeCharacter(entityField.getFieldName()), BalSyntaxUtils.stripEscapeCharacter(associatedEntityField.getFieldName()), BalSyntaxUtils.stripEscapeCharacter(entityField.getFieldName()), BalSyntaxUtils.stripEscapeCharacter(associatedEntityField.getFieldName())));
                                continue;
                            }
                            associateFieldMetaData.append(String.format((entityField.isArrayType() ? "\"%s[]" : "\"%s") + ".%s\": {relation: {entityName: \"%s\", refField: \"%s\", refColumn: \"%s\"}}", BalSyntaxUtils.stripEscapeCharacter(entityField.getFieldName()), BalSyntaxUtils.stripEscapeCharacter(associatedEntityField.getFieldName()), BalSyntaxUtils.stripEscapeCharacter(entityField.getFieldName()), BalSyntaxUtils.stripEscapeCharacter(associatedEntityField.getFieldName()), BalSyntaxUtils.stripEscapeCharacter(associatedEntityField.getFieldColumnName())));
                            continue;
                        }
                        if (!associatedEntityField.getRelation().isOwner()) continue;
                        for (Relation.Key key : associatedEntityField.getRelation().getKeyColumns()) {
                            if (associateFieldMetaData.length() != 0) {
                                associateFieldMetaData.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
                            }
                            if (Objects.equals(key.getField(), key.getColumnName())) {
                                associateFieldMetaData.append(String.format((entityField.isArrayType() ? "\"%s[]" : "\"%s") + ".%s\": {relation: {entityName: \"%s\", refField: \"%s\"}}", entityField.getFieldName(), key.getField(), BalSyntaxUtils.stripEscapeCharacter(entityField.getFieldName()), BalSyntaxUtils.stripEscapeCharacter(key.getField())));
                                continue;
                            }
                            associateFieldMetaData.append(String.format((entityField.isArrayType() ? "\"%s[]" : "\"%s") + ".%s\": {relation: {entityName: \"%s\", refField: \"%s\", refColumn: \"%s\"}}", entityField.getFieldName(), key.getField(), BalSyntaxUtils.stripEscapeCharacter(entityField.getFieldName()), BalSyntaxUtils.stripEscapeCharacter(key.getField()), BalSyntaxUtils.stripEscapeCharacter(key.getColumnName())));
                        }
                    }
                    continue;
                }
                if (fieldMetaData.length() != 0) {
                    fieldMetaData.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
                }
                if (entityField.isDbGenerated()) {
                    fieldMetaData.append(String.format("%s: {columnName: \"%s\", dbGenerated: %s}", entityField.getFieldName(), BalSyntaxUtils.stripEscapeCharacter(entityField.getFieldColumnName()), "true"));
                    continue;
                }
                fieldMetaData.append(String.format("%s: {columnName: \"%s\"}", entityField.getFieldName(), BalSyntaxUtils.stripEscapeCharacter(entityField.getFieldColumnName())));
            }
            if (associateFieldMetaData.length() > 1) {
                fieldMetaData.append(",");
                fieldMetaData.append((CharSequence)associateFieldMetaData);
            }
            entityMetaData.append(String.format("fieldMetadata: {%s}", fieldMetaData));
            entityMetaData.append(", ");
            StringBuilder keyFields = new StringBuilder();
            for (EntityField key : entity.getKeys()) {
                if (keyFields.length() != 0) {
                    keyFields.append(", ");
                }
                keyFields.append("\"").append(BalSyntaxUtils.stripEscapeCharacter(key.getFieldName())).append("\"");
            }
            entityMetaData.append(String.format("keyFields: [%s]", keyFields));
            if (relationsExists) {
                entityMetaData.append(", ");
                String string = this.getJoinMetaData(entity);
                entityMetaData.append(String.format("joinMetadata: {%s}", string));
            }
            mapBuilder.append(String.format("[%s]: {%s}", BalSyntaxUtils.stripEscapeCharacter(BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName())), entityMetaData));
        }
        Node node = PersistToolsConstants.CUSTOM_SCHEMA_SUPPORTED_DB_PROVIDERS.contains(this.dataSource) ? NodeParser.parseObjectMember((String)String.format("private final record {|psql:SQLMetadata...;|} metadata = {%s};", mapBuilder)) : NodeParser.parseObjectMember((String)String.format("private final record {|psql:SQLMetadata...;|} & readonly metadata = {%s};", mapBuilder));
        return node;
    }

    private String getJoinMetaData(Entity entity) {
        StringBuilder joinMetaData = new StringBuilder();
        for (EntityField entityField : entity.getFields()) {
            StringBuilder refColumns = new StringBuilder();
            StringBuilder joinColumns = new StringBuilder();
            if (entityField.getRelation() == null) continue;
            String relationType = "psql:ONE_TO_ONE";
            Entity associatedEntity = entityField.getRelation().getAssocEntity();
            for (EntityField associatedEntityField : associatedEntity.getFields()) {
                if (!associatedEntityField.getFieldType().equals(entity.getEntityName())) continue;
                if (associatedEntityField.isArrayType() && !entityField.isArrayType()) {
                    relationType = "psql:ONE_TO_MANY";
                    continue;
                }
                if (!associatedEntityField.isArrayType() && entityField.isArrayType()) {
                    relationType = "psql:MANY_TO_ONE";
                    continue;
                }
                if (!associatedEntityField.isArrayType() || !entityField.isArrayType()) continue;
                relationType = "psql:MANY_TO_MANY";
            }
            if (joinMetaData.length() > 0) {
                joinMetaData.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
            }
            for (Relation.Key key : entityField.getRelation().getKeyColumns()) {
                if (joinColumns.length() > 0) {
                    joinColumns.append(",");
                }
                if (refColumns.length() > 0) {
                    refColumns.append(",");
                }
                refColumns.append(String.format("\"%s\"", BalSyntaxUtils.stripEscapeCharacter(key.getReferenceColumnName())));
                joinColumns.append(String.format("\"%s\"", BalSyntaxUtils.stripEscapeCharacter(key.getColumnName())));
            }
            if (PersistToolsConstants.CUSTOM_SCHEMA_SUPPORTED_DB_PROVIDERS.contains(this.dataSource) && entityField.getRelation().getAssocEntity().getSchemaName() != null && !entityField.getRelation().getAssocEntity().getSchemaName().isEmpty()) {
                joinMetaData.append(String.format("%s: {entity: %s, fieldName: \"%s\", refSchema: \"%s\", refTable: \"%s\", refColumns: [%s], joinColumns: [%s], 'type: %s}", entityField.getFieldName(), entityField.getFieldType(), entityField.getFieldName(), entityField.getRelation().getAssocEntity().getSchemaName(), entityField.getRelation().getAssocEntity().getTableName(), refColumns, joinColumns, relationType));
                continue;
            }
            joinMetaData.append(String.format("%s: {entity: %s, fieldName: \"%s\", refTable: \"%s\", refColumns: [%s], joinColumns: [%s], 'type: %s}", entityField.getFieldName(), entityField.getFieldType(), entityField.getFieldName(), entityField.getRelation().getAssocEntity().getTableName(), refColumns, joinColumns, relationType));
        }
        return joinMetaData.toString();
    }

    private static void addFunctionBodyToPostResource(Function create, List<EntityField> primaryKeys, String tableName, String parameterType) {
        create.addStatement(NodeParser.parseStatement((String)"psql:SQLClient sqlClient;"));
        String getPersistClientStatement = String.format("sqlClient = self.persistClients.get(%s);", BalSyntaxUtils.stripEscapeCharacter(tableName));
        create.addStatement(NodeParser.parseStatement((String)String.format("lock {%s}", getPersistClientStatement)));
        if (primaryKeys.get(0).isDbGenerated()) {
            create.addStatement(NodeParser.parseStatement((String)"sql:ExecutionResult[] result = check sqlClient.runBatchInsertQuery(data);"));
            create.addStatement(NodeParser.parseStatement((String)String.format(BalSyntaxConstants.RETURN_CREATED_KEY_AUTO_INCREMENT, "sql:ExecutionResult")));
            create.addStatement(NodeParser.parseStatement((String)String.format(BalSyntaxConstants.RETURN_FILTERED_AUTO_INCREMENT_KEYS, primaryKeys.get(0).getFieldType())));
            return;
        }
        create.addStatement(NodeParser.parseStatement((String)"_ = check sqlClient.runBatchInsertQuery(data);"));
        create.addStatement(NodeParser.parseStatement((String)String.format(BalSyntaxConstants.RETURN_CREATED_KEY, parameterType)));
        StringBuilder filterKeys = new StringBuilder();
        for (int i = 0; i < primaryKeys.size(); ++i) {
            filterKeys.append("inserted.").append(primaryKeys.get(i).getFieldName());
            if (i >= primaryKeys.size() - 1) continue;
            filterKeys.append(",");
        }
        filterKeys = primaryKeys.size() == 1 ? new StringBuilder("\t\t\tselect " + String.valueOf(filterKeys) + ";") : new StringBuilder("\t\t\tselect [" + String.valueOf(filterKeys) + "];");
        create.addStatement(NodeParser.parseStatement((String)filterKeys.toString()));
    }
}

