/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.nodegenerator.syntax.clients;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.persist.components.Client;
import io.ballerina.persist.components.Function;
import io.ballerina.persist.components.IfElse;
import io.ballerina.persist.components.TypeDescriptor;
import io.ballerina.persist.models.Entity;
import io.ballerina.persist.models.EntityField;
import io.ballerina.persist.models.Module;
import io.ballerina.persist.models.QueryMethod;
import io.ballerina.persist.models.Relation;
import io.ballerina.persist.nodegenerator.syntax.clients.ClientSyntax;
import io.ballerina.persist.nodegenerator.syntax.constants.BalSyntaxConstants;
import io.ballerina.persist.nodegenerator.syntax.utils.BalSyntaxUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class InMemoryClientSyntax
implements ClientSyntax {
    public final List<QueryMethod> queryMethodList = new ArrayList<QueryMethod>();
    private StringBuilder primaryKeysTuple = new StringBuilder();
    private StringBuilder primaryKeysRecord = new StringBuilder();
    private final Module entityModule;

    public InMemoryClientSyntax(Module entityModule) {
        this.entityModule = entityModule;
    }

    @Override
    public NodeList<ImportDeclarationNode> getImports() {
        NodeList imports = BalSyntaxUtils.generateImport(this.entityModule);
        imports = imports.add((Node)BalSyntaxUtils.getImportDeclarationNode("ballerinax", "persist.inmemory", null));
        return imports;
    }

    @Override
    public NodeList<ModuleMemberDeclarationNode> getConstantVariables() {
        return BalSyntaxUtils.generateConstantVariables(this.entityModule);
    }

    @Override
    public Client getClientObject(Module entityModule, String clientName) {
        Client clientObject = BalSyntaxUtils.generateClientSignature(clientName, true);
        clientObject.addMember(NodeParser.parseObjectMember((String)"private final map<inmemory:InMemoryClient> persistClients;"), true);
        clientObject.addMember(NodeParser.parseObjectMember((String)""), true);
        return clientObject;
    }

    @Override
    public FunctionDefinitionNode getInitFunction(Module entityModule) {
        Function init = new Function("init", SyntaxKind.OBJECT_METHOD_DEFINITION);
        init.addQualifiers(new String[]{"public", "isolated"});
        init.addReturns((TypeDescriptorNode)TypeDescriptor.getOptionalTypeDescriptorNode("", "persist:Error"));
        init.addStatement(NodeParser.parseStatement((String)InMemoryClientSyntax.generateInMemoryMetadataRecord(entityModule, this.queryMethodList)));
        Collection<Entity> entityArray = entityModule.getEntityMap().values();
        StringBuilder persistClientMap = new StringBuilder();
        for (Entity entity : entityArray) {
            if (persistClientMap.length() != 0) {
                persistClientMap.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
            }
            String inMemoryClientMapElement = String.format("[%s]: check new (metadata.get(%s).cloneReadOnly())", BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName()), BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName()));
            persistClientMap.append(inMemoryClientMapElement);
        }
        init.addStatement(NodeParser.parseStatement((String)String.format("self.persistClients = {%s};", persistClientMap)));
        return init.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getGetFunction(Entity entity) {
        return BalSyntaxUtils.generateGetFunction(entity, "InMemoryProcessor", "inmemory");
    }

    @Override
    public FunctionDefinitionNode getGetByKeyFunction(Entity entity) {
        return BalSyntaxUtils.generateGetByKeyFunction(entity, "InMemoryProcessor", "inmemory");
    }

    @Override
    public FunctionDefinitionNode getCloseFunction() {
        Function close = BalSyntaxUtils.generateCloseFunction();
        close.addStatement(NodeParser.parseStatement((String)"return ();"));
        return close.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getPostFunction(Entity entity) {
        String parameterType = String.format("%sInsert", entity.getEntityName());
        List<EntityField> primaryKeys = entity.getKeys();
        Function create = BalSyntaxUtils.generatePostFunction(entity, primaryKeys, parameterType);
        InMemoryClientSyntax.addFunctionBodyToInMemoryPostResource(create, primaryKeys, entity, parameterType);
        return create.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getPutFunction(Entity entity) {
        this.primaryKeysTuple = new StringBuilder();
        this.primaryKeysRecord = new StringBuilder();
        StringBuilder filterKeys = new StringBuilder("{");
        StringBuilder path = new StringBuilder("/" + entity.getClientResourceName());
        List<EntityField> keys = entity.getKeys();
        if (keys.size() == 1) {
            EntityField primaryKey = keys.get(0);
            this.primaryKeysTuple.append(String.format("%s", primaryKey.getFieldName()));
            this.primaryKeysRecord.append(String.format("%s", primaryKey.getFieldName()));
        } else {
            this.primaryKeysTuple.append("[");
            this.primaryKeysRecord.append("{");
            int iterator = 0;
            for (EntityField field : keys) {
                if (iterator > 0) {
                    this.primaryKeysTuple.append(", ");
                    this.primaryKeysRecord.append(", ");
                }
                this.primaryKeysTuple.append(String.format("%s", field.getFieldName()));
                this.primaryKeysRecord.append(String.format("%s: %s", field.getFieldName(), field.getFieldName()));
                ++iterator;
            }
            this.primaryKeysTuple.append("]");
            this.primaryKeysRecord.append("}");
        }
        Function update = BalSyntaxUtils.generatePutFunction(entity, path, filterKeys);
        update.addStatement(NodeParser.parseStatement((String)"lock"));
        update.addStatement(NodeParser.parseStatement((String)"{"));
        IfElse hasCheck = new IfElse(NodeParser.parseExpression((String)String.format("!%sTable.hasKey(%s)", entity.getClientResourceName(), this.primaryKeysTuple)));
        hasCheck.addIfStatement(NodeParser.parseStatement((String)String.format("\t\treturn persist:getNotFoundError(\"%s\", %s);", entity.getEntityName(), this.primaryKeysRecord)));
        update.addIfElseStatement(hasCheck.getIfElseStatementNode());
        String entityNameInLowerCase = entity.getEntityName().toLowerCase(Locale.ENGLISH);
        update.addStatement(NodeParser.parseStatement((String)String.format(BalSyntaxConstants.GET_UPDATE_RECORD, entity.getEntityName(), entityNameInLowerCase, entity.getClientResourceName(), this.primaryKeysTuple)));
        update.addStatement(NodeParser.parseStatement((String)String.format(BalSyntaxConstants.UPDATE_RECORD_FIELD_VALUE, entityNameInLowerCase)));
        update.addStatement(NodeParser.parseStatement((String)String.format("%sTable.put(%s);", entity.getClientResourceName(), entityNameInLowerCase)));
        update.addStatement(NodeParser.parseStatement((String)String.format("return %s.clone();", entity.getEntityName().toLowerCase(Locale.ENGLISH))));
        update.addStatement(NodeParser.parseStatement((String)"}"));
        return update.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getDeleteFunction(Entity entity) {
        StringBuilder filterKeys = new StringBuilder("{");
        StringBuilder path = new StringBuilder("/" + entity.getClientResourceName());
        Function delete = BalSyntaxUtils.generateDeleteFunction(entity, path, filterKeys);
        delete.addStatement(NodeParser.parseStatement((String)"lock"));
        delete.addStatement(NodeParser.parseStatement((String)"{"));
        IfElse hasCheck = new IfElse(NodeParser.parseExpression((String)String.format("!%sTable.hasKey(%s)", entity.getClientResourceName(), this.primaryKeysTuple)));
        hasCheck.addIfStatement(NodeParser.parseStatement((String)String.format("\t\treturn persist:getNotFoundError(\"%s\", %s);", entity.getEntityName(), this.primaryKeysRecord)));
        delete.addIfElseStatement(hasCheck.getIfElseStatementNode());
        delete.addStatement(NodeParser.parseStatement((String)String.format("return %sTable.remove(%s).clone();", entity.getClientResourceName(), this.primaryKeysTuple)));
        delete.addStatement(NodeParser.parseStatement((String)"}"));
        return delete.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getQueryNativeSQLFunction() {
        throw new UnsupportedOperationException("Query native SQL is not supported for in-memory database");
    }

    @Override
    public FunctionDefinitionNode getExecuteNativeSQLFunction() {
        throw new UnsupportedOperationException("Execute native SQL is not supported for in-memory database");
    }

    private static void addFunctionBodyToInMemoryPostResource(Function create, List<EntityField> primaryKeys, Entity entity, String parameterType) {
        StringBuilder forEachStmt = new StringBuilder();
        forEachStmt.append(String.format(BalSyntaxConstants.FOREACH_STMT_START, parameterType));
        forEachStmt.append("lock");
        forEachStmt.append("{");
        StringBuilder variableArrayType = new StringBuilder();
        StringBuilder filterKeys = new StringBuilder();
        StringBuilder filterKeysRecord = new StringBuilder();
        if (primaryKeys.size() == 1) {
            EntityField primaryKey = primaryKeys.get(0);
            filterKeys.append(String.format("value.%s", primaryKey.getFieldName()));
            filterKeysRecord.append(String.format("value.%s", primaryKey.getFieldName()));
            variableArrayType.append(String.format("%s[]", primaryKey.getFieldType()));
        } else {
            StringBuilder variableType = new StringBuilder();
            filterKeys.append("[");
            filterKeysRecord.append("{");
            variableType.append("[");
            int iterator = 0;
            for (EntityField field : primaryKeys) {
                if (iterator > 0) {
                    filterKeys.append(", ");
                    variableType.append(", ");
                    filterKeysRecord.append(", ");
                }
                filterKeys.append(String.format("value.%s", field.getFieldName()));
                filterKeysRecord.append(String.format("%s: value.%s", field.getFieldName(), field.getFieldName()));
                variableType.append(field.getFieldType());
                ++iterator;
            }
            filterKeys.append("]");
            variableType.append("]");
            filterKeysRecord.append("}");
            variableArrayType.append(String.format("%s[]", variableType));
        }
        forEachStmt.append(String.format("\tif %sTable.hasKey(%s) {", entity.getClientResourceName(), filterKeys));
        forEachStmt.append(String.format(BalSyntaxConstants.HAS_KEY_ERROR, entity.getEntityName(), filterKeysRecord));
        forEachStmt.append(String.format("\t%sTable.put(%s);", entity.getClientResourceName(), "value.clone()"));
        forEachStmt.append("}");
        forEachStmt.append(String.format(BalSyntaxConstants.PUSH_VALUES, filterKeys)).append("}");
        create.addStatement(NodeParser.parseStatement((String)String.format("%s keys = [];", variableArrayType)));
        create.addStatement(NodeParser.parseStatement((String)forEachStmt.toString()));
        create.addStatement(NodeParser.parseStatement((String)"return keys;"));
    }

    private static String generateInMemoryMetadataRecord(Module entityModule, List<QueryMethod> queryMethodList) {
        StringBuilder mapBuilder = new StringBuilder();
        for (Entity entity : entityModule.getEntityMap().values()) {
            if (mapBuilder.length() != 0) {
                mapBuilder.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
            }
            StringBuilder entityMetaData = new StringBuilder();
            entityMetaData.append(String.format(BalSyntaxConstants.METADATA_KEY_FIELDS_TEMPLATE, InMemoryClientSyntax.getPrimaryKeys(entity, true)));
            Object resourceName = BalSyntaxUtils.stripEscapeCharacter(entity.getClientResourceName());
            resourceName = ((String)resourceName).substring(0, 1).toUpperCase(Locale.ENGLISH) + ((String)resourceName).substring(1).toLowerCase(Locale.ENGLISH);
            entityMetaData.append(String.format(BalSyntaxConstants.METADATA_QUERY_TEMPLATE, resourceName));
            StringBuilder associationsMethods = new StringBuilder();
            boolean hasAssociationMethod = false;
            block1: for (EntityField field : entity.getFields()) {
                Relation relation;
                if (field.getRelation() == null || (relation = field.getRelation()).isOwner() || !relation.getRelationType().equals((Object)Relation.RelationType.MANY)) continue;
                Entity assEntity = relation.getAssocEntity();
                for (EntityField entityField : assEntity.getFields()) {
                    if (entityField.getRelation() == null || !entityField.getFieldType().equals(entity.getEntityName()) || !entityField.getRelation().getRelationType().equals((Object)Relation.RelationType.ONE)) continue;
                    hasAssociationMethod = true;
                    if (associationsMethods.length() != 0) {
                        associationsMethods.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
                    }
                    String associateEntityName = BalSyntaxUtils.stripEscapeCharacter(relation.getAssocEntity().getClientResourceName());
                    String associateFieldName = BalSyntaxUtils.stripEscapeCharacter(field.getFieldName());
                    String associateFieldNameCamelCase = associateFieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + associateFieldName.substring(1).toLowerCase(Locale.ENGLISH);
                    associationsMethods.append(String.format("%s: query%s", "\"" + associateFieldName + "\"", entity.getEntityName().concat(associateFieldNameCamelCase)));
                    int referenceIndex = 0;
                    StringBuilder conditionStatement = new StringBuilder();
                    for (String reference : relation.getReferences()) {
                        if (conditionStatement.length() > 1) {
                            conditionStatement.append(" && ");
                        }
                        conditionStatement.append(String.format("'object.%s == value[\"%s\"] ", reference, entity.getKeys().get(referenceIndex).getFieldName()));
                        ++referenceIndex;
                    }
                    QueryMethod queryMethod = new QueryMethod("query" + entity.getEntityName().concat(associateFieldNameCamelCase), relation.getAssocEntity().getEntityName(), String.format(BalSyntaxConstants.RETURN_STATEMENT_FOR_RELATIONAL_ENTITY, associateEntityName, conditionStatement));
                    queryMethodList.add(queryMethod);
                    continue block1;
                }
            }
            if (hasAssociationMethod) {
                entityMetaData.append(String.format("queryOne: queryOne%s,", resourceName));
                entityMetaData.append(String.format("associationsMethods: {%s}", associationsMethods));
            } else {
                String queryOne = String.format("queryOne: queryOne%s,", resourceName);
                queryOne = queryOne.substring(0, queryOne.length() - 1);
                entityMetaData.append(queryOne);
            }
            mapBuilder.append(String.format("[%s]: {%s}", BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName()), entityMetaData));
        }
        return String.format("final map<inmemory:TableMetadata> metadata = {%s};", mapBuilder);
    }

    public static String getPrimaryKeys(Entity entity, boolean addDoubleQuotes) {
        StringBuilder keyFields = new StringBuilder();
        for (EntityField key : entity.getKeys()) {
            if (keyFields.length() != 0) {
                keyFields.append(", ");
            }
            if (addDoubleQuotes) {
                keyFields.append("\"").append(BalSyntaxUtils.stripEscapeCharacter(key.getFieldName())).append("\"");
                continue;
            }
            keyFields.append(BalSyntaxUtils.stripEscapeCharacter(key.getFieldName()));
        }
        return keyFields.toString();
    }
}

