/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.nodegenerator.syntax.sources;

import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.persist.BalException;
import io.ballerina.persist.components.Client;
import io.ballerina.persist.components.ClientResource;
import io.ballerina.persist.models.Entity;
import io.ballerina.persist.models.Module;
import io.ballerina.persist.nodegenerator.syntax.clients.RedisClientSyntax;
import io.ballerina.persist.nodegenerator.syntax.constants.BalSyntaxConstants;
import io.ballerina.persist.nodegenerator.syntax.constants.SyntaxTokenConstants;
import io.ballerina.persist.nodegenerator.syntax.sources.SyntaxTree;
import io.ballerina.persist.nodegenerator.syntax.utils.BalSyntaxUtils;
import io.ballerina.persist.utils.BalProjectUtils;
import io.ballerina.toml.syntax.tree.AbstractNodeFactory;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.IdentifierToken;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.validator.SampleNodeGenerator;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.ArrayList;
import java.util.Collection;

public class RedisSyntaxTree
implements SyntaxTree {
    @Override
    public io.ballerina.compiler.syntax.tree.SyntaxTree getClientSyntax(Module entityModule) throws BalException {
        RedisClientSyntax redisClientSyntax = new RedisClientSyntax(entityModule);
        NodeList<ImportDeclarationNode> imports = redisClientSyntax.getImports();
        NodeList moduleMembers = redisClientSyntax.getConstantVariables();
        Client clientObject = redisClientSyntax.getClientObject(entityModule, "Client");
        Collection<Entity> entityArray = entityModule.getEntityMap().values();
        if (entityArray.size() == 0) {
            throw new BalException("data definition file() does not contain any entities.");
        }
        clientObject.addMember((io.ballerina.compiler.syntax.tree.Node)redisClientSyntax.getInitFunction(entityModule), true);
        ArrayList<ClientResource> resourceList = new ArrayList<ClientResource>();
        for (Entity entity : entityArray) {
            ClientResource resource2 = new ClientResource();
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)redisClientSyntax.getGetFunction(entity), true);
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)redisClientSyntax.getGetByKeyFunction(entity), true);
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)redisClientSyntax.getPostFunction(entity), true);
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)redisClientSyntax.getPutFunction(entity), true);
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)redisClientSyntax.getDeleteFunction(entity), true);
            resourceList.add(resource2);
        }
        resourceList.forEach(resource -> resource.getFunctions().forEach(function -> clientObject.addMember((io.ballerina.compiler.syntax.tree.Node)function, false)));
        clientObject.addMember((io.ballerina.compiler.syntax.tree.Node)redisClientSyntax.getCloseFunction(), true);
        moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)clientObject.getClassDefinitionNode());
        return BalSyntaxUtils.generateSyntaxTree(imports, (NodeList<ModuleMemberDeclarationNode>)moduleMembers);
    }

    @Override
    public io.ballerina.compiler.syntax.tree.SyntaxTree getTestClientSyntax(Module entityModule) throws BalException {
        throw new BalException("Not supported yet.");
    }

    @Override
    public io.ballerina.compiler.syntax.tree.SyntaxTree getDataTypesSyntax(Module entityModule) {
        Collection<Entity> entityArray = entityModule.getEntityMap().values();
        if (entityArray.size() != 0) {
            return BalSyntaxUtils.generateTypeSyntaxTree(entityModule, "redis");
        }
        return null;
    }

    @Override
    public io.ballerina.compiler.syntax.tree.SyntaxTree getDataStoreConfigSyntax() {
        NodeList imports = io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createEmptyNodeList();
        NodeList moduleMembers = io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createEmptyNodeList();
        MinutiaeList commentMinutiaeList = RedisSyntaxTree.createCommentMinutiaeList(String.format("// This file is an auto-generated file by Ballerina persistence layer.", new Object[0]));
        imports = imports.add((io.ballerina.compiler.syntax.tree.Node)RedisSyntaxTree.getImportDeclarationNodeWithAutogeneratedComment("redis", commentMinutiaeList));
        moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)NodeParser.parseModuleMemberDeclaration((String)BalSyntaxConstants.REDIS_CONFIG));
        moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)NodeParser.parseModuleMemberDeclaration((String)BalSyntaxConstants.CACHE_CONFIG));
        io.ballerina.compiler.syntax.tree.IdentifierToken eofToken = io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = io.ballerina.compiler.syntax.tree.NodeFactory.createModulePartNode((NodeList)imports, (NodeList)moduleMembers, (io.ballerina.compiler.syntax.tree.Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)"");
        io.ballerina.compiler.syntax.tree.SyntaxTree balTree = io.ballerina.compiler.syntax.tree.SyntaxTree.from((TextDocument)textDocument);
        return balTree.modifyWith((io.ballerina.compiler.syntax.tree.Node)modulePartNode);
    }

    @Override
    public io.ballerina.compiler.syntax.tree.SyntaxTree getConfigTomlSyntax(String moduleName) {
        io.ballerina.toml.syntax.tree.NodeList<DocumentMemberDeclarationNode> moduleMembers = AbstractNodeFactory.createEmptyNodeList();
        moduleMembers = RedisSyntaxTree.populateConfigNodeList(moduleName, moduleMembers);
        moduleMembers = BalProjectUtils.addNewLine(moduleMembers, 1);
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        DocumentNode documentNode = NodeFactory.createDocumentNode(moduleMembers, (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)documentNode.toSourceCode());
        return io.ballerina.compiler.syntax.tree.SyntaxTree.from((TextDocument)textDocument);
    }

    private static ImportDeclarationNode getImportDeclarationNodeWithAutogeneratedComment(String datasource, MinutiaeList commentMinutiaeList) {
        io.ballerina.compiler.syntax.tree.IdentifierToken orgNameToken = io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createIdentifierToken((String)"ballerinax");
        ImportOrgNameNode importOrgNameNode = io.ballerina.compiler.syntax.tree.NodeFactory.createImportOrgNameNode((io.ballerina.compiler.syntax.tree.Token)orgNameToken, (io.ballerina.compiler.syntax.tree.Token)SyntaxTokenConstants.SYNTAX_TREE_SLASH);
        io.ballerina.compiler.syntax.tree.IdentifierToken moduleNameToken = io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createIdentifierToken((String)datasource);
        SeparatedNodeList moduleNodeList = io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createSeparatedNodeList((io.ballerina.compiler.syntax.tree.Node[])new io.ballerina.compiler.syntax.tree.Node[]{moduleNameToken});
        io.ballerina.compiler.syntax.tree.Token importToken = io.ballerina.compiler.syntax.tree.NodeFactory.createToken((SyntaxKind)SyntaxKind.IMPORT_KEYWORD, (MinutiaeList)commentMinutiaeList, (MinutiaeList)io.ballerina.compiler.syntax.tree.NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createWhitespaceMinutiae((String)" ")}));
        return io.ballerina.compiler.syntax.tree.NodeFactory.createImportDeclarationNode((io.ballerina.compiler.syntax.tree.Token)importToken, (ImportOrgNameNode)importOrgNameNode, (SeparatedNodeList)moduleNodeList, null, (io.ballerina.compiler.syntax.tree.Token)SyntaxTokenConstants.SYNTAX_TREE_SEMICOLON);
    }

    private static io.ballerina.toml.syntax.tree.NodeList<DocumentMemberDeclarationNode> populateConfigNodeList(String moduleName, io.ballerina.toml.syntax.tree.NodeList<DocumentMemberDeclarationNode> moduleMembers) {
        String connectionUri = "redis://localhost:6379";
        String maxAge = "-1";
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createTable((String)(moduleName + ".connectionConfig"), null));
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"connection", (String)connectionUri, null));
        moduleMembers = BalProjectUtils.addNewLine(moduleMembers, 1);
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createTable((String)(moduleName + ".cacheConfig"), null));
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createNumericKV((String)"maxAge", (String)maxAge, null));
        return moduleMembers;
    }

    protected static MinutiaeList createCommentMinutiaeList(String comment) {
        return io.ballerina.compiler.syntax.tree.NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createCommentMinutiae((String)"// AUTO-GENERATED FILE. DO NOT MODIFY."), io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createEndOfLineMinutiae((String)System.lineSeparator()), io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createEndOfLineMinutiae((String)System.lineSeparator()), io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createCommentMinutiae((String)comment), io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createEndOfLineMinutiae((String)System.lineSeparator()), io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createCommentMinutiae((String)"// It should not be modified by hand."), io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createEndOfLineMinutiae((String)System.lineSeparator()), io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createEndOfLineMinutiae((String)System.lineSeparator())});
    }
}

