/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.nodegenerator.syntax.utils;

import io.ballerina.persist.BalException;
import io.ballerina.persist.models.Entity;
import io.ballerina.persist.models.EntityField;
import io.ballerina.persist.models.Relation;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;

public class AppScriptUtils {
    private static final String NEW_LINE = System.lineSeparator();
    private static final String TAB = "\t";

    private AppScriptUtils() {
    }

    public static String generateJavaScriptFile(Collection<Entity> entities) throws BalException {
        boolean initialized = false;
        StringBuilder tableScript = new StringBuilder();
        tableScript.append("function createSheets() {").append(NEW_LINE);
        for (Entity entity : entities) {
            String tableName = AppScriptUtils.removeSingleQuote(entity.getEntityName());
            if (!initialized) {
                initialized = true;
                tableScript.append(TAB).append(AppScriptUtils.generateGetActiveScript()).append(NEW_LINE);
                tableScript.append(TAB).append("var ").append(AppScriptUtils.generateGetSheetByName(tableName)).append(NEW_LINE);
            } else {
                tableScript.append(TAB).append(AppScriptUtils.generateGetSheetByName(tableName)).append(NEW_LINE);
            }
            tableScript.append(AppScriptUtils.generateIfExistDelete()).append(NEW_LINE);
            tableScript.append(TAB).append(AppScriptUtils.generateInsertSheet()).append(NEW_LINE);
            tableScript.append(TAB).append(AppScriptUtils.generateSetName(tableName)).append(NEW_LINE);
            tableScript.append(TAB).append(AppScriptUtils.generateAppendRow(entity.getFields())).append(NEW_LINE);
            tableScript.append(NEW_LINE);
        }
        tableScript.append(TAB).append(AppScriptUtils.generateGetSheetByName("Sheet1")).append(NEW_LINE);
        tableScript.append(AppScriptUtils.generateIfExistDelete()).append(NEW_LINE);
        tableScript.append("}").append(NEW_LINE);
        return tableScript.toString();
    }

    private static String removeSingleQuote(String fieldName) {
        if (fieldName.startsWith("'")) {
            return fieldName.substring(1);
        }
        return fieldName;
    }

    private static String generateGetActiveScript() {
        return "var activeSpreadsheet = SpreadsheetApp.getActiveSpreadsheet();";
    }

    private static String generateGetSheetByName(String tableName) {
        return MessageFormat.format("yourNewSheet = activeSpreadsheet.getSheetByName(\"{0}\");", tableName);
    }

    private static String generateIfExistDelete() {
        StringBuilder script = new StringBuilder();
        script.append("\tif (yourNewSheet != null) {").append(NEW_LINE);
        script.append(TAB).append(TAB).append("activeSpreadsheet.deleteSheet(yourNewSheet);").append(NEW_LINE);
        script.append(TAB).append("}");
        return script.toString();
    }

    private static String generateInsertSheet() {
        return "yourNewSheet = activeSpreadsheet.insertSheet();";
    }

    private static String generateSetName(String tableName) {
        return MessageFormat.format("yourNewSheet.setName(\"{0}\");", tableName);
    }

    private static String generateAppendRow(List<EntityField> fields) {
        StringBuilder columns = new StringBuilder();
        for (EntityField field : fields) {
            if (field.getRelation() == null) {
                if (columns.length() != 0) {
                    columns.append(", ");
                }
                columns.append("\"");
                columns.append(field.getFieldName());
                columns.append("\"");
                continue;
            }
            if (!field.getRelation().isOwner()) continue;
            if (columns.length() != 0) {
                columns.append(", ");
            }
            columns.append("\"");
            for (Relation.Key keyColumn : field.getRelation().getKeyColumns()) {
                columns.append(keyColumn.getField());
            }
            columns.append("\"");
        }
        return MessageFormat.format("yourNewSheet.appendRow([{0}]);", columns);
    }
}

