/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell;

import io.ballerina.shell.Diagnostic;
import io.ballerina.shell.DiagnosticKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class DiagnosticReporter {
    private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
    private boolean hasErrors = false;

    protected DiagnosticReporter() {
    }

    public void addDiagnostic(Diagnostic diagnostic) {
        if (diagnostic.getKind() == DiagnosticKind.ERROR) {
            this.hasErrors = true;
        }
        this.diagnostics.add(diagnostic);
    }

    protected void addErrorDiagnostic(String message) {
        this.addDiagnostic(Diagnostic.error(message));
    }

    protected void addDebugDiagnostic(String message) {
        this.addDiagnostic(Diagnostic.debug(message));
    }

    protected void addWarnDiagnostic(String message) {
        this.addDiagnostic(Diagnostic.warn(message));
    }

    public void addAllDiagnostics(Collection<Diagnostic> diagnostics) {
        diagnostics.forEach(this::addDiagnostic);
    }

    public List<Diagnostic> diagnostics() {
        return this.diagnostics;
    }

    public void resetDiagnostics() {
        this.diagnostics.clear();
        this.hasErrors = false;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }
}

