/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell;

import io.ballerina.shell.Evaluator;
import io.ballerina.shell.EvaluatorImpl;
import io.ballerina.shell.invoker.ShellSnippetsInvoker;
import io.ballerina.shell.invoker.classload.ClassLoadInvoker;
import io.ballerina.shell.parser.TreeParser;
import io.ballerina.shell.parser.TrialTreeParser;
import io.ballerina.shell.preprocessor.Preprocessor;
import io.ballerina.shell.preprocessor.SeparatorPreprocessor;
import io.ballerina.shell.snippet.factory.BasicSnippetFactory;
import io.ballerina.shell.snippet.factory.SnippetFactory;
import java.util.Objects;

public class EvaluatorBuilder {
    private Preprocessor preprocessor;
    private TreeParser treeParser;
    private SnippetFactory snippetFactory;
    private ShellSnippetsInvoker invoker;

    public Evaluator build() {
        this.preprocessor = Objects.requireNonNullElseGet(this.preprocessor, SeparatorPreprocessor::new);
        this.treeParser = Objects.requireNonNullElseGet(this.treeParser, TrialTreeParser::defaultParser);
        this.snippetFactory = Objects.requireNonNullElseGet(this.snippetFactory, BasicSnippetFactory::new);
        this.invoker = Objects.requireNonNullElseGet(this.invoker, ClassLoadInvoker::new);
        return new EvaluatorImpl(this.preprocessor, this.treeParser, this.snippetFactory, this.invoker);
    }

    public EvaluatorBuilder preprocessor(Preprocessor preprocessor) {
        this.preprocessor = preprocessor;
        return this;
    }

    public EvaluatorBuilder treeParser(TreeParser treeParser) {
        this.treeParser = treeParser;
        return this;
    }

    public EvaluatorBuilder snippetFactory(SnippetFactory snippetFactory) {
        this.snippetFactory = snippetFactory;
        return this;
    }

    public EvaluatorBuilder invoker(ShellSnippetsInvoker invoker) {
        this.invoker = invoker;
        return this;
    }
}

