/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.parser.trials;

import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.shell.parser.TrialTreeParser;
import io.ballerina.shell.parser.trials.ParserTrialFailedException;
import io.ballerina.shell.parser.trials.TreeParserTrial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ExpressionListTrial
extends TreeParserTrial {
    private static final String SEMICOLON = ";";

    public ExpressionListTrial(TrialTreeParser parentParser) {
        super(parentParser);
    }

    @Override
    public Collection<Node> parse(String source) throws ParserTrialFailedException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<ExpressionNode> parsedNodes = new ArrayList<ExpressionNode>();
        if (!((String)source).endsWith(SEMICOLON)) {
            source = (String)source + SEMICOLON;
        }
        List<String> expressionList = Arrays.asList(((String)source).split(SEMICOLON));
        for (String string : expressionList) {
            parsedNodes.add(NodeParser.parseActionOrExpression((String)string.trim()));
        }
        for (Node node : parsedNodes) {
            if (node.hasDiagnostics()) {
                throw new ParserTrialFailedException("Error occurred during parsing node as an expression.");
            }
            nodes.add(node);
        }
        return nodes;
    }
}

