/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.snippet.factory;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.shell.DiagnosticReporter;
import io.ballerina.shell.exceptions.SnippetException;
import io.ballerina.shell.snippet.Snippet;
import io.ballerina.shell.snippet.types.ImportDeclarationSnippet;
import io.ballerina.shell.snippet.types.ModuleMemberDeclarationSnippet;
import io.ballerina.shell.snippet.types.StatementSnippet;
import io.ballerina.shell.snippet.types.VariableDeclarationSnippet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class SnippetFactory
extends DiagnosticReporter {
    public Collection<Snippet> createSnippets(Collection<Node> nodes) throws SnippetException {
        ArrayList<Snippet> snippets = new ArrayList<Snippet>();
        for (Node node : nodes) {
            snippets.addAll(this.createSnippets(node));
        }
        return snippets;
    }

    public Collection<Snippet> createSnippets(Node node) throws SnippetException {
        List<VariableDeclarationSnippet> variableDeclarationSnippets;
        ArrayList<SnippetCreator> functions = new ArrayList<SnippetCreator>();
        functions.add(this::createImportSnippet);
        functions.add(this::createModuleMemberDeclarationSnippet);
        functions.add(this::createStatementSnippet);
        functions.add(this::createExpressionSnippet);
        ArrayList<Snippet> snippetList = new ArrayList<Snippet>();
        if ((node.kind() == SyntaxKind.LOCAL_VAR_DECL || node.kind() == SyntaxKind.MODULE_VAR_DECL) && (variableDeclarationSnippets = this.createVariableDeclarationSnippets(node)) != null) {
            for (Snippet snippet : variableDeclarationSnippets) {
                if (snippet == null) continue;
                String message = String.format("Node identified as a %s snippet.", new Object[]{snippet.getKind()});
                this.addDebugDiagnostic(message);
                snippetList.add(snippet);
            }
            return snippetList;
        }
        for (SnippetCreator function : functions) {
            Snippet snippet = function.create(node);
            if (snippet == null) continue;
            String string = String.format("Node identified as a %s snippet.", new Object[]{snippet.getKind()});
            this.addDebugDiagnostic(string);
            snippetList.add(snippet);
            return snippetList;
        }
        this.addErrorDiagnostic("Compilation aborted due to invalid input.");
        throw new SnippetException();
    }

    public abstract ImportDeclarationSnippet createImportSnippet(Node var1);

    public abstract List<VariableDeclarationSnippet> createVariableDeclarationSnippets(Node var1);

    public abstract ModuleMemberDeclarationSnippet createModuleMemberDeclarationSnippet(Node var1) throws SnippetException;

    public abstract StatementSnippet createStatementSnippet(Node var1) throws SnippetException;

    public abstract Snippet createExpressionSnippet(Node var1);

    private static interface SnippetCreator {
        public Snippet create(Node var1) throws SnippetException;
    }
}

