/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.ballerina.projects.BuildOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.BallerinaNotebookDocumentService;
import org.ballerinalang.langserver.BallerinaTextDocumentService;
import org.ballerinalang.langserver.BallerinaWorkspaceService;
import org.ballerinalang.langserver.Experimental;
import org.ballerinalang.langserver.ExtendedClientCapabilityBuilder;
import org.ballerinalang.langserver.ExtendedServerCapabilityBuilder;
import org.ballerinalang.langserver.LSClientCapabilitiesImpl;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.LSPackageLoader;
import org.ballerinalang.langserver.MemoryUsageMonitor;
import org.ballerinalang.langserver.command.LSCommandExecutorProvidersHolder;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClientAware;
import org.ballerinalang.langserver.commons.registration.BallerinaClientCapability;
import org.ballerinalang.langserver.commons.registration.BallerinaInitializeParams;
import org.ballerinalang.langserver.commons.registration.BallerinaInitializeResult;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.config.ClientConfigListener;
import org.ballerinalang.langserver.config.LSClientConfig;
import org.ballerinalang.langserver.config.LSClientConfigHolder;
import org.ballerinalang.langserver.contexts.LanguageServerContextImpl;
import org.ballerinalang.langserver.extensions.AbstractExtendedLanguageServer;
import org.ballerinalang.langserver.extensions.ExtendedLanguageServer;
import org.ballerinalang.langserver.semantictokens.SemanticTokensUtils;
import org.ballerinalang.langserver.util.LSClientUtil;
import org.ballerinalang.langserver.workspace.BallerinaWorkspaceManagerProxy;
import org.ballerinalang.langserver.workspace.BallerinaWorkspaceManagerProxyImpl;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionRegistrationOptions;
import org.eclipse.lsp4j.DefinitionRegistrationOptions;
import org.eclipse.lsp4j.DidChangeWatchedFilesRegistrationOptions;
import org.eclipse.lsp4j.DocumentFilter;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.FileSystemWatcher;
import org.eclipse.lsp4j.HoverRegistrationOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.ReferenceRegistrationOptions;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.TextDocumentChangeRegistrationOptions;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentRegistrationOptions;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.NotebookDocumentService;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;

public class BallerinaLanguageServer
extends AbstractExtendedLanguageServer
implements ExtendedLanguageClientAware,
ExtendedLanguageServer {
    private ExtendedLanguageClient client = null;
    private final TextDocumentService textService = new BallerinaTextDocumentService(this, this.workspaceManagerProxy, this.serverContext);
    private final WorkspaceService workspaceService = new BallerinaWorkspaceService(this, this.workspaceManagerProxy, this.serverContext);
    private final NotebookDocumentService notebookService = new BallerinaNotebookDocumentService(this.serverContext);
    private int shutdown = 1;
    private static final String LS_ENABLE_SEMANTIC_HIGHLIGHTING = "enableSemanticHighlighting";

    public BallerinaLanguageServer() {
        this(new LanguageServerContextImpl());
    }

    private BallerinaLanguageServer(LanguageServerContext serverContext) {
        super(serverContext);
    }

    public ExtendedLanguageClient getClient() {
        return this.client;
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        BallerinaWorkspaceManagerProxy ballerinaWorkspaceManagerProxy;
        InitializeResult res = new InitializeResult(new ServerCapabilities());
        res.getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Full);
        Map experimentalClientCapabilities = null;
        if (params.getCapabilities().getExperimental() != null) {
            experimentalClientCapabilities = (Map)new Gson().fromJson(params.getCapabilities().getExperimental().toString(), (TypeToken)new TypeToken<Map<String, Object>>(this){});
        }
        Map initializationOptions = null;
        if (params.getInitializationOptions() != null) {
            initializationOptions = (Map)new Gson().fromJson(params.getInitializationOptions().toString(), (TypeToken)new TypeToken<Map<String, Object>>(this){});
        }
        TextDocumentClientCapabilities textDocClientCapabilities = params.getCapabilities().getTextDocument();
        WorkspaceClientCapabilities workspaceClientCapabilities = params.getCapabilities().getWorkspace();
        LSClientCapabilitiesImpl capabilities = new LSClientCapabilitiesImpl(textDocClientCapabilities, workspaceClientCapabilities, experimentalClientCapabilities, initializationOptions);
        this.serverContext.put(LSClientCapabilities.class, (Object)capabilities);
        if (capabilities.getInitializationOptions().isEnableLightWeightMode()) {
            return CompletableFuture.supplyAsync(() -> res);
        }
        if (capabilities.getExperimentalCapabilities().isExperimentalLanguageFeaturesEnabled() && (ballerinaWorkspaceManagerProxy = this.workspaceManagerProxy) instanceof BallerinaWorkspaceManagerProxyImpl) {
            BallerinaWorkspaceManagerProxyImpl ballerinaWorkspaceManagerProxy2 = (BallerinaWorkspaceManagerProxyImpl)ballerinaWorkspaceManagerProxy;
            BuildOptions buildOptions = BuildOptions.builder().setOffline(Boolean.valueOf(CommonUtil.COMPILE_OFFLINE)).setSticky(Boolean.valueOf(true)).setExperimental(Boolean.valueOf(true)).build();
            ballerinaWorkspaceManagerProxy2.setBuildOptions(buildOptions);
        }
        SignatureHelpOptions signatureHelpOptions = new SignatureHelpOptions(Arrays.asList("(", ","));
        res.getCapabilities().setSignatureHelpProvider(signatureHelpOptions);
        res.getCapabilities().setDocumentSymbolProvider(Boolean.valueOf(true));
        res.getCapabilities().setDocumentFormattingProvider(Boolean.valueOf(true));
        res.getCapabilities().setDocumentRangeFormattingProvider(Boolean.valueOf(true));
        res.getCapabilities().setWorkspaceSymbolProvider(Boolean.valueOf(false));
        res.getCapabilities().setImplementationProvider(Boolean.valueOf(false));
        res.getCapabilities().setFoldingRangeProvider(Boolean.valueOf(true));
        res.getCapabilities().setCodeLensProvider(new CodeLensOptions());
        res.getCapabilities().setInlayHintProvider(Boolean.valueOf(true));
        CodeActionOptions codeActionOptions = new CodeActionOptions(List.of("refactor", "quickfix", "source"));
        codeActionOptions.setResolveProvider(Boolean.valueOf(true));
        res.getCapabilities().setCodeActionProvider(codeActionOptions);
        if (!LSClientUtil.isDynamicHoverRegistrationSupported(params.getCapabilities().getTextDocument())) {
            res.getCapabilities().setHoverProvider(Boolean.valueOf(true));
        }
        if (!LSClientUtil.isDynamicDefinitionRegistrationSupported(params.getCapabilities().getTextDocument())) {
            res.getCapabilities().setDefinitionProvider(Boolean.valueOf(true));
        }
        if (!LSClientUtil.isDynamicReferencesRegistrationSupported(params.getCapabilities().getTextDocument())) {
            res.getCapabilities().setReferencesProvider(Boolean.valueOf(true));
        }
        if (!LSClientUtil.isDynamicCompletionRegistrationSupported(params.getCapabilities().getTextDocument())) {
            CompletionOptions completionOptions = new CompletionOptions();
            completionOptions.setTriggerCharacters(this.getCompletionTriggerCharacters());
            res.getCapabilities().setCompletionProvider(completionOptions);
        }
        if (!LSClientUtil.isDynamicSemanticTokensRegistrationSupported(params.getCapabilities().getTextDocument()) && this.enableBallerinaSemanticTokens(params)) {
            res.getCapabilities().setSemanticTokensProvider(SemanticTokensUtils.getSemanticTokensRegistrationOptions());
        }
        boolean prepareSupport = LSClientUtil.clientSupportsPrepareRename(params.getCapabilities());
        res.getCapabilities().setRenameProvider(new RenameOptions(Boolean.valueOf(prepareSupport)));
        List<String> commandsList = LSCommandExecutorProvidersHolder.getInstance(this.serverContext).getCommandsList();
        ExecuteCommandOptions executeCommandOptions = new ExecuteCommandOptions(commandsList);
        res.getCapabilities().setExecuteCommandProvider(executeCommandOptions);
        HashMap<String, Boolean> experimentalServerCapabilities = new HashMap<String, Boolean>();
        experimentalServerCapabilities.put(Experimental.AST_PROVIDER.getValue(), true);
        experimentalServerCapabilities.put(Experimental.EXAMPLES_PROVIDER.getValue(), true);
        experimentalServerCapabilities.put(Experimental.API_EDITOR_PROVIDER.getValue(), true);
        res.getCapabilities().setExperimental(experimentalServerCapabilities);
        this.serverContext.put(ServerCapabilities.class, (Object)res.getCapabilities());
        ((BallerinaTextDocumentService)this.textService).setClientCapabilities(capabilities);
        ((BallerinaWorkspaceService)this.workspaceService).setClientCapabilities(capabilities);
        return CompletableFuture.supplyAsync(() -> res);
    }

    public void initialized(InitializedParams params) {
        LSClientLogger clientLogger = LSClientLogger.getInstance(this.serverContext);
        clientLogger.logMessage("LS offline source compilation set to " + CommonUtil.COMPILE_OFFLINE);
        this.registerDynamicCapabilities();
        this.startListeningFileChanges();
        LSClientCapabilities lsClientCapabilities = (LSClientCapabilities)this.serverContext.get(LSClientCapabilities.class);
        if (lsClientCapabilities.getInitializationOptions().isEnableLightWeightMode()) {
            return;
        }
        if (lsClientCapabilities.getInitializationOptions().isEnableIndexPackages()) {
            LSPackageLoader.getInstance(this.serverContext).loadModules(this.serverContext);
        }
        if (lsClientCapabilities.getInitializationOptions().isEnableMemoryUsageMonitor()) {
            MemoryUsageMonitor.getInstance(this.serverContext).start((LanguageClient)this.client);
        }
    }

    private void registerDynamicCapabilities() {
        this.registerTextSynchronizationForCustomUriSchemes();
        DocumentFilter balaFilter = new DocumentFilter();
        balaFilter.setScheme("bala");
        DocumentFilter fileFilter = new DocumentFilter();
        fileFilter.setScheme("file");
        fileFilter.setLanguage("ballerina");
        DocumentFilter fileFilterToml = new DocumentFilter();
        fileFilterToml.setScheme("file");
        fileFilterToml.setLanguage("toml");
        DocumentFilter exprFilter = new DocumentFilter();
        exprFilter.setScheme("expr");
        exprFilter.setLanguage("ballerina");
        List<DocumentFilter> documentSelectors = List.of(balaFilter, fileFilter);
        this.registerDynamicHoverSupport(documentSelectors);
        this.registerDynamicDefinitionSupport(documentSelectors);
        this.registerDynamicReferencesSupport(documentSelectors);
        this.registerDynamicCompletionSupport(List.of(fileFilter, exprFilter, fileFilterToml));
        this.registerDynamicSemanticTokenSupport();
    }

    private void registerTextSynchronizationForCustomUriSchemes() {
        LanguageClient client = (LanguageClient)this.serverContext.get(ExtendedLanguageClient.class);
        LSClientCapabilities clientCapabilities = (LSClientCapabilities)this.serverContext.get(LSClientCapabilities.class);
        DocumentFilter balaFilter = new DocumentFilter();
        balaFilter.setScheme("bala");
        DocumentFilter exprFilter = new DocumentFilter();
        exprFilter.setScheme("expr");
        if (LSClientUtil.isDynamicSynchronizationRegistrationSupported(clientCapabilities.getTextDocCapabilities())) {
            TextDocumentRegistrationOptions openRegOptions = new TextDocumentRegistrationOptions();
            openRegOptions.setDocumentSelector(List.of(balaFilter, exprFilter));
            Registration didOpenRegistration = new Registration(UUID.randomUUID().toString(), "textDocument/didOpen", (Object)openRegOptions);
            TextDocumentChangeRegistrationOptions changeRegOptions = new TextDocumentChangeRegistrationOptions();
            changeRegOptions.setDocumentSelector(List.of(balaFilter, exprFilter));
            changeRegOptions.setSyncKind(TextDocumentSyncKind.Full);
            Registration changeRegistration = new Registration(UUID.randomUUID().toString(), "textDocument/didChange", (Object)changeRegOptions);
            TextDocumentRegistrationOptions closeRegOptions = new TextDocumentRegistrationOptions();
            closeRegOptions.setDocumentSelector(List.of(balaFilter, exprFilter));
            Registration closeRegistration = new Registration(UUID.randomUUID().toString(), "textDocument/didClose", (Object)closeRegOptions);
            client.registerCapability(new RegistrationParams(List.of(didOpenRegistration)));
            client.registerCapability(new RegistrationParams(List.of(changeRegistration)));
            client.registerCapability(new RegistrationParams(List.of(closeRegistration)));
        }
    }

    private void registerDynamicHoverSupport(List<DocumentFilter> documentSelectors) {
        LSClientCapabilities clientCapabilities = (LSClientCapabilities)this.serverContext.get(LSClientCapabilities.class);
        if (LSClientUtil.isDynamicHoverRegistrationSupported(clientCapabilities.getTextDocCapabilities())) {
            HoverRegistrationOptions hoverRegOptions = new HoverRegistrationOptions();
            hoverRegOptions.setDocumentSelector(documentSelectors);
            Registration hoverRegistration = new Registration(UUID.randomUUID().toString(), "textDocument/hover", (Object)hoverRegOptions);
            this.client.registerCapability(new RegistrationParams(List.of(hoverRegistration)));
        }
    }

    private void registerDynamicDefinitionSupport(List<DocumentFilter> documentSelectors) {
        LSClientCapabilities clientCapabilities = (LSClientCapabilities)this.serverContext.get(LSClientCapabilities.class);
        if (LSClientUtil.isDynamicDefinitionRegistrationSupported(clientCapabilities.getTextDocCapabilities())) {
            DefinitionRegistrationOptions definitionRegistrationOptions = new DefinitionRegistrationOptions();
            definitionRegistrationOptions.setDocumentSelector(documentSelectors);
            Registration definitionRegistration = new Registration(UUID.randomUUID().toString(), "textDocument/definition", (Object)definitionRegistrationOptions);
            this.client.registerCapability(new RegistrationParams(List.of(definitionRegistration)));
        }
    }

    private void registerDynamicCompletionSupport(List<DocumentFilter> documentSelectors) {
        CompletionRegistrationOptions completionRegistrationOptions = new CompletionRegistrationOptions();
        completionRegistrationOptions.setDocumentSelector(documentSelectors);
        completionRegistrationOptions.setTriggerCharacters(this.getCompletionTriggerCharacters());
        Registration completionRegistration = new Registration(UUID.randomUUID().toString(), "textDocument/completion", (Object)completionRegistrationOptions);
        this.client.registerCapability(new RegistrationParams(List.of(completionRegistration)));
    }

    private void registerDynamicReferencesSupport(List<DocumentFilter> documentSelectors) {
        LSClientCapabilities clientCapabilities = (LSClientCapabilities)this.serverContext.get(LSClientCapabilities.class);
        if (LSClientUtil.isDynamicReferencesRegistrationSupported(clientCapabilities.getTextDocCapabilities())) {
            ReferenceRegistrationOptions referencesRegOptions = new ReferenceRegistrationOptions();
            referencesRegOptions.setDocumentSelector(documentSelectors);
            Registration referencesRegistration = new Registration(UUID.randomUUID().toString(), "textDocument/references", (Object)referencesRegOptions);
            this.client.registerCapability(new RegistrationParams(List.of(referencesRegistration)));
        }
    }

    private void registerDynamicSemanticTokenSupport() {
        LSClientCapabilities capabilities = (LSClientCapabilities)this.serverContext.get(LSClientCapabilities.class);
        if (LSClientUtil.isDynamicSemanticTokensRegistrationSupported(capabilities.getTextDocCapabilities())) {
            this.registerSemanticTokensConfigListener();
            if (capabilities.getWorkspaceCapabilities() != null && capabilities.getWorkspaceCapabilities().getDidChangeConfiguration() == null && capabilities.getInitializationOptions().isEnableSemanticTokens()) {
                SemanticTokensUtils.registerSemanticTokensCapability((ExtendedLanguageClient)this.serverContext.get(ExtendedLanguageClient.class));
            }
        }
    }

    public CompletableFuture<Object> shutdown() {
        this.shutdown = 0;
        for (ExtendedLanguageServerService service : this.extendedServices) {
            service.shutdown();
        }
        return CompletableFuture.supplyAsync(Object::new);
    }

    public void exit() {
        for (ExtendedLanguageServerService service : this.extendedServices) {
            service.exit(this.shutdown);
        }
        System.exit(this.shutdown);
    }

    public TextDocumentService getTextDocumentService() {
        return this.textService;
    }

    public NotebookDocumentService getNotebookDocumentService() {
        return this.notebookService;
    }

    public WorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    public void connect(ExtendedLanguageClient languageClient) {
        this.client = languageClient;
        this.serverContext.put(ExtendedLanguageClient.class, (Object)this.client);
        LSClientLogger.getInstance(this.serverContext).initialize((LanguageClient)this.client, this.serverContext);
    }

    @Override
    public CompletableFuture<BallerinaInitializeResult> initBalServices(BallerinaInitializeParams params) {
        return CompletableFuture.supplyAsync(() -> {
            BallerinaInitializeResult balInitResult = new BallerinaInitializeResult();
            List<BallerinaClientCapability> balClientCapabilities = ExtendedClientCapabilityBuilder.get(params.getBallerinaClientCapabilities());
            LSClientCapabilities capabilities = (LSClientCapabilities)this.serverContext.get(LSClientCapabilities.class);
            capabilities.setBallerinaClientCapabilities(balClientCapabilities);
            balInitResult.setExtendedServerCapabilities(ExtendedServerCapabilityBuilder.get());
            return balInitResult;
        });
    }

    private void registerSemanticTokensConfigListener() {
        LSClientConfigHolder.getInstance(this.serverContext).register(new ClientConfigListener(){

            @Override
            public void didChangeConfig(LSClientConfig oldConfig, LSClientConfig newConfig) {
                ExtendedLanguageClient languageClient = (ExtendedLanguageClient)BallerinaLanguageServer.this.serverContext.get(ExtendedLanguageClient.class);
                if (newConfig.isEnableSemanticHighlighting()) {
                    SemanticTokensUtils.registerSemanticTokensCapability(languageClient);
                } else {
                    SemanticTokensUtils.unRegisterSemanticTokensCapability(languageClient);
                }
            }
        });
    }

    private void startListeningFileChanges() {
        ExtendedLanguageClient languageClient = (ExtendedLanguageClient)this.serverContext.get(ExtendedLanguageClient.class);
        ArrayList<FileSystemWatcher> watchers = new ArrayList<FileSystemWatcher>();
        watchers.add(new FileSystemWatcher(Either.forLeft((Object)"/**/*.bal"), Integer.valueOf(7)));
        watchers.add(new FileSystemWatcher(Either.forLeft((Object)"/**/modules/*"), Integer.valueOf(5)));
        watchers.add(new FileSystemWatcher(Either.forLeft((Object)"/**/modules"), Integer.valueOf(4)));
        watchers.add(new FileSystemWatcher(Either.forLeft((Object)"/**/generated"), Integer.valueOf(4)));
        watchers.add(new FileSystemWatcher(Either.forLeft((Object)"/**/Ballerina.toml"), Integer.valueOf(5)));
        watchers.add(new FileSystemWatcher(Either.forLeft((Object)"/**/Cloud.toml"), Integer.valueOf(5)));
        watchers.add(new FileSystemWatcher(Either.forLeft((Object)"/**/Dependencies.toml"), Integer.valueOf(5)));
        DidChangeWatchedFilesRegistrationOptions opts = new DidChangeWatchedFilesRegistrationOptions(watchers);
        Registration registration = new Registration(UUID.randomUUID().toString(), "workspace/didChangeWatchedFiles", (Object)opts);
        languageClient.registerCapability(new RegistrationParams(Collections.singletonList(registration)));
    }

    private boolean enableBallerinaSemanticTokens(InitializeParams params) {
        if (params.getInitializationOptions() == null) {
            return true;
        }
        JsonObject initOptions = (JsonObject)params.getInitializationOptions();
        if (!initOptions.has(LS_ENABLE_SEMANTIC_HIGHLIGHTING)) {
            return true;
        }
        return initOptions.get(LS_ENABLE_SEMANTIC_HIGHLIGHTING).getAsBoolean();
    }

    private List<String> getCompletionTriggerCharacters() {
        return Arrays.asList(":", ".", ">", "@", "/", "\\", "?");
    }
}

