/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.apispec;

import java.util.List;
import java.util.Map;

public abstract class TypeSchema {
    final String type;
    final String className;

    protected TypeSchema(String type, String className) {
        this.type = type;
        this.className = className;
    }

    public static TypeSchema string(String className) {
        return new PrimitiveTypeSchema("string", className);
    }

    public static TypeSchema number(String className) {
        return new PrimitiveTypeSchema("number", className);
    }

    public static TypeSchema integer(String className) {
        return new PrimitiveTypeSchema("integer", className);
    }

    public static TypeSchema bool(String className) {
        return new PrimitiveTypeSchema("boolean", className);
    }

    public static TypeSchema array(TypeSchema item, String className) {
        return new CollectionTypeSchema("array", className, item);
    }

    public static TypeSchema map(TypeSchema item, String className) {
        return new CollectionTypeSchema("map", className, item);
    }

    public static TypeSchema object(Map<String, TypeSchema> properties, String className) {
        return new ObjectTypeSchema(properties, className);
    }

    public static TypeSchema enumSchema(List<String> values, String className) {
        return new EnumTypeSchema(values, className);
    }

    static class PrimitiveTypeSchema
    extends TypeSchema {
        PrimitiveTypeSchema(String type, String className) {
            super(type, className);
        }
    }

    static class CollectionTypeSchema
    extends TypeSchema {
        final TypeSchema item;

        CollectionTypeSchema(String type, String className, TypeSchema item) {
            super(type, className);
            this.item = item;
        }
    }

    static class ObjectTypeSchema
    extends TypeSchema {
        final Map<String, TypeSchema> properties;

        ObjectTypeSchema(Map<String, TypeSchema> properties, String className) {
            super("object", className);
            this.properties = properties;
        }
    }

    static class EnumTypeSchema
    extends TypeSchema {
        final List<String> enumValues;

        EnumTypeSchema(List<String> enumValues, String className) {
            super("string", className);
            this.enumValues = enumValues;
        }
    }
}

