/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.WaitActionNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.codeaction.MatchedExpressionNodeResolver;
import org.ballerinalang.langserver.codeaction.providers.changetype.TypeCastCodeAction;
import org.ballerinalang.langserver.common.ImportsAcceptor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextEdit;

public class AddCheckCodeAction
extends TypeCastCodeAction {
    public static final String NAME = "Add Check";
    private static final String DIAGNOSTIC_CODE_3998 = "BCE3998";
    private static final String DIAGNOSTIC_CODE_2068 = "BCE2068";
    private static final String DIAGNOSTIC_CODE_2526 = "BCE2526";
    private static final String DIAGNOSTIC_CODE_2800 = "BCE2800";
    public static final Set<String> DIAGNOSTIC_CODES = Set.of("BCE2652", "BCE2066", "BCE2068", "BCE2526", "BCE2800", "BCE3998");

    @Override
    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DIAGNOSTIC_CODES.contains(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Optional foundType;
        Optional<ExpressionNode> expressionNode;
        String diagnosticCode = diagnostic.diagnosticInfo().code();
        NonTerminalNode matchedNode = positionDetails.matchedNode();
        if (diagnosticCode.equals(DIAGNOSTIC_CODE_2526)) {
            if (matchedNode instanceof ExpressionStatementNode) {
                Object matchedExpressionStatementNode = (ExpressionStatementNode)matchedNode;
                expressionNode = Optional.of(matchedExpressionStatementNode.expression());
            } else {
                if (!(matchedNode instanceof ExpressionNode)) return Collections.emptyList();
                ExpressionNode matchedExpressionNode = (ExpressionNode)matchedNode;
                expressionNode = Optional.of(matchedExpressionNode);
            }
        } else {
            MatchedExpressionNodeResolver expressionResolver = new MatchedExpressionNodeResolver((Node)matchedNode);
            expressionNode = expressionResolver.findExpression((Node)matchedNode);
            if (expressionNode.isEmpty() || expressionNode.get().kind() == SyntaxKind.CHECK_EXPRESSION) {
                return Collections.emptyList();
            }
        }
        switch (diagnosticCode) {
            case "BCE2068": {
                Optional optional = positionDetails.diagnosticProperty(CodeActionUtil.getDiagPropertyFilterFunction(1));
                break;
            }
            case "BCE2526": {
                Optional optional = positionDetails.diagnosticProperty(CodeActionUtil.getDiagPropertyFilterFunction(0));
                break;
            }
            case "BCE2800": {
                Optional optional = positionDetails.diagnosticProperty(0);
                break;
            }
            case "BCE3998": {
                Optional optional = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)expressionNode.get()));
                break;
            }
            default: {
                Optional optional = foundType = positionDetails.diagnosticProperty(1);
            }
        }
        if (foundType.isEmpty()) {
            return Collections.emptyList();
        }
        if (((TypeSymbol)foundType.get()).typeKind() != TypeDescKind.UNION || !CodeActionUtil.hasErrorMemberType((UnionTypeSymbol)foundType.get())) {
            return Collections.emptyList();
        }
        Position pos = PositionUtil.toRange(diagnostic.location().lineRange()).getStart();
        if (expressionNode.get().kind() == SyntaxKind.BRACED_EXPRESSION) {
            BracedExpressionNode bracedExpressionNode = (BracedExpressionNode)expressionNode.get();
            pos = PositionUtil.toRange(bracedExpressionNode.expression().location().lineRange()).getStart();
        } else if (DIAGNOSTIC_CODE_3998.equals(diagnosticCode)) {
            pos = PositionUtil.toRange(expressionNode.get().location().lineRange()).getStart();
        }
        List<TypeSymbol> errorTypeSymbols = ((UnionTypeSymbol)foundType.get()).memberTypeDescriptors().stream().filter(typeSymbol -> CommonUtil.getRawType(typeSymbol).typeKind() == TypeDescKind.ERROR).toList();
        ImportsAcceptor acceptor = new ImportsAcceptor((DocumentServiceContext)context);
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>(CodeActionUtil.getAddCheckTextEdits(pos, matchedNode, context, errorTypeSymbols, acceptor));
        edits.addAll(acceptor.getNewImportTextEdits());
        if (edits.isEmpty()) {
            return Collections.emptyList();
        }
        if (expressionNode.get().kind() != SyntaxKind.WAIT_ACTION || !context.currentSemanticModel().isPresent()) return Collections.singletonList(CodeActionUtil.createCodeAction("Add 'check' error", edits, context.fileUri(), "quickfix"));
        WaitActionNode waitActionNode = (WaitActionNode)expressionNode.get();
        Optional tSymbol = ((SemanticModel)context.currentSemanticModel().get()).typeOf(waitActionNode.waitFutureExpr());
        if (!tSymbol.map(CommonUtil::getRawType).filter(t -> t.typeKind() != TypeDescKind.FUTURE).isPresent()) return Collections.singletonList(CodeActionUtil.createCodeAction("Add 'check' error", edits, context.fileUri(), "quickfix"));
        return Collections.singletonList(CodeActionUtil.createCodeAction("Add 'check' error", edits, context.fileUri()));
    }

    @Override
    public String getName() {
        return NAME;
    }
}

