/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class AddPrivateQualifierCodeAction
implements DiagnosticBasedCodeActionProvider {
    private static final String NAME = "Add private visibility qualifier";
    private static final String DIAGNOSTIC_CODE = "BCE3956";

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DIAGNOSTIC_CODE.equals(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        NonTerminalNode cursorNode = positionDetails.matchedNode();
        if (cursorNode.kind() != SyntaxKind.OBJECT_FIELD) {
            assert (false) : "This line is unreachable as the diagnostic is only generated for an object field.";
            return Collections.emptyList();
        }
        return Collections.singletonList(CodeActionUtil.createCodeAction("Add private qualifier", List.of(AddPrivateQualifierCodeAction.getTextEdit((ObjectFieldNode)cursorNode)), context.fileUri(), "quickfix"));
    }

    private static TextEdit getTextEdit(ObjectFieldNode node) {
        Object privateKeyword = SyntaxKind.PRIVATE_KEYWORD.stringValue();
        Optional visibilityQualifier = node.visibilityQualifier();
        if (visibilityQualifier.isPresent()) {
            return new TextEdit(PositionUtil.toRange(((Token)visibilityQualifier.get()).lineRange()), (String)privateKeyword);
        }
        privateKeyword = (String)privateKeyword + " ";
        NodeList qualifiers = node.qualifierList();
        if (!qualifiers.isEmpty()) {
            Position position = PositionUtil.toPosition(((Token)qualifiers.get(0)).lineRange().startLine());
            return new TextEdit(new Range(position, position), (String)privateKeyword);
        }
        Position position = PositionUtil.toPosition(node.typeName().lineRange().startLine());
        return new TextEdit(new Range(position, position), (String)privateKeyword);
    }

    public String getName() {
        return NAME;
    }
}

