/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.TextEdit;

public class ConvertToConfigurableCodeAction
implements RangeBasedCodeActionProvider {
    private static final String CONFIGURABLE = "configurable";
    private static final List<String> LIST_UPDATING_METHODS = List.of("push", "pop", "remove", "removeAll", "reverse", "setLength", "shift", "slice", "unshift");
    private static final List<String> TABLE_UPDATING_METHODS = List.of("add", "put", "remove", "removeAll", "removeIfHasKey");
    private static final List<String> MAPPING_UPDATING_METHODS = List.of("remove", "removeAll", "removeIfHasKey");

    public List<SyntaxKind> getSyntaxKinds() {
        return List.of(SyntaxKind.BOOLEAN_LITERAL, SyntaxKind.NUMERIC_LITERAL, SyntaxKind.STRING_LITERAL, SyntaxKind.UNARY_EXPRESSION, SyntaxKind.XML_TEMPLATE_EXPRESSION, SyntaxKind.STRING_TEMPLATE_EXPRESSION, SyntaxKind.MAPPING_CONSTRUCTOR, SyntaxKind.LIST_CONSTRUCTOR, SyntaxKind.TABLE_CONSTRUCTOR);
    }

    public boolean validate(CodeActionContext context, RangeBasedPositionDetails positionDetails) {
        NonTerminalNode rootNode;
        NonTerminalNode matchedNode = positionDetails.matchedCodeActionNode();
        NonTerminalNode parentNode = matchedNode.parent();
        if (parentNode.kind() != SyntaxKind.MODULE_VAR_DECL || !CodeActionNodeValidator.validate(context.nodeAtRange())) {
            return false;
        }
        ModuleVariableDeclarationNode modVarDeclarationNode = (ModuleVariableDeclarationNode)parentNode;
        if (modVarDeclarationNode.typedBindingPattern().typeDescriptor().kind() == SyntaxKind.VAR_TYPE_DESC || ConvertToConfigurableCodeAction.hasIsolatedOrFinalOrConfigurableQualifier(modVarDeclarationNode)) {
            return false;
        }
        SemanticModel semanticModel = (SemanticModel)context.currentSemanticModel().get();
        Optional symbol = semanticModel.symbol((Node)modVarDeclarationNode);
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.VARIABLE) {
            return false;
        }
        VariableSymbol variableSymbol = (VariableSymbol)symbol.get();
        List references = semanticModel.references((Symbol)variableSymbol);
        if (ConvertToConfigurableCodeAction.isVariableAssigned(references, rootNode = (NonTerminalNode)((SyntaxTree)context.currentSyntaxTree().get()).rootNode())) {
            return false;
        }
        TypeSymbol varTypeSymbol = variableSymbol.typeDescriptor();
        Types types = semanticModel.types();
        if (!varTypeSymbol.subtypeOf(types.ANYDATA) || types.REGEX.subtypeOf(varTypeSymbol)) {
            return false;
        }
        if (!variableSymbol.typeDescriptor().subtypeOf(semanticModel.types().READONLY)) {
            switch (matchedNode.kind()) {
                case LIST_CONSTRUCTOR: {
                    return !ConvertToConfigurableCodeAction.isListVarUpdated(references, rootNode);
                }
                case MAPPING_CONSTRUCTOR: {
                    return !ConvertToConfigurableCodeAction.isMappingVarUpdated(references, rootNode);
                }
                case TABLE_CONSTRUCTOR: {
                    return !ConvertToConfigurableCodeAction.isTableVarUpdated(references, rootNode);
                }
            }
        }
        return true;
    }

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        ModuleVariableDeclarationNode modVarDeclarationNode = (ModuleVariableDeclarationNode)posDetails.matchedCodeActionNode().parent();
        TextEdit textEdit = modVarDeclarationNode.visibilityQualifier().map(token -> new TextEdit(PositionUtil.toRange(token.lineRange().endLine()), " configurable")).orElseGet(() -> new TextEdit(PositionUtil.toRange(modVarDeclarationNode.lineRange().startLine()), "configurable "));
        CodeAction codeAction = CodeActionUtil.createCodeAction("Convert to configurable", List.of(textEdit), context.fileUri(), "");
        return List.of(codeAction);
    }

    private static boolean hasIsolatedOrFinalOrConfigurableQualifier(ModuleVariableDeclarationNode modVarDeclarationNode) {
        return modVarDeclarationNode.qualifiers().stream().anyMatch(q -> q.text().equals(Qualifier.ISOLATED.getValue()) || q.text().equals(Qualifier.FINAL.getValue()) || q.text().equals(Qualifier.CONFIGURABLE.getValue()));
    }

    private static boolean isVariableAssigned(List<Location> references, NonTerminalNode rootNode) {
        return references.stream().map(location -> rootNode.findNode(location.textRange())).anyMatch(node -> node.parent().kind() == SyntaxKind.ASSIGNMENT_STATEMENT);
    }

    private static boolean isListVarUpdated(List<Location> references, NonTerminalNode rootNode) {
        for (Location location : references) {
            NonTerminalNode node = rootNode.findNode(location.textRange());
            NonTerminalNode parentNode = node.parent();
            SyntaxKind parentKind = parentNode.kind();
            if (parentKind == SyntaxKind.INDEXED_EXPRESSION && parentNode.parent().kind() == SyntaxKind.ASSIGNMENT_STATEMENT) {
                return true;
            }
            if (parentKind != SyntaxKind.METHOD_CALL || !LIST_UPDATING_METHODS.contains(((MethodCallExpressionNode)parentNode).methodName().toSourceCode())) continue;
            return true;
        }
        return false;
    }

    private static boolean isTableVarUpdated(List<Location> references, NonTerminalNode rootNode) {
        for (Location location : references) {
            NonTerminalNode node = rootNode.findNode(location.textRange());
            NonTerminalNode parentNode = node.parent();
            if (parentNode.kind() != SyntaxKind.METHOD_CALL || !TABLE_UPDATING_METHODS.contains(((MethodCallExpressionNode)parentNode).methodName().toSourceCode())) continue;
            return true;
        }
        return false;
    }

    private static boolean isMappingVarUpdated(List<Location> references, NonTerminalNode rootNode) {
        for (Location location : references) {
            NonTerminalNode node = rootNode.findNode(location.textRange());
            if (node.kind() == SyntaxKind.ASSIGNMENT_STATEMENT) {
                ExpressionNode exprNode = ((AssignmentStatementNode)node).expression();
                if (exprNode.kind() == SyntaxKind.METHOD_CALL) {
                    MethodCallExpressionNode methodCallExpressionNode = (MethodCallExpressionNode)exprNode;
                    return MAPPING_UPDATING_METHODS.contains(methodCallExpressionNode.methodName().toSourceCode());
                }
                return false;
            }
            NonTerminalNode parentNode = node.parent();
            if (parentNode.kind() != SyntaxKind.INDEXED_EXPRESSION || parentNode.parent().kind() != SyntaxKind.ASSIGNMENT_STATEMENT) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return "Convert to configurable";
    }
}

