/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class ConvertToReadonlyCloneCodeAction
implements DiagnosticBasedCodeActionProvider {
    private static final String NAME = "Convert to Readonly Clone";
    private static final String CLONE_READONLY_PREFIX = "cloneReadOnly";

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return diagnostic.diagnosticInfo().code().equals(DiagnosticErrorCode.INVALID_CALL_WITH_MUTABLE_ARGS_IN_MATCH_GUARD.diagnosticId()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        NonTerminalNode currentNode = positionDetails.matchedNode();
        Optional typeDescriptor = ((SemanticModel)context.currentSemanticModel().get()).typeOf((Node)currentNode);
        if (typeDescriptor.isEmpty() || !this.isCloneReadonlyAvailable((TypeSymbol)typeDescriptor.get())) {
            return Collections.emptyList();
        }
        Range range = PositionUtil.toRange(diagnostic.location().lineRange());
        String newText = this.getNewText(currentNode);
        String uri = context.filePath().toUri().toString();
        TextEdit textEdit = new TextEdit();
        textEdit.setRange(range);
        textEdit.setNewText(newText);
        List<TextEdit> textEdits = Collections.singletonList(textEdit);
        return Collections.singletonList(CodeActionUtil.createCodeAction(NAME, textEdits, uri, "quickfix"));
    }

    public String getName() {
        return NAME;
    }

    private boolean isCloneReadonlyAvailable(TypeSymbol typeSymbol) {
        return typeSymbol.langLibMethods().stream().anyMatch(fSymbol -> fSymbol.getName().orElse("").equals(CLONE_READONLY_PREFIX));
    }

    private String getNewText(NonTerminalNode currentNode) {
        Object prefix = switch (currentNode.kind()) {
            case SyntaxKind.LET_EXPRESSION, SyntaxKind.CONDITIONAL_EXPRESSION, SyntaxKind.CHECK_EXPRESSION, SyntaxKind.XML_STEP_EXPRESSION -> "(" + currentNode.toSourceCode().trim() + ")";
            default -> currentNode.toSourceCode().trim();
        };
        return (String)prefix + ".cloneReadOnly()";
    }
}

