/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.projects.Document;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class TypeGuardCodeAction
implements RangeBasedCodeActionProvider {
    public static final String NAME = "Type Guard";

    public List<SyntaxKind> getSyntaxKinds() {
        return Arrays.asList(SyntaxKind.LOCAL_VAR_DECL, SyntaxKind.ASSIGNMENT_STATEMENT);
    }

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        NonTerminalNode matchedNode = posDetails.matchedStatementNode();
        if (!this.isInValidContext(matchedNode, context)) {
            return Collections.emptyList();
        }
        Optional<Pair<UnionTypeSymbol, TypeDescriptorNode>> varTypeSymbolAndTypeDescNodePair = this.getVarTypeSymbolAndTypeNode((Node)matchedNode, posDetails, context);
        if (varTypeSymbolAndTypeDescNodePair.isEmpty()) {
            return Collections.emptyList();
        }
        UnionTypeSymbol varTypeSymbol = (UnionTypeSymbol)varTypeSymbolAndTypeDescNodePair.get().getLeft();
        boolean hasCompilationError = varTypeSymbol.memberTypeDescriptors().stream().anyMatch(s -> s.typeKind() == TypeDescKind.COMPILATION_ERROR);
        if (hasCompilationError) {
            return Collections.emptyList();
        }
        Optional<String> varName = this.getVariableName((Node)matchedNode);
        if (varName.isEmpty()) {
            return Collections.emptyList();
        }
        String commandTitle = String.format("Type guard variable '%s'", varName.get());
        Range range = PositionUtil.toRange(matchedNode.lineRange());
        List<TextEdit> edits = CodeActionUtil.getTypeGuardCodeActionEdits(varName.get(), range, varTypeSymbol, context);
        if (edits.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(CodeActionUtil.createCodeAction(commandTitle, edits, context.fileUri(), "source"));
    }

    public String getName() {
        return NAME;
    }

    private Optional<String> getVariableName(Node matchedNode) {
        switch (matchedNode.kind()) {
            case LOCAL_VAR_DECL: {
                VariableDeclarationNode variableDeclrNode = (VariableDeclarationNode)matchedNode;
                BindingPatternNode bindingPatternNode = variableDeclrNode.typedBindingPattern().bindingPattern();
                if (bindingPatternNode.kind() != SyntaxKind.CAPTURE_BINDING_PATTERN) {
                    return Optional.empty();
                }
                CaptureBindingPatternNode captureBindingPatternNode = (CaptureBindingPatternNode)bindingPatternNode;
                return Optional.of(captureBindingPatternNode.variableName().text());
            }
            case ASSIGNMENT_STATEMENT: {
                AssignmentStatementNode assignmentStmtNode = (AssignmentStatementNode)matchedNode;
                Node varRef = assignmentStmtNode.varRef();
                if (varRef.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
                    return Optional.of(((SimpleNameReferenceNode)varRef).name().text());
                }
                if (varRef.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
                    return Optional.of(((QualifiedNameReferenceNode)varRef).identifier().text());
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    protected Optional<Pair<UnionTypeSymbol, TypeDescriptorNode>> getVarTypeSymbolAndTypeNode(Node matchedNode, RangeBasedPositionDetails posDetails, CodeActionContext context) {
        TypeDescriptorNode varTypeNode;
        TypeSymbol varTypeSymbol;
        switch (matchedNode.kind()) {
            case LOCAL_VAR_DECL: {
                varTypeSymbol = posDetails.matchedTopLevelTypeSymbol();
                varTypeNode = ((VariableDeclarationNode)matchedNode).typedBindingPattern().typeDescriptor();
                break;
            }
            case ASSIGNMENT_STATEMENT: {
                Optional<VariableSymbol> optVariableSymbol = this.getVariableSymbol(context, matchedNode);
                if (optVariableSymbol.isEmpty()) {
                    return Optional.empty();
                }
                varTypeSymbol = optVariableSymbol.get().typeDescriptor();
                SyntaxTree syntaxTree = (SyntaxTree)context.currentSyntaxTree().orElseThrow();
                Optional<NonTerminalNode> node = CommonUtil.findNode((Symbol)optVariableSymbol.get(), syntaxTree);
                if (node.isPresent() && node.get().kind() == SyntaxKind.TYPED_BINDING_PATTERN) {
                    varTypeNode = ((TypedBindingPatternNode)node.get()).typeDescriptor();
                    break;
                }
                return Optional.empty();
            }
            default: {
                return Optional.empty();
            }
        }
        if (varTypeSymbol == null || varTypeSymbol.typeKind() != TypeDescKind.UNION) {
            return Optional.empty();
        }
        return Optional.of(new ImmutablePair((Object)((UnionTypeSymbol)varTypeSymbol), (Object)varTypeNode));
    }

    private Optional<VariableSymbol> getVariableSymbol(CodeActionContext context, Node matchedNode) {
        Document srcFile;
        AssignmentStatementNode assignmentStmtNode = (AssignmentStatementNode)matchedNode;
        SemanticModel semanticModel = (SemanticModel)context.currentSemanticModel().orElseThrow();
        Optional symbol = semanticModel.symbol(srcFile = (Document)context.currentDocument().orElseThrow(), assignmentStmtNode.varRef().lineRange().startLine());
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.VARIABLE) {
            return Optional.empty();
        }
        return Optional.of((VariableSymbol)symbol.get());
    }

    private boolean isInValidContext(NonTerminalNode matchedNode, CodeActionContext context) {
        Optional syntaxTree = context.currentSyntaxTree();
        if (syntaxTree.isEmpty()) {
            return false;
        }
        Node node = null;
        if (matchedNode.kind() == SyntaxKind.ASSIGNMENT_STATEMENT) {
            node = ((AssignmentStatementNode)matchedNode).varRef();
        } else if (matchedNode.kind() == SyntaxKind.LOCAL_VAR_DECL) {
            node = ((VariableDeclarationNode)matchedNode).typedBindingPattern().bindingPattern();
        }
        return node != null && PositionUtil.isWithInRange(node, context.cursorPositionInTree());
    }
}

