/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.changetype;

import io.ballerina.compiler.api.symbols.FutureTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.codeaction.MatchedExpressionNodeResolver;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class TypeCastCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "Type Cast";
    public static final Set<String> DIAGNOSTIC_CODES = Set.of("BCE2066", "BCE2068");

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DIAGNOSTIC_CODES.contains(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        MatchedExpressionNodeResolver expressionResolver = new MatchedExpressionNodeResolver((Node)positionDetails.matchedNode());
        Optional<ExpressionNode> expressionNode = expressionResolver.findExpression((Node)positionDetails.matchedNode());
        if (expressionNode.isEmpty() || expressionNode.get().kind() == SyntaxKind.TYPE_CAST_EXPRESSION) {
            return Collections.emptyList();
        }
        Optional optionalActualTypeSymbol = "BCE2068".equals(diagnostic.diagnosticInfo().code()) ? positionDetails.diagnosticProperty(CodeActionUtil.getDiagPropertyFilterFunction(1)) : positionDetails.diagnosticProperty(1);
        Optional optionalExpectedTypeSymbol = positionDetails.diagnosticProperty(0);
        if (optionalExpectedTypeSymbol.isEmpty() || optionalActualTypeSymbol.isEmpty()) {
            return Collections.emptyList();
        }
        TypeSymbol actualTypeSymbol = CommonUtil.getRawType((TypeSymbol)optionalActualTypeSymbol.get());
        TypeSymbol expectedTypeSymbol = (TypeSymbol)optionalExpectedTypeSymbol.get();
        if (actualTypeSymbol.typeKind() == TypeDescKind.UNION && CodeActionUtil.hasErrorMemberType((UnionTypeSymbol)actualTypeSymbol)) {
            return Collections.emptyList();
        }
        if (actualTypeSymbol.typeKind() == TypeDescKind.FUTURE && expressionNode.get().kind() == SyntaxKind.WAIT_ACTION) {
            if (expectedTypeSymbol.typeKind() != TypeDescKind.FUTURE) {
                return Collections.emptyList();
            }
            optionalExpectedTypeSymbol = ((FutureTypeSymbol)expectedTypeSymbol).typeParameter();
            optionalActualTypeSymbol = ((FutureTypeSymbol)actualTypeSymbol).typeParameter();
            if (optionalActualTypeSymbol.isEmpty() || optionalExpectedTypeSymbol.isEmpty()) {
                return Collections.emptyList();
            }
            actualTypeSymbol = CommonUtil.getRawType((TypeSymbol)optionalActualTypeSymbol.get());
            expectedTypeSymbol = (TypeSymbol)optionalExpectedTypeSymbol.get();
        }
        String typeName = "";
        if (expectedTypeSymbol.subtypeOf(actualTypeSymbol) && expectedTypeSymbol.typeKind() != TypeDescKind.SINGLETON) {
            typeName = NameUtil.getModifiedTypeName((DocumentServiceContext)context, expectedTypeSymbol);
        } else if (this.isNumeric(expectedTypeSymbol)) {
            Optional<TypeSymbol> numericExpected = this.findNumericType(expectedTypeSymbol);
            Optional<TypeSymbol> numericActual = this.findNumericType(actualTypeSymbol);
            if (numericActual.isPresent() && numericExpected.isPresent()) {
                typeName = NameUtil.getModifiedTypeName((DocumentServiceContext)context, numericExpected.get());
            }
        }
        if (typeName.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>(this.getTextEdits((Node)expressionNode.get(), typeName));
        String commandTitle = "Add type cast";
        return Collections.singletonList(CodeActionUtil.createCodeAction(commandTitle, edits, context.fileUri(), "quickfix"));
    }

    public String getName() {
        return NAME;
    }

    protected Optional<VariableSymbol> getVariableSymbol(CodeActionContext context, Node matchedNode) {
        AssignmentStatementNode assignmentStmtNode = (AssignmentStatementNode)matchedNode;
        Optional symbol = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol(assignmentStmtNode.varRef()));
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.VARIABLE) {
            return Optional.empty();
        }
        return Optional.of((VariableSymbol)symbol.get());
    }

    protected List<TextEdit> getTextEdits(Node expressionNode, String expectedTypeName) {
        Position startPosition = PositionUtil.toPosition(expressionNode.lineRange().startLine());
        Position endPosition = PositionUtil.toPosition(expressionNode.lineRange().endLine());
        String editText = "<" + expectedTypeName + ">";
        if (expressionNode.kind() == SyntaxKind.BINARY_EXPRESSION) {
            editText = editText + "(";
            TextEdit castWithParentheses = new TextEdit(new Range(startPosition, startPosition), editText);
            TextEdit closeParentheses = new TextEdit(new Range(endPosition, endPosition), ")");
            return List.of(castWithParentheses, closeParentheses);
        }
        return List.of(new TextEdit(new Range(startPosition, startPosition), editText));
    }

    private boolean isNumeric(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.UNION) {
            return ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors().stream().anyMatch(this::isNumeric);
        }
        return typeSymbol.typeKind().isIntegerType() || typeSymbol.typeKind() == TypeDescKind.FLOAT || typeSymbol.typeKind() == TypeDescKind.DECIMAL;
    }

    private Optional<TypeSymbol> findNumericType(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.UNION) {
            return ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors().stream().filter(this::isNumeric).findFirst();
        }
        if (this.isNumeric(typeSymbol)) {
            return Optional.of(typeSymbol);
        }
        return Optional.empty();
    }
}

