/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.docs;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.command.docs.DocAttachmentInfo;
import org.ballerinalang.langserver.command.docs.DocumentationGenerator;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;

public class NodeBasedUpdateDocumentationCodeAction
implements RangeBasedCodeActionProvider {
    public static final String NAME = "Update Documentation";

    public List<SyntaxKind> getSyntaxKinds() {
        return Arrays.asList(SyntaxKind.FUNCTION_DEFINITION, SyntaxKind.OBJECT_TYPE_DESC, SyntaxKind.CLASS_DEFINITION, SyntaxKind.SERVICE_DECLARATION, SyntaxKind.RESOURCE_ACCESSOR_DEFINITION, SyntaxKind.RECORD_TYPE_DESC, SyntaxKind.METHOD_DECLARATION, SyntaxKind.OBJECT_METHOD_DEFINITION);
    }

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        String docUri = context.fileUri();
        Optional matchedDocumentableNode = posDetails.enclosingDocumentableNode();
        if (matchedDocumentableNode.isEmpty() || !DocumentationGenerator.hasDocs((NonTerminalNode)matchedDocumentableNode.get()) || !this.hasMismatch(context, (NonTerminalNode)matchedDocumentableNode.get())) {
            return Collections.emptyList();
        }
        CommandArgument docUriArg = CommandArgument.from((String)"doc.uri", (Object)docUri);
        CommandArgument lineStart = CommandArgument.from((String)"node.range", (Object)PositionUtil.toRange(((NonTerminalNode)matchedDocumentableNode.get()).lineRange()));
        ArrayList<CommandArgument> args = new ArrayList<CommandArgument>(Arrays.asList(docUriArg, lineStart));
        CodeAction action = new CodeAction("Update documentation");
        Command command = new Command("Update documentation", "UPDATE_DOC", args);
        action.setCommand(command);
        action.setKind("refactor");
        return Collections.singletonList(action);
    }

    private boolean hasMismatch(CodeActionContext context, NonTerminalNode node) {
        SemanticModel semanticModel = (SemanticModel)context.workspace().semanticModel(context.filePath()).orElseThrow();
        Optional<Symbol> documentableSymbol = DocumentationGenerator.getDocumentableSymbol(node, semanticModel);
        SyntaxTree syntaxTree = (SyntaxTree)context.workspace().syntaxTree(context.filePath()).orElseThrow();
        Optional<DocAttachmentInfo> docAttachmentInfo = DocumentationGenerator.getDocumentationEditForNode(node, syntaxTree);
        if (docAttachmentInfo.isEmpty()) {
            return false;
        }
        DocAttachmentInfo docs = docAttachmentInfo.get();
        if (documentableSymbol.isEmpty()) {
            return false;
        }
        Optional symbolDocumentation = ((Documentable)documentableSymbol.get()).documentation();
        if (symbolDocumentation.isEmpty()) {
            return false;
        }
        Documentation documentation = (Documentation)symbolDocumentation.get();
        docs = docs.mergeDocAttachment(documentation);
        return !documentation.description().equals(docs.description()) || !documentation.parameterMap().equals(docs.parameterMap()) || !documentation.returnDescription().equals(docs.returnDescription()) || !documentation.deprecatedDescription().equals(docs.deprecatedDescription());
    }

    public String getName() {
        return NAME;
    }
}

