/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.docs;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.AnnotationDeclarationNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IncludedRecordParameterNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.compiler.syntax.tree.RestParameterNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextDocument;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.ballerinalang.langserver.command.docs.DocAttachmentInfo;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public final class DocumentationGenerator {
    private DocumentationGenerator() {
    }

    public static boolean hasDocs(NonTerminalNode node) {
        for (Node next : node.children()) {
            if (next.kind() != SyntaxKind.METADATA || !((MetadataNode)next).documentationString().isPresent()) continue;
            return true;
        }
        return false;
    }

    public static Optional<Range> getDocsRange(NonTerminalNode node) {
        for (Node next : node.children()) {
            if (next.kind() != SyntaxKind.METADATA || !((MetadataNode)next).documentationString().isPresent()) continue;
            return Optional.of(PositionUtil.toRange(((Node)((MetadataNode)next).documentationString().get()).lineRange()));
        }
        return Optional.empty();
    }

    public static Optional<DocAttachmentInfo> getDocumentationEditForNode(NonTerminalNode node, SyntaxTree syntaxTree) {
        return switch (node.kind()) {
            case SyntaxKind.FUNCTION_DEFINITION, SyntaxKind.RESOURCE_ACCESSOR_DEFINITION, SyntaxKind.OBJECT_METHOD_DEFINITION -> Optional.of(DocumentationGenerator.generateFunctionDocumentation((FunctionDefinitionNode)node, syntaxTree));
            case SyntaxKind.METHOD_DECLARATION -> Optional.of(DocumentationGenerator.generateMethodDocumentation((MethodDeclarationNode)node, syntaxTree));
            case SyntaxKind.SERVICE_DECLARATION -> Optional.of(DocumentationGenerator.generateServiceDocumentation((ServiceDeclarationNode)node, syntaxTree));
            case SyntaxKind.TYPE_DEFINITION -> Optional.of(DocumentationGenerator.generateRecordOrObjectDocumentation((TypeDefinitionNode)node, syntaxTree));
            case SyntaxKind.CLASS_DEFINITION -> Optional.of(DocumentationGenerator.generateClassDocumentation((ClassDefinitionNode)node, syntaxTree));
            case SyntaxKind.CONST_DECLARATION -> Optional.of(DocumentationGenerator.generateModuleMemberDocumentation((ModuleMemberDeclarationNode)((ConstantDeclarationNode)node), syntaxTree));
            case SyntaxKind.ENUM_DECLARATION -> Optional.of(DocumentationGenerator.generateModuleMemberDocumentation((ModuleMemberDeclarationNode)((EnumDeclarationNode)node), syntaxTree));
            case SyntaxKind.MODULE_VAR_DECL -> Optional.of(DocumentationGenerator.generateModuleMemberDocumentation((ModuleMemberDeclarationNode)((ModuleVariableDeclarationNode)node), syntaxTree));
            case SyntaxKind.ANNOTATION_DECLARATION -> Optional.of(DocumentationGenerator.generateAnnotationDocumentation((AnnotationDeclarationNode)node, syntaxTree));
            default -> Optional.empty();
        };
    }

    public static Optional<Symbol> getDocumentableSymbol(NonTerminalNode node, SemanticModel semanticModel) {
        return switch (node.kind()) {
            case SyntaxKind.FUNCTION_DEFINITION, SyntaxKind.RESOURCE_ACCESSOR_DEFINITION, SyntaxKind.OBJECT_METHOD_DEFINITION, SyntaxKind.METHOD_DECLARATION, SyntaxKind.SERVICE_DECLARATION, SyntaxKind.TYPE_DEFINITION, SyntaxKind.CLASS_DEFINITION, SyntaxKind.ANNOTATION_DECLARATION -> semanticModel.symbol((Node)node);
            default -> Optional.empty();
        };
    }

    private static DocAttachmentInfo generateServiceDocumentation(ServiceDeclarationNode serviceDeclrNode, SyntaxTree syntaxTree) {
        MetadataNode metadata = serviceDeclrNode.metadata().orElse(null);
        Position docStart = PositionUtil.toRange(serviceDeclrNode.lineRange()).getStart();
        if (metadata != null && !metadata.annotations().isEmpty()) {
            docStart = PositionUtil.toRange(((AnnotationNode)metadata.annotations().get(0)).lineRange()).getStart();
        }
        String desc = String.format("Description.%n", new Object[0]);
        return new DocAttachmentInfo(desc, docStart, DocumentationGenerator.getPadding((NonTerminalNode)serviceDeclrNode, syntaxTree));
    }

    private static DocAttachmentInfo generateModuleMemberDocumentation(ModuleMemberDeclarationNode declarationNode, SyntaxTree syntaxTree) {
        Position docStart = PositionUtil.toRange(declarationNode.lineRange()).getStart();
        String desc = String.format("Description.%n", new Object[0]);
        return new DocAttachmentInfo(desc, docStart, DocumentationGenerator.getPadding((NonTerminalNode)declarationNode, syntaxTree));
    }

    private static DocAttachmentInfo generateFunctionDocumentation(FunctionDefinitionNode bLangFunction, SyntaxTree syntaxTree) {
        return DocumentationGenerator.getFunctionNodeDocumentation(bLangFunction.functionSignature(), (NodeList<Node>)bLangFunction.relativeResourcePath(), bLangFunction.metadata().orElse(null), PositionUtil.toRange(bLangFunction.lineRange()), syntaxTree);
    }

    private static DocAttachmentInfo generateMethodDocumentation(MethodDeclarationNode methodDeclrNode, SyntaxTree syntaxTree) {
        return DocumentationGenerator.getFunctionNodeDocumentation(methodDeclrNode.methodSignature(), (NodeList<Node>)methodDeclrNode.relativeResourcePath(), methodDeclrNode.metadata().orElse(null), PositionUtil.toRange(methodDeclrNode.lineRange()), syntaxTree);
    }

    private static DocAttachmentInfo generateRecordOrObjectDocumentation(TypeDefinitionNode typeDefNode, SyntaxTree syntaxTree) {
        MetadataNode metadata = typeDefNode.metadata().orElse(null);
        Position docStart = PositionUtil.toRange(typeDefNode.lineRange()).getStart();
        if (metadata != null && !metadata.annotations().isEmpty()) {
            docStart = PositionUtil.toRange(((AnnotationNode)metadata.annotations().get(0)).lineRange()).getStart();
        }
        Node typeDesc = typeDefNode.typeDescriptor();
        String desc = String.format("Description.%n", new Object[0]);
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        switch (typeDesc.kind()) {
            case RECORD_TYPE_DESC: {
                RecordTypeDescriptorNode recordTypeDescNode = (RecordTypeDescriptorNode)typeDesc;
                recordTypeDescNode.fields().forEach(field -> {
                    Optional<Object> paramName = Optional.empty();
                    if (field.kind() == SyntaxKind.RECORD_FIELD) {
                        paramName = Optional.of(((RecordFieldNode)field).fieldName());
                    } else if (field.kind() == SyntaxKind.RECORD_FIELD_WITH_DEFAULT_VALUE) {
                        paramName = Optional.of(((RecordFieldWithDefaultValueNode)field).fieldName());
                    }
                    paramName.ifPresent(param -> parameters.put(param.text(), "field description"));
                });
                break;
            }
            case OBJECT_TYPE_DESC: {
                ObjectTypeDescriptorNode objectTypeDescNode = (ObjectTypeDescriptorNode)typeDesc;
                objectTypeDescNode.members().forEach(field -> {
                    ObjectFieldNode fieldNode;
                    if (field.kind() == SyntaxKind.OBJECT_FIELD && ((ObjectFieldNode)field).visibilityQualifier().isPresent() && ((Token)(fieldNode = (ObjectFieldNode)field).visibilityQualifier().get()).kind() == SyntaxKind.PUBLIC_KEYWORD) {
                        parameters.put(fieldNode.fieldName().text(), "field description");
                    }
                });
                break;
            }
        }
        return new DocAttachmentInfo(desc, parameters, null, null, docStart, DocumentationGenerator.getPadding((NonTerminalNode)typeDefNode, syntaxTree));
    }

    private static DocAttachmentInfo generateClassDocumentation(ClassDefinitionNode classDefNode, SyntaxTree syntaxTree) {
        MetadataNode metadata = classDefNode.metadata().orElse(null);
        Position docStart = PositionUtil.toRange(classDefNode.lineRange()).getStart();
        if (metadata != null && !metadata.annotations().isEmpty()) {
            docStart = PositionUtil.toRange(((AnnotationNode)metadata.annotations().get(0)).lineRange()).getStart();
        }
        String desc = String.format("Description.%n", new Object[0]);
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        classDefNode.members().forEach(field -> {
            ObjectFieldNode fieldNode;
            if (field.kind() == SyntaxKind.OBJECT_FIELD && ((ObjectFieldNode)field).visibilityQualifier().isPresent() && ((Token)(fieldNode = (ObjectFieldNode)field).visibilityQualifier().get()).kind() == SyntaxKind.PUBLIC_KEYWORD) {
                parameters.put(fieldNode.fieldName().text(), "parameter description");
            }
        });
        return new DocAttachmentInfo(desc, parameters, null, null, docStart, DocumentationGenerator.getPadding((NonTerminalNode)classDefNode, syntaxTree));
    }

    private static DocAttachmentInfo getFunctionNodeDocumentation(FunctionSignatureNode signatureNode, NodeList<Node> resourceNodes, MetadataNode metadata, Range functionRange, SyntaxTree syntaxTree) {
        Position docStart = functionRange.getStart();
        boolean hasDeprecated = false;
        if (metadata != null && !metadata.annotations().isEmpty()) {
            for (AnnotationNode annotationNode : metadata.annotations()) {
                Node annotReference = annotationNode.annotReference();
                if (annotReference.kind() != SyntaxKind.SIMPLE_NAME_REFERENCE || !"deprecated".equals(((SimpleNameReferenceNode)annotReference).name().text())) continue;
                hasDeprecated = true;
            }
            docStart = PositionUtil.toRange(((AnnotationNode)metadata.annotations().get(0)).lineRange()).getStart();
        }
        String desc = String.format("Description.%n", new Object[0]);
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (!resourceNodes.isEmpty()) {
            resourceNodes.forEach(param -> {
                if (param instanceof ResourcePathParameterNode) {
                    ResourcePathParameterNode resourcePathParameterNode = (ResourcePathParameterNode)param;
                    Optional<Token> paramName = Optional.empty();
                    if (param.kind() == SyntaxKind.RESOURCE_PATH_SEGMENT_PARAM || param.kind() == SyntaxKind.RESOURCE_PATH_REST_PARAM) {
                        paramName = Optional.ofNullable(resourcePathParameterNode.paramName().orElse(null));
                    }
                    paramName.ifPresent(token -> parameters.put(token.text(), "parameter description"));
                }
            });
        }
        signatureNode.parameters().forEach(param -> {
            Optional paramName = switch (param.kind()) {
                case SyntaxKind.REQUIRED_PARAM -> ((RequiredParameterNode)param).paramName();
                case SyntaxKind.DEFAULTABLE_PARAM -> ((DefaultableParameterNode)param).paramName();
                case SyntaxKind.REST_PARAM -> ((RestParameterNode)param).paramName();
                case SyntaxKind.INCLUDED_RECORD_PARAM -> ((IncludedRecordParameterNode)param).paramName();
                default -> Optional.empty();
            };
            paramName.ifPresent(token -> parameters.put(token.text(), "parameter description"));
        });
        String returnDesc = signatureNode.returnTypeDesc().isPresent() ? "return value description" : null;
        String deprecatedDesc = null;
        if (hasDeprecated) {
            deprecatedDesc = "Deprecated Description";
        }
        return new DocAttachmentInfo(desc, parameters, returnDesc, deprecatedDesc, docStart, DocumentationGenerator.getPadding(signatureNode.parent(), syntaxTree));
    }

    private static DocAttachmentInfo generateAnnotationDocumentation(AnnotationDeclarationNode annotationDeclarationNode, SyntaxTree syntaxTree) {
        MetadataNode metadata = annotationDeclarationNode.metadata().orElse(null);
        Position docStart = PositionUtil.toRange(annotationDeclarationNode.lineRange()).getStart();
        if (metadata != null && !metadata.annotations().isEmpty()) {
            docStart = PositionUtil.toRange(((AnnotationNode)metadata.annotations().get(0)).lineRange()).getStart();
        }
        String desc = String.format("Description.%n", new Object[0]);
        return new DocAttachmentInfo(desc, docStart, DocumentationGenerator.getPadding((NonTerminalNode)annotationDeclarationNode, syntaxTree));
    }

    private static String getPadding(NonTerminalNode bLangFunction, SyntaxTree syntaxTree) {
        LinePosition position = bLangFunction.location().lineRange().startLine();
        TextDocument textDocument = syntaxTree.textDocument();
        int prevCharIndex = textDocument.textPositionFrom(LinePosition.from((int)position.line(), (int)position.offset()));
        int lineStartIndex = textDocument.textPositionFrom(LinePosition.from((int)position.line(), (int)0));
        String sourceCode = syntaxTree.toSourceCode();
        String padding = sourceCode.substring(lineStartIndex, prevCharIndex);
        return padding.isBlank() ? padding : " ";
    }
}

