/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.executors;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.langserver.commons.ExecuteCommandContext;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.commons.command.LSCommandExecutorException;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.ballerinalang.langserver.commons.workspace.RunContext;
import org.ballerinalang.langserver.commons.workspace.RunResult;
import org.eclipse.lsp4j.LogTraceParams;

public class RunExecutor
implements LSCommandExecutor {
    private static final String RUN_COMMAND = "RUN";
    private static final String ARG_PATH = "path";
    private static final String ARG_PROGRAM_ARGS = "programArgs";
    private static final String ARG_ENV = "env";
    private static final String ARG_DEBUG_PORT = "debugPort";
    private static final String ERROR_CHANNEL = "err";
    private static final String OUT_CHANNEL = "out";

    public Boolean execute(ExecuteCommandContext context) throws LSCommandExecutorException {
        try {
            RunContext workspaceRunContext = this.getWorkspaceRunContext(context);
            RunResult runResult = context.workspace().run(workspaceRunContext);
            Collection diagnostics = runResult.diagnostics();
            for (Diagnostic diagnostic : diagnostics) {
                LogTraceParams diagnosticMessage = new LogTraceParams(diagnostic.toString(), ERROR_CHANNEL);
                context.getLanguageClient().logTrace(diagnosticMessage);
            }
            if (diagnostics.stream().anyMatch(d -> d.diagnosticInfo().severity() == DiagnosticSeverity.ERROR)) {
                LogTraceParams error = new LogTraceParams("error: compilation contains errors", ERROR_CHANNEL);
                context.getLanguageClient().logTrace(error);
                return false;
            }
            Process process = runResult.process();
            if (Objects.isNull(process)) {
                return false;
            }
            this.listenOutputAsync(context.getLanguageClient(), process::getInputStream, OUT_CHANNEL);
            this.listenOutputAsync(context.getLanguageClient(), process::getErrorStream, ERROR_CHANNEL);
            return true;
        }
        catch (BLangCompilerException e) {
            LogTraceParams error = new LogTraceParams(e.getMessage(), ERROR_CHANNEL);
            context.getLanguageClient().logTrace(error);
        }
        catch (IOException e) {
            LogTraceParams error = new LogTraceParams("Error while running the program in fast-run mode: " + e.getMessage(), ERROR_CHANNEL);
            context.getLanguageClient().logTrace(error);
        }
        catch (Exception e) {
            LogTraceParams error = new LogTraceParams("Unexpected error while executing the fast-run: " + e.getMessage(), ERROR_CHANNEL);
            context.getLanguageClient().logTrace(error);
        }
        return false;
    }

    private RunContext getWorkspaceRunContext(ExecuteCommandContext context) {
        RunContext.Builder builder = new RunContext.Builder(this.extractPath(context));
        builder.withProgramArgs(this.extractProgramArgs(context));
        builder.withEnv(this.extractEnvVariables(context));
        builder.withDebugPort(this.extractDebugArgs(context));
        return builder.build();
    }

    private Path extractPath(ExecuteCommandContext context) {
        return RunExecutor.getCommandArgWithName(context, ARG_PATH).map(CommandArgument::value).map(JsonPrimitive::getAsString).map(pathStr -> {
            try {
                Path path = Path.of(pathStr, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    throw new IllegalArgumentException("Specified path does not exist: " + pathStr);
                }
                return path;
            }
            catch (InvalidPathException e) {
                throw new IllegalArgumentException("Invalid path: " + pathStr, e);
            }
        }).orElseThrow(() -> new IllegalArgumentException("Path argument is required"));
    }

    private int extractDebugArgs(ExecuteCommandContext context) {
        return RunExecutor.getCommandArgWithName(context, ARG_DEBUG_PORT).map(CommandArgument::value).map(JsonPrimitive::getAsInt).orElse(-1);
    }

    private List<String> extractProgramArgs(ExecuteCommandContext context) {
        return RunExecutor.getCommandArgWithName(context, ARG_PROGRAM_ARGS).map(arg -> ((JsonArray)arg.value()).getAsJsonArray()).map(jsonArray -> StreamSupport.stream(jsonArray.spliterator(), false).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsJsonPrimitive).filter(JsonPrimitive::isString).map(JsonPrimitive::getAsString).toList()).orElse(Collections.emptyList());
    }

    private Map<String, String> extractEnvVariables(ExecuteCommandContext context) {
        return RunExecutor.getCommandArgWithName(context, ARG_ENV).map(CommandArgument::value).map(jsonObject -> {
            HashMap<String, String> envMap = new HashMap<String, String>();
            for (Map.Entry entry : jsonObject.entrySet()) {
                if (!((JsonElement)entry.getValue()).isJsonPrimitive() || !((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) continue;
                envMap.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            return Collections.unmodifiableMap(envMap);
        }).orElse(Map.of());
    }

    private static Optional<CommandArgument> getCommandArgWithName(ExecuteCommandContext context, String name) {
        return context.getArguments().stream().filter(commandArg -> commandArg.key().equals(name)).findAny();
    }

    public void listenOutputAsync(ExtendedLanguageClient client, Supplier<InputStream> getInputStream, String channel) {
        Thread.startVirtualThread(() -> RunExecutor.listenOutput(client, getInputStream, channel));
    }

    private static void listenOutput(ExtendedLanguageClient client, Supplier<InputStream> inSupplier, String channel) {
        try (InputStream in = inSupplier.get();){
            int count;
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) >= 0) {
                String str = new String(buffer, 0, count, StandardCharsets.UTF_8);
                client.logTrace(new LogTraceParams(str, channel));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        client.logTrace(new LogTraceParams("", "stopped"));
    }

    public String getCommand() {
        return RUN_COMMAND;
    }
}

