/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.visitors;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Optional;

public class IsolatedBlockResolver
extends NodeTransformer<Boolean> {
    public Boolean findIsolatedBlock(Node node) {
        if (node.kind() == SyntaxKind.LIST) {
            return (Boolean)node.parent().apply((NodeTransformer)this);
        }
        return (Boolean)node.apply((NodeTransformer)this);
    }

    public Boolean transform(ObjectFieldNode objectFieldNode) {
        return true;
    }

    public Boolean transform(FunctionDefinitionNode functionDefinitionNode) {
        return this.hasIsolatedQualifier((NodeList<Token>)functionDefinitionNode.qualifierList());
    }

    protected Boolean transformSyntaxNode(Node node) {
        if (node.parent() != null) {
            return (Boolean)node.parent().apply((NodeTransformer)this);
        }
        return Boolean.FALSE;
    }

    private boolean hasIsolatedQualifier(NodeList<Token> tokens) {
        Optional<Token> isolatedQualifier = tokens.stream().filter(qualifier -> qualifier.text().equals(SyntaxKind.ISOLATED_KEYWORD.stringValue())).findAny();
        return isolatedQualifier.isPresent();
    }
}

