/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common.utils;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.AnnotationAttachPoint;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.projects.Module;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.common.utils.RecordUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.SnippetContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.TextEdit;

public final class AnnotationUtil {
    private AnnotationUtil() {
    }

    public static LSCompletionItem getModuleQualifiedAnnotationItem(ModuleID moduleID, AnnotationSymbol annotationSymbol, BallerinaCompletionContext ctx) {
        Optional currentModule = ctx.workspace().module(ctx.filePath());
        if (currentModule.isEmpty()) {
            throw new RuntimeException("Cannot find a valid module");
        }
        String currentProjectOrgName = ((Module)currentModule.get()).project().currentPackage().packageOrg().value();
        Optional<String> importedAlias = AnnotationUtil.getAlias(ctx, moduleID);
        String alias = importedAlias.orElseGet(() -> ((ModuleID)moduleID).modulePrefix());
        String label = AnnotationUtil.getAnnotationLabel(alias, annotationSymbol);
        String insertText = AnnotationUtil.getAnnotationInsertText(alias, annotationSymbol);
        Map imports = ctx.currentDocImportsMap();
        Optional<ImportDeclarationNode> pkgImport = imports.keySet().stream().filter(bLangImportPackage -> {
            Optional importOrgNameNode = bLangImportPackage.orgName();
            if (importOrgNameNode.isEmpty()) {
                return false;
            }
            String orgName = ((ImportOrgNameNode)importOrgNameNode.get()).orgName().text();
            String importPkgName = (orgName.isEmpty() ? currentProjectOrgName : orgName) + "/" + ModuleUtil.getPackageNameComponentsCombined(bLangImportPackage);
            String annotationPkgOrgName = moduleID.orgName();
            String annotationPkgName = annotationPkgOrgName + "/" + moduleID.moduleName();
            return importPkgName.equals(annotationPkgName);
        }).findAny();
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        if (pkgImport.isEmpty() && !CommonUtil.isLangLib(moduleID)) {
            textEdits.addAll(AnnotationUtil.getAdditionalTextEdits((DocumentServiceContext)ctx, moduleID));
        }
        CompletionItem annotationItem = AnnotationUtil.prepareCompletionItem(label, insertText, textEdits);
        return new SymbolCompletionItem(ctx, (Symbol)annotationSymbol, annotationItem);
    }

    public static LSCompletionItem getAnnotationItem(AnnotationSymbol annotationSymbol, BallerinaCompletionContext ctx) {
        String label = AnnotationUtil.getAnnotationLabel(annotationSymbol);
        String insertText = AnnotationUtil.getAnnotationInsertText(annotationSymbol);
        CompletionItem completionItem = AnnotationUtil.prepareCompletionItem(label, insertText, new ArrayList<TextEdit>());
        return new SymbolCompletionItem(ctx, (Symbol)annotationSymbol, completionItem);
    }

    public static List<TextEdit> getAdditionalTextEdits(DocumentServiceContext context, ModuleID moduleID) {
        Optional currentModule = context.workspace().module(context.filePath());
        if (currentModule.isEmpty()) {
            return Collections.emptyList();
        }
        String currentProjectOrgName = ((Module)currentModule.get()).project().currentPackage().packageOrg().value();
        Map imports = context.currentDocImportsMap();
        Optional<ImportDeclarationNode> pkgImport = imports.keySet().stream().filter(importNode -> {
            if (importNode.orgName().isEmpty()) {
                return false;
            }
            String orgName = ((ImportOrgNameNode)importNode.orgName().get()).orgName().text();
            String importPkgName = (orgName.isEmpty() ? currentProjectOrgName : orgName) + "/" + ModuleUtil.getPackageNameComponentsCombined(importNode);
            String annotationPkgOrgName = moduleID.orgName();
            String annotationPkgName = annotationPkgOrgName + "/" + moduleID.moduleName();
            return importPkgName.equals(annotationPkgName);
        }).findAny();
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        if (pkgImport.isEmpty() && !CommonUtil.isLangLib(moduleID)) {
            textEdits.addAll(CommonUtil.getAutoImportTextEdits(moduleID.orgName(), moduleID.moduleName(), context));
        }
        return textEdits;
    }

    public static boolean hasAttachment(AnnotationSymbol annotation, AnnotationAttachPoint attachPoint) {
        return annotation.attachPoints().isEmpty() || annotation.attachPoints().contains(attachPoint);
    }

    private static String getAnnotationInsertText(@Nonnull String aliasComponent, AnnotationSymbol annotationSymbol) {
        StringBuilder annotationStart = new StringBuilder();
        if (!aliasComponent.isEmpty()) {
            annotationStart.append(aliasComponent).append(":");
        }
        if (annotationSymbol.typeDescriptor().isPresent()) {
            annotationStart.append((String)annotationSymbol.getName().get());
            TypeSymbol attachedType = CommonUtil.getRawType((TypeSymbol)annotationSymbol.typeDescriptor().get());
            TypeSymbol resultType = attachedType.typeKind() == TypeDescKind.ARRAY ? ((ArrayTypeSymbol)attachedType).memberTypeDescriptor() : attachedType;
            if (resultType.typeKind() == TypeDescKind.RECORD || resultType.typeKind() == TypeDescKind.MAP) {
                ArrayList<RecordFieldSymbol> requiredFields = new ArrayList<RecordFieldSymbol>();
                if (resultType.typeKind() == TypeDescKind.RECORD) {
                    requiredFields.addAll(RecordUtil.getMandatoryRecordFields((RecordTypeSymbol)resultType));
                }
                if (!requiredFields.isEmpty()) {
                    annotationStart.append(" ").append("{").append(CommonUtil.LINE_SEPARATOR);
                    ArrayList<CallSite> insertTexts = new ArrayList<CallSite>();
                    SnippetContext snippetContext = new SnippetContext();
                    for (RecordFieldSymbol field : requiredFields) {
                        String fieldInsertionText = "\t" + RecordUtil.getRecordFieldCompletionInsertText(field, snippetContext);
                        insertTexts.add((CallSite)((Object)fieldInsertionText));
                    }
                    annotationStart.append(String.join((CharSequence)("," + CommonUtil.LINE_SEPARATOR), insertTexts));
                    if (requiredFields.isEmpty()) {
                        annotationStart.append("\t").append("${1}");
                    }
                    annotationStart.append(CommonUtil.LINE_SEPARATOR).append("}");
                }
            }
        } else {
            annotationStart.append((String)annotationSymbol.getName().get());
        }
        return annotationStart.toString();
    }

    private static String getAnnotationInsertText(AnnotationSymbol annotationSymbol) {
        return AnnotationUtil.getAnnotationInsertText("", annotationSymbol);
    }

    private static String getAnnotationLabel(@Nonnull String aliasComponent, AnnotationSymbol annotation) {
        Object pkgComponent = !aliasComponent.isEmpty() ? aliasComponent + ":" : "";
        return (String)pkgComponent + (String)annotation.getName().get();
    }

    private static String getAnnotationLabel(AnnotationSymbol annotation) {
        return AnnotationUtil.getAnnotationLabel("", annotation);
    }

    private static CompletionItem prepareCompletionItem(String label, String insertText, List<TextEdit> textEdits) {
        CompletionItem annotationItem = new CompletionItem();
        annotationItem.setLabel(label);
        annotationItem.setInsertText(insertText);
        annotationItem.setInsertTextFormat(InsertTextFormat.Snippet);
        annotationItem.setDetail("Annotation");
        annotationItem.setKind(CompletionItemKind.Property);
        annotationItem.setAdditionalTextEdits(textEdits);
        return annotationItem;
    }

    private static Optional<String> getAlias(BallerinaCompletionContext context, ModuleID moduleID) {
        return context.currentDocImportsMap().keySet().stream().filter(importNode -> {
            Optional orgName = importNode.orgName();
            StringBuilder nodeName = new StringBuilder();
            orgName.ifPresent(importOrgNameNode -> nodeName.append(importOrgNameNode.orgName().text()));
            nodeName.append(ModuleUtil.getPackageNameComponentsCombined(importNode));
            return moduleID.toString().equals(nodeName.toString());
        }).map(importNode -> {
            if (importNode.prefix().isEmpty()) {
                return ((IdentifierToken)importNode.moduleName().get(importNode.moduleName().size() - 1)).text();
            }
            return ((ImportPrefixNode)importNode.prefix().get()).prefix().text();
        }).findFirst();
    }
}

