/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common.utils;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.FunctionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxInfo;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.SystemUtils;
import org.ballerinalang.langserver.LSPackageLoader;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.wso2.ballerinalang.compiler.util.Names;

public final class CommonUtil {
    public static final String MD_LINE_SEPARATOR = "  " + System.lineSeparator();
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String FILE_SEPARATOR = File.separator;
    public static final Pattern MD_NEW_LINE_PATTERN = Pattern.compile("\\s\\s\\r\\n?|\\s\\s\\n|\\r\\n?|\\n");
    public static final String BALLERINA_HOME;
    public static final boolean COMPILE_OFFLINE;
    public static final String BALLERINA_CMD;
    public static final String URI_SCHEME_BALA = "bala";
    public static final String URI_SCHEME_EXPR = "expr";
    public static final String URI_SCHEME_FILE = "file";
    public static final String LANGUAGE_ID_BALLERINA = "ballerina";
    public static final String LANGUAGE_ID_TOML = "toml";
    public static final String MARKDOWN_MARKUP_KIND = "markdown";
    public static final String BALLERINA_ORG_NAME = "ballerina";
    public static final String SDK_VERSION;
    public static final String EXPR_SCHEME = "expr";
    public static final List<String> PRE_DECLARED_LANG_LIBS;
    public static final List<String> BALLERINA_KEYWORDS;
    public static final Set<SyntaxKind> QUALIFIER_KINDS;
    private static final Pattern TYPE_NAME_DECOMPOSE_PATTERN;
    private static final String UNRESOLVED_MODULE_CODE = "BCE2003";

    private CommonUtil() {
    }

    public static List<org.eclipse.lsp4j.TextEdit> getAutoImportTextEdits(@Nonnull String orgName, String pkgName, DocumentServiceContext context) {
        Map currentDocImports = context.currentDocImportsMap();
        Optional last = CommonUtil.getLastItem(new ArrayList(currentDocImports.keySet()));
        int endLine = last.map(node -> node.lineRange().endLine().line()).orElse(0);
        Position start = new Position(endLine, 0);
        String importStatement = "import " + (String)(!orgName.isEmpty() ? orgName + "/" : orgName) + pkgName + ";" + LINE_SEPARATOR;
        return Collections.singletonList(new org.eclipse.lsp4j.TextEdit(new Range(start, start), importStatement));
    }

    public static List<org.eclipse.lsp4j.TextEdit> getAutoImportTextEdits(@Nonnull String orgName, String pkgName, String alias, DocumentServiceContext context) {
        StringBuilder builder = new StringBuilder("import " + (String)(!orgName.isEmpty() ? orgName + "/" : orgName) + pkgName);
        if (!alias.isEmpty()) {
            builder.append(" as ").append(alias);
        }
        builder.append(";").append(LINE_SEPARATOR);
        Position insertPos = CommonUtil.getImportPosition(context);
        return Collections.singletonList(new org.eclipse.lsp4j.TextEdit(new Range(insertPos, insertPos), builder.toString()));
    }

    public static Position getImportPosition(DocumentServiceContext context) {
        Optional syntaxTree = context.currentSyntaxTree();
        ModulePartNode modulePartNode = (ModulePartNode)((SyntaxTree)syntaxTree.orElseThrow()).rootNode();
        NodeList imports = modulePartNode.imports();
        if (!imports.isEmpty()) {
            ImportDeclarationNode lastImport = (ImportDeclarationNode)imports.get(imports.size() - 1);
            return new Position(lastImport.lineRange().endLine().line() + 1, 0);
        }
        if (modulePartNode.members().isEmpty()) {
            return new Position(0, 0);
        }
        Position insertPosition = new Position(0, 0);
        for (Minutiae minutiae : modulePartNode.leadingMinutiae()) {
            if (minutiae.kind() != SyntaxKind.END_OF_LINE_MINUTIAE || minutiae.lineRange().startLine().offset() != 0) continue;
            insertPosition = new Position(minutiae.lineRange().startLine().line(), 0);
            break;
        }
        return insertPosition;
    }

    public static <T> Optional<T> getLastItem(List<T> list) {
        return list.isEmpty() ? Optional.empty() : Optional.of(list.get(list.size() - 1));
    }

    public static boolean isLangLib(ModuleID moduleID) {
        return CommonUtil.isLangLib(moduleID.orgName(), moduleID.moduleName());
    }

    public static boolean isLangLib(String orgName, String moduleName) {
        return orgName.equals("ballerina") && moduleName.startsWith("lang.");
    }

    public static boolean isLangLibOrLangTest(ModuleID moduleID) {
        String orgName = moduleID.orgName();
        String moduleName = moduleID.moduleName();
        return orgName.equals("ballerina") && (moduleName.startsWith("lang.") || moduleName.equals("test"));
    }

    public static String escapeEscapeCharsInIdentifier(String identifier) {
        return identifier.replace("\\", "\\\\");
    }

    public static String escapeSpecialCharsInInsertText(String text) {
        return text.replace("\\", "\\\\").replace("$", "\\$");
    }

    public static NonTerminalNode findNode(Range range, SyntaxTree syntaxTree) {
        TextDocument textDocument = syntaxTree.textDocument();
        Position rangeStart = range.getStart();
        Position rangeEnd = range.getEnd();
        int start = textDocument.textPositionFrom(LinePosition.from((int)rangeStart.getLine(), (int)rangeStart.getCharacter()));
        int end = textDocument.textPositionFrom(LinePosition.from((int)rangeEnd.getLine(), (int)rangeEnd.getCharacter()));
        return ((ModulePartNode)syntaxTree.rootNode()).findNode(TextRange.from((int)start, (int)(end - start)), true);
    }

    public static Optional<NonTerminalNode> findNode(Symbol symbol, SyntaxTree syntaxTree) {
        if (symbol.getLocation().isEmpty()) {
            return Optional.empty();
        }
        TextDocument textDocument = syntaxTree.textDocument();
        LineRange symbolRange = ((Location)symbol.getLocation().get()).lineRange();
        int start = textDocument.textPositionFrom(symbolRange.startLine());
        int end = textDocument.textPositionFrom(symbolRange.endLine());
        return Optional.ofNullable(((ModulePartNode)syntaxTree.rootNode()).findNode(TextRange.from((int)start, (int)(end - start)), true));
    }

    public static TypeSymbol getRawType(TypeSymbol typeDescriptor) {
        if (typeDescriptor.typeKind() == TypeDescKind.INTERSECTION) {
            return CommonUtil.getRawType(((IntersectionTypeSymbol)typeDescriptor).effectiveTypeDescriptor());
        }
        if (typeDescriptor.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            TypeReferenceTypeSymbol typeRef = (TypeReferenceTypeSymbol)typeDescriptor;
            if (typeRef.typeDescriptor().typeKind() == TypeDescKind.INTERSECTION) {
                return CommonUtil.getRawType(((IntersectionTypeSymbol)typeRef.typeDescriptor()).effectiveTypeDescriptor());
            }
            TypeSymbol rawType = typeRef.typeDescriptor();
            if (rawType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
                return CommonUtil.getRawType(rawType);
            }
            return rawType;
        }
        return typeDescriptor;
    }

    public static boolean isErrorOrUnionOfErrors(TypeSymbol type) {
        TypeDescKind kind = type.typeKind();
        if (kind == TypeDescKind.ERROR) {
            return true;
        }
        if (kind == TypeDescKind.TYPE_REFERENCE) {
            TypeSymbol rawType = CommonUtil.getRawType(type);
            if (rawType.typeKind() == TypeDescKind.UNION) {
                return ((UnionTypeSymbol)rawType).memberTypeDescriptors().stream().allMatch(CommonUtil::isErrorOrUnionOfErrors);
            }
            return CommonUtil.isErrorOrUnionOfErrors(rawType);
        }
        return false;
    }

    private static void getErrorTypes(TypeSymbol type, TypeSymbol typeRef, List<TypeSymbol> errorTypes) {
        TypeDescKind kind = type.typeKind();
        if (kind == TypeDescKind.ERROR) {
            errorTypes.add(Objects.requireNonNullElse(typeRef, type));
        } else if (kind == TypeDescKind.TYPE_REFERENCE) {
            TypeSymbol rawType = CommonUtil.getRawType(type);
            if (rawType.typeKind() == TypeDescKind.UNION) {
                UnionTypeSymbol unionRawType = (UnionTypeSymbol)rawType;
                if (unionRawType.memberTypeDescriptors().stream().allMatch(CommonUtil::isErrorOrUnionOfErrors)) {
                    errorTypes.add(type);
                } else {
                    for (TypeSymbol memberType : unionRawType.userSpecifiedMemberTypes()) {
                        CommonUtil.getErrorTypes(memberType, memberType, errorTypes);
                    }
                }
            } else {
                CommonUtil.getErrorTypes(rawType, type, errorTypes);
            }
        }
    }

    public static List<TypeSymbol> extractErrorTypesFromUnion(UnionTypeSymbol unionType) {
        ArrayList<TypeSymbol> exactErrorTypes = new ArrayList<TypeSymbol>();
        for (TypeSymbol memType : unionType.userSpecifiedMemberTypes()) {
            CommonUtil.getErrorTypes(memType, null, exactErrorTypes);
        }
        return exactErrorTypes;
    }

    public static boolean isUnionOfType(TypeSymbol typeSymbol, TypeDescKind typeDescKind) {
        return typeSymbol.typeKind() == TypeDescKind.UNION && ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors().stream().map(CommonUtil::getRawType).map(TypeSymbol::typeKind).allMatch(kind -> kind == typeDescKind);
    }

    public static String getPackageLabel(LSPackageLoader.ModuleInfo module) {
        Object orgName = "";
        if (!module.packageOrg().isEmpty() && !module.packageOrg().equals(Names.ANON_ORG.getValue())) {
            orgName = module.packageOrg() + "/";
        }
        return (String)orgName + module.packageName();
    }

    public static String getModifiedSignature(DocumentServiceContext context, String signature) {
        Matcher matcher = TYPE_NAME_DECOMPOSE_PATTERN.matcher(signature);
        while (matcher.find()) {
            String orgName = matcher.group(1);
            String moduleName = matcher.group(2);
            String matchedString = matcher.group();
            String modulePrefix = ModuleUtil.getModulePrefix(context, orgName, moduleName);
            String replaceText = modulePrefix.isEmpty() ? matchedString + String.valueOf(Names.VERSION_SEPARATOR) : matchedString;
            signature = signature.replace(replaceText, modulePrefix);
        }
        return signature;
    }

    public static String escapeReservedKeyword(String value) {
        if (SyntaxInfo.isKeyword((String)value)) {
            return "'" + value;
        }
        return value;
    }

    public static Predicate<Symbol> getVariableFilterPredicate() {
        return symbol -> (symbol instanceof VariableSymbol || symbol.kind() == SymbolKind.PARAMETER || symbol.kind() == SymbolKind.PATH_PARAMETER) && !symbol.getName().orElse("").equals(Names.ERROR.getValue());
    }

    public static Boolean withinLockStatementNode(BallerinaCompletionContext context) {
        NonTerminalNode evalNode = context.getNodeAtCursor();
        do {
            if (evalNode.kind() != SyntaxKind.LOCK_STATEMENT) continue;
            return true;
        } while ((evalNode = evalNode.parent()) != null);
        return false;
    }

    public static Predicate<Symbol> typesFilter() {
        return symbol -> (symbol.kind() == SymbolKind.TYPE_DEFINITION || symbol.kind() == SymbolKind.CLASS || symbol.kind() == SymbolKind.ENUM || symbol.kind() == SymbolKind.ENUM_MEMBER || symbol.kind() == SymbolKind.CONSTANT) && !Names.ERROR.getValue().equals(symbol.getName().orElse(""));
    }

    public static List<Token> getQualifiersOfNode(BallerinaCompletionContext context, Node node) {
        ArrayList<Token> qualifiers = new ArrayList<Token>();
        switch (node.kind()) {
            case FUNCTION_TYPE_DESC: {
                ((FunctionTypeDescriptorNode)node).qualifierList().stream().forEach(qualifiers::add);
                break;
            }
            case OBJECT_TYPE_DESC: {
                ((ObjectTypeDescriptorNode)node).objectTypeQualifiers().stream().forEach(qualifiers::add);
                break;
            }
            case OBJECT_FIELD: {
                ObjectFieldNode objectFieldNode = (ObjectFieldNode)node;
                objectFieldNode.visibilityQualifier().ifPresent(qualifiers::add);
                objectFieldNode.qualifierList().stream().forEach(qualifiers::add);
                break;
            }
            case MODULE_VAR_DECL: {
                ModuleVariableDeclarationNode moduleVar = (ModuleVariableDeclarationNode)node;
                Optional visibilityQualifier = moduleVar.visibilityQualifier();
                visibilityQualifier.ifPresent(qualifiers::add);
                moduleVar.qualifiers().forEach(qualifiers::add);
                Set qualKinds = qualifiers.stream().map(Node::kind).collect(Collectors.toSet());
                CommonUtil.getQualifiersAtCursor(context).stream().filter(qual -> !qualKinds.contains(qual.kind())).forEach(qualifiers::add);
                if (!qualifiers.isEmpty()) break;
                moduleVar.typedBindingPattern().leadingInvalidTokens().stream().filter(token -> QUALIFIER_KINDS.contains(token.kind())).forEach(qualifiers::add);
                break;
            }
            case MODULE_PART: {
                List<Token> qualsAtCursor = CommonUtil.getQualifiersAtCursor(context);
                context.getNodeAtCursor().leadingInvalidTokens().stream().filter(token -> QUALIFIER_KINDS.contains(token.kind())).forEach(qualifiers::add);
                qualsAtCursor.stream().filter(token -> qualifiers.stream().noneMatch(qual -> qual.textRange().equals((Object)token.textRange()))).forEach(qualifiers::add);
                return qualifiers;
            }
        }
        Set qualKinds = qualifiers.stream().map(Node::kind).collect(Collectors.toSet());
        node.leadingInvalidTokens().stream().filter(token -> QUALIFIER_KINDS.contains(token.kind()) && !qualKinds.contains(token.kind())).forEach(qualifiers::add);
        return qualifiers;
    }

    public static List<Token> getQualifiersAtCursor(BallerinaCompletionContext context) {
        ArrayList<Token> qualifiers = new ArrayList<Token>();
        Token tokenAtCursor = context.getTokenAtCursor();
        if (QUALIFIER_KINDS.contains(tokenAtCursor.kind())) {
            qualifiers.add(tokenAtCursor);
            return qualifiers;
        }
        ArrayList tokensFromMinutiae = new ArrayList();
        context.getTokenAtCursor().leadingMinutiae().forEach(minutiae -> {
            if (minutiae.kind() != SyntaxKind.WHITESPACE_MINUTIAE && minutiae.kind() != SyntaxKind.END_OF_LINE_MINUTIAE) {
                tokensFromMinutiae.add(minutiae);
            }
        });
        if (tokensFromMinutiae.isEmpty()) {
            return qualifiers;
        }
        Minutiae tokenValueAtCursor = (Minutiae)tokensFromMinutiae.get(tokensFromMinutiae.size() - 1);
        tokenValueAtCursor.invalidTokenMinutiaeNode().ifPresent(invalidTokenMinutiaeNode -> {
            Token token = invalidTokenMinutiaeNode.invalidToken();
            if (QUALIFIER_KINDS.contains(token.kind())) {
                qualifiers.add(token);
            }
        });
        return qualifiers;
    }

    public static boolean isCompletionItemOfType(LSCompletionItem lsCItem, List<TypeDescKind> typesList) {
        if (lsCItem.getType() != LSCompletionItem.CompletionItemType.SYMBOL) {
            return false;
        }
        Symbol symbol = ((SymbolCompletionItem)lsCItem).getSymbol().orElse(null);
        Optional<TypeSymbol> typeDesc = SymbolUtil.getTypeDescriptor(symbol);
        if (typeDesc.isPresent()) {
            TypeSymbol rawType = CommonUtil.getRawType(typeDesc.get());
            return typesList.contains(rawType.typeKind());
        }
        return false;
    }

    public static Optional<Node> getMatchingNode(Node currentNode, Predicate<Node> predicate) {
        Node evalNode;
        for (evalNode = currentNode; evalNode != null && !predicate.test(evalNode); evalNode = evalNode.parent()) {
        }
        return Optional.ofNullable(evalNode);
    }

    public static List<String> getFuncArguments(FunctionSymbol symbol, BallerinaCompletionContext ctx) {
        List<ParameterSymbol> params = CommonUtil.getFunctionParameters(symbol, ctx);
        return params.stream().map(param -> CommonUtil.getFunctionParamaterSyntax(param, ctx).orElse("")).toList();
    }

    public static Optional<String> getFunctionParamaterSyntax(ParameterSymbol param, BallerinaCompletionContext ctx) {
        if (param.paramKind() == ParameterKind.REST) {
            ArrayTypeSymbol typeSymbol = (ArrayTypeSymbol)param.typeDescriptor();
            return Optional.of(NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, typeSymbol.memberTypeDescriptor()) + (String)(param.getName().isEmpty() ? "" : "... " + (String)param.getName().get()));
        }
        if (param.typeDescriptor().typeKind() == TypeDescKind.COMPILATION_ERROR) {
            return Optional.empty();
        }
        return Optional.of(NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, param.typeDescriptor()) + (String)(param.getName().isEmpty() ? "" : " " + (String)param.getName().get()));
    }

    public static List<ParameterSymbol> getFunctionParameters(FunctionSymbol symbol, BallerinaCompletionContext ctx) {
        boolean skipFirstParam = CommonUtil.skipFirstParam(ctx, symbol);
        FunctionTypeSymbol functionTypeDesc = symbol.typeDescriptor();
        Optional restParam = functionTypeDesc.restParam();
        ArrayList<ParameterSymbol> parameterDefs = new ArrayList<ParameterSymbol>();
        if (functionTypeDesc.params().isPresent()) {
            List params = (List)functionTypeDesc.params().get();
            if (skipFirstParam) {
                if (params.size() > 1) {
                    parameterDefs.addAll(params.subList(1, params.size()));
                }
            } else {
                parameterDefs.addAll(params);
            }
        }
        restParam.ifPresent(parameterDefs::add);
        return parameterDefs;
    }

    public static boolean skipFirstParam(BallerinaCompletionContext context, FunctionSymbol functionSymbol) {
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        return CommonUtil.isLangLib(((ModuleSymbol)functionSymbol.getModule().get()).id()) && nodeAtCursor.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE;
    }

    public static TextEdit getTextEdit(SyntaxTree syntaxTree, org.eclipse.lsp4j.TextEdit textEdit) {
        TextDocument textDocument = syntaxTree.textDocument();
        int start = textDocument.textPositionFrom(PositionUtil.getLinePosition(textEdit.getRange().getStart()));
        int end = textDocument.textPositionFrom(PositionUtil.getLinePosition(textEdit.getRange().getEnd()));
        return TextEdit.from((TextRange)TextRange.from((int)start, (int)(end - start)), (String)textEdit.getNewText());
    }

    public static Optional<Token> getLastQualifier(BallerinaCompletionContext context, Node node) {
        List<Token> qualifiers = CommonUtil.getQualifiersOfNode(context, node);
        if (qualifiers.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(qualifiers.get(qualifiers.size() - 1));
    }

    public static boolean hasMultipleDiagnostics(CodeActionContext context, NonTerminalNode node, Diagnostic currentDiagnostic, Set<String> diagnostics, String prioritizedDiagnostic) {
        List projectDiagnostics = context.diagnostics(context.filePath());
        return projectDiagnostics.size() > 1 && projectDiagnostics.stream().anyMatch(diagnostic -> !currentDiagnostic.equals(diagnostic) && diagnostics.contains(diagnostic.diagnosticInfo().code()) && PositionUtil.isWithinLineRange(diagnostic.location().lineRange(), node.lineRange())) && currentDiagnostic.diagnosticInfo().code().equals(prioritizedDiagnostic);
    }

    public static boolean hasUnresolvedModules(SemanticModel semanticModel) {
        return semanticModel.diagnostics().stream().anyMatch(diagnostic -> UNRESOLVED_MODULE_CODE.equals(diagnostic.diagnosticInfo().code()));
    }

    public static Optional<Node> getMappingContextEvalNode(Node nodeAtCursor) {
        Predicate<Node> predicate = node -> node.kind() == SyntaxKind.MAPPING_CONSTRUCTOR || node.parent().kind() == SyntaxKind.MAPPING_CONSTRUCTOR || node.kind() == SyntaxKind.MAPPING_MATCH_PATTERN || node.parent().kind() == SyntaxKind.MAPPING_MATCH_PATTERN || node.kind() == SyntaxKind.SPECIFIC_FIELD || node.kind() == SyntaxKind.COMPUTED_NAME_FIELD;
        return CommonUtil.getMatchingNode(nodeAtCursor, predicate);
    }

    static {
        SDK_VERSION = System.getProperty("ballerina.version");
        PRE_DECLARED_LANG_LIBS = Arrays.asList("lang.boolean", "lang.decimal", "lang.error", "lang.float", "lang.function", "lang.future", "lang.int", "lang.map", "lang.object", "lang.stream", "lang.string", "lang.table", "lang.transaction", "lang.typedesc", "lang.xml", "lang.natural");
        BALLERINA_KEYWORDS = SyntaxInfo.keywords();
        QUALIFIER_KINDS = Set.of(SyntaxKind.SERVICE_KEYWORD, SyntaxKind.CLIENT_KEYWORD, SyntaxKind.ISOLATED_KEYWORD, SyntaxKind.TRANSACTIONAL_KEYWORD, SyntaxKind.PUBLIC_KEYWORD, SyntaxKind.PRIVATE_KEYWORD, SyntaxKind.CONFIGURABLE_KEYWORD);
        TYPE_NAME_DECOMPOSE_PATTERN = Pattern.compile("([\\w_.]*)/([\\w._]*):([\\w.-]*)");
        BALLERINA_HOME = System.getProperty("ballerina.home");
        String onlineCompilation = System.getProperty("ls.compilation.online");
        COMPILE_OFFLINE = !Boolean.parseBoolean(onlineCompilation);
        BALLERINA_CMD = BALLERINA_HOME + File.separator + "bin" + File.separator + "bal" + (SystemUtils.IS_OS_WINDOWS ? ".bat" : "");
    }
}

