/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common.utils;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.tools.diagnostics.Location;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.wso2.ballerinalang.util.RepoUtils;

public final class PathUtil {
    private PathUtil() {
    }

    public static Optional<Path> getPathFromURI(String fileUri) {
        URI uri = URI.create(fileUri);
        String scheme = uri.getScheme();
        try {
            if ("expr".equals(uri.getScheme()) || "bala".equals(uri.getScheme())) {
                scheme = "file";
            }
            URI converted = new URI(scheme, uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            return Optional.of(Path.of(converted));
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }

    public static boolean isWriteProtectedPath(Path filePath) {
        Path homeReposPath = RepoUtils.createAndGetHomeReposPath();
        Path ballerinaHome = CommonUtil.BALLERINA_HOME != null ? Path.of(CommonUtil.BALLERINA_HOME, new String[0]) : null;
        return filePath.startsWith(homeReposPath) || ballerinaHome != null && filePath.startsWith(ballerinaHome);
    }

    public static String convertUriSchemeFromBala(String fileUri) throws URISyntaxException {
        URI uri = URI.create(fileUri);
        if ("bala".equals(uri.getScheme())) {
            URI converted = new URI("file", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            return converted.toString();
        }
        return fileUri;
    }

    public static String getBalaUriForPath(LanguageServerContext serverContext, Path filePath) throws URISyntaxException {
        LSClientCapabilities clientCapabilities = (LSClientCapabilities)serverContext.get(LSClientCapabilities.class);
        if (clientCapabilities.getInitializationOptions().isBalaSchemeSupported()) {
            return PathUtil.getUriForPath(filePath, "bala");
        }
        return filePath.toUri().toString();
    }

    public static String getUriForPath(Path filePath, String scheme) throws URISyntaxException {
        URI uri = filePath.toUri();
        uri = new URI(scheme, uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        return uri.toString();
    }

    public static Optional<Path> getFilePathForSymbol(Symbol symbol, Project project, DocumentServiceContext context) {
        String moduleName;
        if (symbol.getLocation().isEmpty() || symbol.getModule().isEmpty()) {
            return Optional.empty();
        }
        String orgName = ((ModuleSymbol)symbol.getModule().get()).id().orgName();
        if (CommonUtil.isLangLib(orgName, moduleName = ((ModuleSymbol)symbol.getModule().get()).id().moduleName())) {
            return PathUtil.getFilePathForLanglibSymbol(project, symbol);
        }
        Collection dependencies = project.currentPackage().getResolution().dependencyGraph().getNodes();
        String sourceFile = ((Location)symbol.getLocation().get()).lineRange().fileName();
        for (ResolvedPackageDependency depNode : dependencies) {
            Package depPackage = depNode.packageInstance();
            if (!depPackage.packageOrg().value().equals(orgName)) continue;
            for (ModuleId moduleId : depPackage.moduleIds()) {
                if (depPackage.module(moduleId).moduleName().toString().equals(moduleName)) {
                    Module module = depPackage.module(moduleId);
                    for (DocumentId docId : module.documentIds()) {
                        if (!module.document(docId).name().equals(sourceFile)) continue;
                        return module.project().documentPath(docId);
                    }
                    for (DocumentId docId : module.testDocumentIds()) {
                        if (!module.document(docId).name().equals(sourceFile)) continue;
                        return module.project().documentPath(docId);
                    }
                }
                context.checkCancelled();
            }
        }
        return Optional.empty();
    }

    private static Optional<Path> getFilePathForLanglibSymbol(Project project, Symbol symbol) {
        if (symbol.getLocation().isEmpty() || symbol.getModule().isEmpty()) {
            return Optional.empty();
        }
        String orgName = ((ModuleSymbol)symbol.getModule().get()).id().orgName();
        String moduleName = ((ModuleSymbol)symbol.getModule().get()).id().moduleName();
        List langLibPackages = ((PackageCache)project.projectEnvironmentContext().environment().getService(PackageCache.class)).getPackages(PackageOrg.from((String)orgName), PackageName.from((String)moduleName));
        if (langLibPackages.isEmpty()) {
            return Optional.empty();
        }
        Package langLibPackage = (Package)langLibPackages.get(0);
        String sourceFile = ((Location)symbol.getLocation().get()).lineRange().fileName();
        Optional filepath = Optional.empty();
        block0: for (ModuleId moduleId : langLibPackage.moduleIds()) {
            Module module = langLibPackage.module(moduleId);
            for (DocumentId docId : module.documentIds()) {
                if (!module.document(docId).name().equals(sourceFile)) continue;
                filepath = module.project().documentPath(docId);
                continue block0;
            }
        }
        return filepath;
    }

    public static String getModifiedUri(WorkspaceManager workspaceManager, String uri) {
        URI original = URI.create(uri);
        try {
            return new URI(workspaceManager.uriScheme(), original.getSchemeSpecificPart(), original.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            return uri;
        }
    }

    public static String getUriFromLocation(Module module, Location location) {
        return PathUtil.getPathFromLocation(module, location).toUri().toString();
    }

    public static Path getPathFromLocation(Module module, Location location) {
        String filePath = location.lineRange().fileName();
        if (module.project().kind() == ProjectKind.SINGLE_FILE_PROJECT) {
            return module.project().sourceRoot();
        }
        if (module.project().kind() == ProjectKind.BALA_PROJECT) {
            return module.project().sourceRoot().resolve("modules").resolve(module.moduleName().toString()).resolve(filePath);
        }
        Path sourceRoot = module.project().sourceRoot();
        if (module.isDefaultModule()) {
            if (Files.exists(sourceRoot.resolve("generated").resolve(filePath), new LinkOption[0])) {
                return sourceRoot.resolve("generated").resolve(filePath);
            }
            return sourceRoot.resolve(filePath);
        }
        if (Files.exists(sourceRoot.resolve("generated").resolve(module.moduleName().moduleNamePart()).resolve(filePath), new LinkOption[0])) {
            return sourceRoot.resolve("generated").resolve(module.moduleName().moduleNamePart()).resolve(filePath);
        }
        return sourceRoot.resolve("modules").resolve(module.moduleName().moduleNamePart()).resolve(filePath);
    }

    public static Range getRange(Location referencePos) {
        Position start = new Position(referencePos.lineRange().startLine().line(), referencePos.lineRange().startLine().offset());
        Position end = new Position(referencePos.lineRange().endLine().line(), referencePos.lineRange().endLine().offset());
        return new Range(start, end);
    }
}

