/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectFieldSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.api.symbols.WorkerSymbol;
import io.ballerina.compiler.api.symbols.XMLNamespaceSymbol;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ballerinalang.langserver.LSPackageLoader;
import org.ballerinalang.langserver.codeaction.CodeActionModuleId;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.CompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.commons.completion.spi.BallerinaCompletionProvider;
import org.ballerinalang.langserver.completions.FunctionPointerCompletionItem;
import org.ballerinalang.langserver.completions.ObjectFieldCompletionItem;
import org.ballerinalang.langserver.completions.RecordFieldCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.StaticCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.builder.ConstantCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.FieldCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.FunctionCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.ParameterCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.ResourcePathCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.StreamTypeInitCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.TypeCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.VariableCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.WorkerCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.XMLNSCompletionItemBuilder;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SnippetBlock;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.TextEdit;
import org.wso2.ballerinalang.compiler.util.Names;

public abstract class AbstractCompletionProvider<T extends Node>
implements BallerinaCompletionProvider<T> {
    private final List<Class<T>> attachmentPoints;
    protected BallerinaCompletionProvider.Precedence precedence = BallerinaCompletionProvider.Precedence.LOW;

    public AbstractCompletionProvider(List<Class<T>> attachmentPoints) {
        this.attachmentPoints = attachmentPoints;
    }

    public AbstractCompletionProvider(Class<T> attachmentPoint) {
        this.attachmentPoints = Collections.singletonList(attachmentPoint);
    }

    public List<Class<T>> getAttachmentPoints() {
        return this.attachmentPoints;
    }

    public BallerinaCompletionProvider.Precedence getPrecedence() {
        return this.precedence;
    }

    public boolean onPreValidation(BallerinaCompletionContext context, T node) {
        return true;
    }

    public void sort(BallerinaCompletionContext context, T node, List<LSCompletionItem> completionItems) {
        SortingUtil.toDefaultSorting(context, completionItems);
    }

    public void sort(BallerinaCompletionContext context, T node, List<LSCompletionItem> completionItems, Object ... metaData) {
        this.sort(context, node, completionItems);
    }

    protected List<LSCompletionItem> getCompletionItemList(List<? extends Symbol> scopeEntries, BallerinaCompletionContext ctx) {
        ArrayList processedSymbols = new ArrayList();
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        scopeEntries.forEach(symbol -> {
            if (processedSymbols.contains(symbol)) {
                return;
            }
            if (symbol.kind() == SymbolKind.FUNCTION || symbol.kind() == SymbolKind.METHOD || symbol.kind() == SymbolKind.RESOURCE_METHOD) {
                FunctionSymbol functionSymbol = (FunctionSymbol)symbol;
                if (functionSymbol.getName().isPresent() && !((String)functionSymbol.getName().get()).contains("$")) {
                    completionItems.addAll(this.populateBallerinaFunctionCompletionItems(functionSymbol, ctx));
                }
            } else if (symbol.kind() == SymbolKind.CONSTANT || symbol.kind() == SymbolKind.ENUM_MEMBER) {
                CompletionItem constantCItem = ConstantCompletionItemBuilder.build((ConstantSymbol)symbol, (CompletionContext)ctx);
                completionItems.add((LSCompletionItem)new SymbolCompletionItem(ctx, (Symbol)symbol, constantCItem));
            } else if (symbol.kind() == SymbolKind.VARIABLE) {
                VariableSymbol varSymbol = (VariableSymbol)symbol;
                if (varSymbol.qualifiers().contains(Qualifier.ISOLATED) && !CommonUtil.withinLockStatementNode(ctx).booleanValue()) {
                    return;
                }
                TypeSymbol typeDesc = varSymbol.typeDescriptor();
                String typeName = typeDesc == null || typeDesc.typeKind() == null ? "" : NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, typeDesc);
                CompletionItem variableCItem = VariableCompletionItemBuilder.build(varSymbol, varSymbol.getName().orElse(""), typeName);
                completionItems.add((LSCompletionItem)new SymbolCompletionItem(ctx, (Symbol)symbol, variableCItem));
                if (typeDesc != null) {
                    TypeSymbol rawType = CommonUtil.getRawType(typeDesc);
                    completionItems.addAll(this.populateSelfClassSymbolCompletionItems((Symbol)symbol, ctx, rawType));
                }
            } else if (symbol.kind() == SymbolKind.PARAMETER) {
                ParameterSymbol paramSymbol = (ParameterSymbol)symbol;
                TypeSymbol typeDesc = paramSymbol.typeDescriptor();
                String typeName = NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, typeDesc);
                CompletionItem variableCItem = ParameterCompletionItemBuilder.build((String)paramSymbol.getName().get(), typeName);
                completionItems.add((LSCompletionItem)new SymbolCompletionItem(ctx, (Symbol)symbol, variableCItem));
            } else if (symbol.kind() == SymbolKind.PATH_PARAMETER) {
                PathParameterSymbol paramSymbol = (PathParameterSymbol)symbol;
                TypeSymbol typeDesc = paramSymbol.typeDescriptor();
                String typeName = NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, typeDesc);
                CompletionItem variableCItem = ParameterCompletionItemBuilder.build((String)paramSymbol.getName().get(), typeName);
                completionItems.add((LSCompletionItem)new SymbolCompletionItem(ctx, (Symbol)symbol, variableCItem));
            } else if (symbol.kind() == SymbolKind.TYPE_DEFINITION || symbol.kind() == SymbolKind.CLASS || symbol.kind() == SymbolKind.ENUM) {
                CompletionItem typeCItem = TypeCompletionItemBuilder.build(symbol, (String)symbol.getName().get());
                completionItems.add((LSCompletionItem)new SymbolCompletionItem(ctx, (Symbol)symbol, typeCItem));
            } else if (symbol.kind() == SymbolKind.WORKER) {
                CompletionItem workerItem = WorkerCompletionItemBuilder.build((WorkerSymbol)symbol);
                completionItems.add((LSCompletionItem)new SymbolCompletionItem(ctx, (Symbol)symbol, workerItem));
            } else if (symbol.kind() == SymbolKind.XMLNS) {
                CompletionItem xmlItem = XMLNSCompletionItemBuilder.build((XMLNamespaceSymbol)symbol);
                completionItems.add((LSCompletionItem)new SymbolCompletionItem(ctx, (Symbol)symbol, xmlItem));
            } else if (symbol.kind() == SymbolKind.RECORD_FIELD) {
                RecordFieldSymbol recordFieldSymbol = (RecordFieldSymbol)symbol;
                CompletionItem recFieldItem = FieldCompletionItemBuilder.build(recordFieldSymbol, ctx);
                completionItems.add((LSCompletionItem)new RecordFieldCompletionItem(ctx, recordFieldSymbol, recFieldItem));
            } else if (symbol.kind() == SymbolKind.OBJECT_FIELD || symbol.kind() == SymbolKind.CLASS_FIELD) {
                ObjectFieldSymbol objectFieldSymbol = (ObjectFieldSymbol)symbol;
                CompletionItem objFieldItem = FieldCompletionItemBuilder.build(objectFieldSymbol, false);
                completionItems.add((LSCompletionItem)new ObjectFieldCompletionItem(ctx, objectFieldSymbol, objFieldItem));
            }
            processedSymbols.add(symbol);
        });
        return completionItems;
    }

    private List<LSCompletionItem> getTypeItems(BallerinaCompletionContext context) {
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        visibleSymbols.stream().filter(CommonUtil.typesFilter()).forEach(symbol -> {
            CompletionItem cItem = TypeCompletionItemBuilder.build(symbol, (String)symbol.getName().get());
            completionItems.add((LSCompletionItem)new SymbolCompletionItem(context, (Symbol)symbol, cItem));
        });
        completionItems.addAll(this.getBasicAndOtherTypeCompletions(context));
        completionItems.addAll(Arrays.asList(new SnippetCompletionItem(context, Snippet.KW_SERVICE.get()), new SnippetCompletionItem(context, Snippet.KW_RECORD.get()), new SnippetCompletionItem(context, Snippet.KW_FUNCTION.get()), new SnippetCompletionItem(context, Snippet.DEF_RECORD_TYPE_DESC.get()), new SnippetCompletionItem(context, Snippet.DEF_CLOSED_RECORD_TYPE_DESC.get()), new SnippetCompletionItem(context, Snippet.KW_DISTINCT.get()), new SnippetCompletionItem(context, Snippet.DEF_OBJECT_TYPE_DESC_SNIPPET.get()), new SnippetCompletionItem(context, Snippet.KW_TRUE.get()), new SnippetCompletionItem(context, Snippet.KW_FALSE.get()), new SnippetCompletionItem(context, Snippet.KW_NIL.get())));
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (nodeAtCursor.kind() != SyntaxKind.SIMPLE_NAME_REFERENCE) {
            return completionItems;
        }
        String prefix = ((SimpleNameReferenceNode)nodeAtCursor).name().text().toLowerCase(Locale.ENGLISH);
        context.currentDocImportsMap().forEach((importDeclarationNode, moduleSymbol) -> {
            List symbols = moduleSymbol.allSymbols();
            CodeActionModuleId moduleId = CodeActionModuleId.from(importDeclarationNode);
            List<Symbol> filteredList = SymbolUtil.filterSymbolsByPrefix(symbols, context, prefix, moduleId);
            List<LSCompletionItem> completionItemList = this.getCompletionItemList(filteredList, context);
            for (LSCompletionItem lsCompletionItem : completionItemList) {
                CompletionItem completionItem = lsCompletionItem.getCompletionItem();
                String insertText = completionItem.getInsertText();
                String label = completionItem.getLabel();
                String moduleName = importDeclarationNode.prefix().isEmpty() ? ((IdentifierToken)importDeclarationNode.moduleName().get(importDeclarationNode.moduleName().size() - 1)).text() : ((ImportPrefixNode)importDeclarationNode.prefix().get()).prefix().text();
                completionItem.setInsertText(moduleName + ":" + insertText);
                completionItem.setLabel(moduleName + ":" + label);
                completionItems.add(lsCompletionItem);
                if (completionItem.getFilterText() == null) continue;
                completionItem.setFilterText(moduleName + "_" + completionItem.getFilterText());
            }
        });
        return completionItems;
    }

    protected List<LSCompletionItem> getTypeDescContextItems(BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        completionItems.addAll(this.getTypeItems(context));
        completionItems.addAll(this.getModuleCompletionItems(context));
        return completionItems;
    }

    protected List<LSCompletionItem> getModuleCompletionItems(BallerinaCompletionContext ctx) {
        ArrayList processedList = new ArrayList();
        Map currentDocImports = ctx.currentDocImportsMap();
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        currentDocImports.forEach((importNode, moduleSymbol) -> {
            String orgName = importNode.orgName().isEmpty() ? "" : ((ImportOrgNameNode)importNode.orgName().get()).orgName().text();
            String pkgName = importNode.moduleName().stream().map(Token::text).collect(Collectors.joining("."));
            if (CommonUtil.PRE_DECLARED_LANG_LIBS.contains(pkgName.replace("'", ""))) {
                return;
            }
            String processedModuleHash = orgName.isEmpty() ? pkgName : orgName + "/" + pkgName;
            String prefix = importNode.prefix().isEmpty() ? ((IdentifierToken)importNode.moduleName().get(importNode.moduleName().size() - 1)).text() : ((ImportPrefixNode)importNode.prefix().get()).prefix().text();
            String label = prefix;
            String insertText = CommonUtil.escapeReservedKeyword(prefix);
            CompletionItem item = this.getModuleCompletionItem(label, insertText, new ArrayList<TextEdit>(), prefix);
            processedList.add(processedModuleHash);
            completionItems.add((LSCompletionItem)new SymbolCompletionItem(ctx, (Symbol)moduleSymbol, item));
        });
        List<LSPackageLoader.ModuleInfo> modules = LSPackageLoader.getInstance(ctx.languageServercontext()).getAllVisiblePackages((DocumentServiceContext)ctx);
        modules.forEach(pkg -> {
            String name = pkg.packageName();
            String orgName = ModuleUtil.escapeModuleName(pkg.packageOrg());
            if (ModuleUtil.matchingImportedModule((CompletionContext)ctx, pkg).isEmpty() && !processedList.contains(orgName + "/" + name) && !CommonUtil.PRE_DECLARED_LANG_LIBS.contains(name)) {
                List<String> pkgNameComps = Arrays.stream(name.split("\\.")).map(ModuleUtil::escapeModuleName).map(CommonUtil::escapeReservedKeyword).toList();
                String label = pkg.packageOrg().isEmpty() ? String.join((CharSequence)".", pkgNameComps) : CommonUtil.getPackageLabel(pkg);
                String aliasComponent = pkgNameComps.get(pkgNameComps.size() - 1);
                String insertText = CommonUtil.escapeReservedKeyword(NameUtil.getValidatedSymbolName((PositionedOperationContext)ctx, aliasComponent));
                String alias = !insertText.equals(aliasComponent) ? insertText : "";
                List<TextEdit> txtEdits = CommonUtil.getAutoImportTextEdits("", label, alias, (DocumentServiceContext)ctx);
                CompletionItem item = this.getModuleCompletionItem(label, insertText, txtEdits, aliasComponent);
                completionItems.add((LSCompletionItem)new StaticCompletionItem(ctx, item, StaticCompletionItem.Kind.MODULE));
            }
        });
        completionItems.addAll(this.getPredeclaredLangLibCompletions(ctx));
        return completionItems;
    }

    @Deprecated(forRemoval=true)
    protected boolean onQualifiedNameIdentifier(CompletionContext context, Node node) {
        int cursor;
        if (node.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return false;
        }
        int colonPos = ((QualifiedNameReferenceNode)node).colon().textRange().startOffset();
        return colonPos < (cursor = context.getCursorPositionInTree());
    }

    protected Optional<LSCompletionItem> getExplicitNewCompletionItem(Symbol symbol, BallerinaCompletionContext context) {
        if (SymbolUtil.isClassDefinition(symbol)) {
            ClassSymbol classSymbol = (ClassSymbol)symbol;
            CompletionItem cItem = FunctionCompletionItemBuilder.build(classSymbol, FunctionCompletionItemBuilder.InitializerBuildMode.EXPLICIT, context);
            MethodSymbol initMethod = classSymbol.initMethod().isPresent() ? (MethodSymbol)classSymbol.initMethod().get() : null;
            return Optional.of(new SymbolCompletionItem(context, (Symbol)initMethod, cItem));
        }
        if (SymbolUtil.isOfType(symbol, TypeDescKind.STREAM)) {
            TypeDefinitionSymbol typeSymbol = (TypeDefinitionSymbol)symbol;
            CompletionItem cItem = StreamTypeInitCompletionItemBuilder.build(typeSymbol, context);
            return Optional.of(new SymbolCompletionItem(context, (Symbol)typeSymbol.typeDescriptor(), cItem));
        }
        return Optional.empty();
    }

    protected LSCompletionItem getImplicitNewCItemForStreamType(TypeSymbol symbol, BallerinaCompletionContext context) {
        CompletionItem cItem = StreamTypeInitCompletionItemBuilder.build();
        return new SymbolCompletionItem(context, (Symbol)symbol, cItem);
    }

    protected LSCompletionItem getImplicitNewCItemForClass(ClassSymbol symbol, BallerinaCompletionContext context) {
        CompletionItem cItem = FunctionCompletionItemBuilder.build(symbol, FunctionCompletionItemBuilder.InitializerBuildMode.IMPLICIT, context);
        MethodSymbol initMethod = symbol.initMethod().isPresent() ? (MethodSymbol)symbol.initMethod().get() : null;
        return new SymbolCompletionItem(context, (Symbol)initMethod, cItem);
    }

    protected List<LSCompletionItem> populateBallerinaFunctionCompletionItems(FunctionSymbol symbol, BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Optional contextType = context.getContextType();
        if (contextType.isPresent() && ((TypeSymbol)contextType.get()).typeKind() == TypeDescKind.FUNCTION && symbol.kind() != SymbolKind.RESOURCE_METHOD) {
            CompletionItem pointerCompletionItem = FunctionCompletionItemBuilder.buildFunctionPointer(symbol, context);
            completionItems.add((LSCompletionItem)new FunctionPointerCompletionItem(context, (Symbol)symbol, pointerCompletionItem));
        }
        if (symbol.kind() == SymbolKind.RESOURCE_METHOD && symbol.getName().isPresent()) {
            ResourcePathCompletionItemBuilder.build((ResourceMethodSymbol)symbol, context).stream().map(completionItem -> new SymbolCompletionItem(context, (Symbol)symbol, (CompletionItem)completionItem)).forEach(completionItems::add);
        } else {
            CompletionItem completionItem2 = FunctionCompletionItemBuilder.build(symbol, context);
            completionItems.add((LSCompletionItem)new SymbolCompletionItem(context, (Symbol)symbol, completionItem2));
        }
        return completionItems;
    }

    protected List<LSCompletionItem> actionKWCompletions(BallerinaCompletionContext context) {
        return Arrays.asList(new LSCompletionItem[]{new SnippetCompletionItem(context, Snippet.KW_START.get()), new SnippetCompletionItem(context, Snippet.KW_WAIT.get()), new SnippetCompletionItem(context, Snippet.KW_FLUSH.get()), new SnippetCompletionItem(context, Snippet.CLAUSE_FROM.get())});
    }

    protected List<LSCompletionItem> expressionCompletions(BallerinaCompletionContext context) {
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(this.getModuleCompletionItems(context));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_SERVICE.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_NEW.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ISOLATED.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_TRANSACTIONAL.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FUNCTION.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_LET.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_TYPEOF.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_TRAP.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_CLIENT.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_TRUE.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FALSE.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_NIL.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_CHECK.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_CHECK_PANIC.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_IS.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.EXPR_ERROR_CONSTRUCTOR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.EXPR_OBJECT_CONSTRUCTOR.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.EXPR_BASE16_LITERAL.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.EXPR_BASE64_LITERAL.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FROM.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_REG_EXP.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_STRING.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_XML.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_NATURAL_EXPR.get()));
        Predicate<Symbol> symbolFilter = this.getExpressionContextSymbolFilter();
        List<Symbol> filteredList = visibleSymbols.stream().filter(symbolFilter).sorted(Comparator.comparing(symbol -> (String)symbol.getName().get())).toList();
        completionItems.addAll(this.getCompletionItemList(filteredList, context));
        completionItems.addAll(this.getBasicAndOtherTypeCompletions(context));
        this.getAnonFunctionDefSnippet(context).ifPresent(completionItems::add);
        return completionItems;
    }

    protected Predicate<Symbol> getExpressionContextSymbolFilter() {
        Predicate<Symbol> symbolFilter = CommonUtil.getVariableFilterPredicate();
        symbolFilter = symbolFilter.or(symbol -> (symbol.kind() == SymbolKind.FUNCTION || symbol.kind() == SymbolKind.TYPE_DEFINITION || symbol.kind() == SymbolKind.CLASS) && !symbol.getName().orElse("").equals(Names.ERROR.getValue()));
        return symbolFilter;
    }

    protected List<LSCompletionItem> expressionCompletions(BallerinaCompletionContext context, T node) {
        return this.expressionCompletions(context);
    }

    protected List<LSCompletionItem> getTypeQualifierItems(BallerinaCompletionContext context) {
        return Arrays.asList(new LSCompletionItem[]{new SnippetCompletionItem(context, Snippet.KW_ISOLATED.get()), new SnippetCompletionItem(context, Snippet.KW_CLIENT.get()), new SnippetCompletionItem(context, Snippet.KW_TRANSACTIONAL.get())});
    }

    private List<LSCompletionItem> getBasicAndOtherTypeCompletions(BallerinaCompletionContext context) {
        Optional semanticModel = context.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            return Collections.emptyList();
        }
        Types types = ((SemanticModel)semanticModel.get()).types();
        ArrayList<TypeSymbol> typeSymbols = new ArrayList<TypeSymbol>();
        typeSymbols.add(types.READONLY);
        typeSymbols.add(types.HANDLE);
        typeSymbols.add(types.NEVER);
        typeSymbols.add(types.JSON);
        typeSymbols.add(types.ANYDATA);
        typeSymbols.add(types.ANY);
        typeSymbols.add(types.BYTE);
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        typeSymbols.forEach(type -> {
            CompletionItem cItem = TypeCompletionItemBuilder.build((Symbol)type, type.signature());
            completionItems.add((LSCompletionItem)new SymbolCompletionItem(context, (Symbol)type, cItem));
        });
        return completionItems;
    }

    protected List<LSCompletionItem> getPredeclaredLangLibCompletions(BallerinaCompletionContext context) {
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Optional<Types> types = context.currentSemanticModel().map(SemanticModel::types);
        visibleSymbols.stream().filter(symbol -> symbol.getName().isPresent() && symbol.kind() == SymbolKind.MODULE).map(symbol -> (ModuleSymbol)symbol).filter(moduleSymbol -> CommonUtil.PRE_DECLARED_LANG_LIBS.contains(moduleSymbol.id().moduleName())).forEach(moduleSymbol -> {
            TypeSymbol typeSymbol = null;
            if (types.isPresent()) {
                switch (moduleSymbol.id().moduleName()) {
                    case "lang.boolean": {
                        typeSymbol = ((Types)types.get()).BOOLEAN;
                        break;
                    }
                    case "lang.int": {
                        typeSymbol = ((Types)types.get()).INT;
                        break;
                    }
                    case "lang.error": {
                        typeSymbol = ((Types)types.get()).ERROR;
                        break;
                    }
                    case "lang.decimal": {
                        typeSymbol = ((Types)types.get()).DECIMAL;
                        break;
                    }
                    case "lang.float": {
                        typeSymbol = ((Types)types.get()).FLOAT;
                        break;
                    }
                    case "lang.function": {
                        typeSymbol = ((Types)types.get()).FUNCTION;
                        break;
                    }
                    case "lang.future": {
                        typeSymbol = ((Types)types.get()).FUTURE;
                        break;
                    }
                    case "lang.typedesc": {
                        typeSymbol = ((Types)types.get()).TYPEDESC;
                        break;
                    }
                    case "lang.string": {
                        typeSymbol = ((Types)types.get()).STRING;
                        break;
                    }
                    case "lang.xml": {
                        typeSymbol = ((Types)types.get()).XML;
                        break;
                    }
                }
            }
            CompletionItem cItem = TypeCompletionItemBuilder.build(typeSymbol, moduleSymbol.id().modulePrefix());
            completionItems.add((LSCompletionItem)new SymbolCompletionItem(context, (Symbol)Objects.requireNonNullElse(typeSymbol, moduleSymbol), cItem));
        });
        return completionItems;
    }

    protected List<LSCompletionItem> getBuiltInTypes(BallerinaCompletionContext context) {
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        visibleSymbols.stream().filter(symbol -> symbol.getName().isPresent() && symbol.kind() == SymbolKind.MODULE).map(symbol -> (ModuleSymbol)symbol).filter(moduleSymbol -> CommonUtil.isLangLib(moduleSymbol.id())).forEach(moduleSymbol -> {
            CompletionItem cItem = TypeCompletionItemBuilder.build(null, moduleSymbol.id().modulePrefix());
            completionItems.add((LSCompletionItem)new SymbolCompletionItem(context, (Symbol)moduleSymbol, cItem));
        });
        return completionItems;
    }

    private CompletionItem getModuleCompletionItem(String label, String insertText, @Nonnull List<TextEdit> txtEdits, String prefix) {
        CompletionItem moduleCompletionItem = new CompletionItem();
        moduleCompletionItem.setLabel(label);
        if (prefix != null) {
            moduleCompletionItem.setFilterText(prefix);
        }
        moduleCompletionItem.setInsertText(insertText);
        moduleCompletionItem.setDetail("Module");
        moduleCompletionItem.setKind(CompletionItemKind.Module);
        if (!txtEdits.isEmpty()) {
            moduleCompletionItem.setAdditionalTextEdits(txtEdits);
        }
        return moduleCompletionItem;
    }

    private List<LSCompletionItem> populateSelfClassSymbolCompletionItems(Symbol symbol, BallerinaCompletionContext ctx, TypeSymbol rawType) {
        Optional moduleMember = ctx.enclosedModuleMember();
        if (moduleMember.isEmpty() || !SymbolUtil.isSelfClassSymbol(symbol, (PositionedOperationContext)ctx, (ModuleMemberDeclarationNode)moduleMember.get()) && !SymbolUtil.isSelfObjectSymbol(symbol, (Node)ctx.getNodeAtCursor())) {
            return Collections.emptyList();
        }
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        ObjectTypeSymbol objectTypeDesc = (ObjectTypeSymbol)rawType;
        objectTypeDesc.fieldDescriptors().values().stream().map(classFieldSymbol -> {
            CompletionItem completionItem = FieldCompletionItemBuilder.build(classFieldSymbol, true);
            return new ObjectFieldCompletionItem(ctx, (ObjectFieldSymbol)classFieldSymbol, completionItem);
        }).forEach(completionItems::add);
        objectTypeDesc.methods().values().stream().map(methodSymbol -> {
            CompletionItem completionItem = FunctionCompletionItemBuilder.buildMethod((FunctionSymbol)methodSymbol, ctx);
            return new SymbolCompletionItem(ctx, (Symbol)methodSymbol, completionItem);
        }).forEach(completionItems::add);
        return completionItems;
    }

    protected List<LSCompletionItem> getCompletionItemsOnQualifiers(Node node, BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List<Token> qualifiers = CommonUtil.getQualifiersOfNode(context, node);
        if (qualifiers.isEmpty()) {
            return completionItems;
        }
        Token lastQualifier = qualifiers.get(qualifiers.size() - 1);
        Set qualKinds = qualifiers.stream().map(Node::kind).collect(Collectors.toSet());
        switch (lastQualifier.kind()) {
            case ISOLATED_KEYWORD: {
                if (qualKinds.contains(SyntaxKind.TRANSACTIONAL_KEYWORD)) break;
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_OBJECT.get()));
                if (qualKinds.contains(SyntaxKind.CLIENT_KEYWORD) || qualKinds.contains(SyntaxKind.SERVICE_KEYWORD)) break;
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_SERVICE.get()));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_CLIENT.get()));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_TRANSACTIONAL.get()));
                break;
            }
            case TRANSACTIONAL_KEYWORD: {
                if (!qualKinds.contains(SyntaxKind.ISOLATED_KEYWORD)) {
                    completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ISOLATED.get()));
                }
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FUNCTION.get()));
                break;
            }
            case CLIENT_KEYWORD: 
            case SERVICE_KEYWORD: {
                if (!qualKinds.contains(SyntaxKind.ISOLATED_KEYWORD)) {
                    completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ISOLATED.get()));
                }
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_OBJECT.get()));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_OBJECT_TYPE_DESC_SNIPPET.get()));
                break;
            }
        }
        return completionItems;
    }

    protected boolean onSuggestionsAfterQualifiers(BallerinaCompletionContext context, Node node) {
        int cursor = context.getCursorPositionInTree();
        List<Token> qualifiers = CommonUtil.getQualifiersOfNode(context, node);
        if (qualifiers.isEmpty()) {
            return false;
        }
        Token lastQualifier = qualifiers.get(qualifiers.size() - 1);
        return lastQualifier.textRange().endOffset() < cursor;
    }

    protected Optional<SnippetCompletionItem> getAnonFunctionDefSnippet(BallerinaCompletionContext context) {
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        Optional typeSymbolAtCursor = context.getContextType();
        if (typeSymbolAtCursor.isEmpty() || ((TypeSymbol)typeSymbolAtCursor.get()).typeKind() != TypeDescKind.FUNCTION) {
            return Optional.empty();
        }
        TypeSymbol symbol = (TypeSymbol)typeSymbolAtCursor.get();
        FunctionTypeSymbol functionTypeSymbol = (FunctionTypeSymbol)symbol;
        Optional returnTypeSymbol = functionTypeSymbol.returnTypeDescriptor();
        if (returnTypeSymbol.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<String> args = new ArrayList<String>();
        int argIndex = 1;
        Set<String> visibleSymbolNames = visibleSymbols.stream().map(Symbol::getName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        if (functionTypeSymbol.params().isPresent()) {
            for (ParameterSymbol parameterSymbol : (List)functionTypeSymbol.params().get()) {
                String varName = "";
                TypeSymbol parameterTypeSymbol = parameterSymbol.typeDescriptor();
                varName = NameUtil.generateParameterName(varName, argIndex, parameterTypeSymbol, visibleSymbolNames);
                args.add(FunctionGenerator.getParameterTypeAsString((DocumentServiceContext)context, parameterTypeSymbol) + " " + varName);
                visibleSymbolNames.add(varName);
                ++argIndex;
            }
        }
        String functionName = "";
        String snippet = FunctionGenerator.generateFunction((DocumentServiceContext)context, false, functionName, args, (TypeSymbol)returnTypeSymbol.get());
        SnippetBlock snippetBlock = new SnippetBlock("function (..) {..}", "function", snippet, "Snippet", SnippetBlock.Kind.SNIPPET);
        snippetBlock.setId("function (..) {..}");
        return Optional.of(new SnippetCompletionItem(context, snippetBlock));
    }

    protected void sortByAssignability(BallerinaCompletionContext context, LSCompletionItem completionItem, int rank) {
        Optional contextType = context.getContextType();
        Object sortText = "";
        sortText = contextType.isPresent() && SortingUtil.isCompletionItemAssignable(completionItem, (TypeSymbol)contextType.get()) ? (String)sortText + SortingUtil.genSortText(1) : (contextType.isPresent() && SortingUtil.isCompletionItemAssignableWithCheck(completionItem, (TypeSymbol)contextType.get()) ? (String)sortText + SortingUtil.genSortText(2) : (String)sortText + SortingUtil.genSortText(3));
        sortText = (String)sortText + SortingUtil.genSortText(rank);
        completionItem.getCompletionItem().setSortText((String)sortText);
    }
}

