/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.CompletionUtil;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class AssignmentStatementNodeContext
extends AbstractCompletionProvider<AssignmentStatementNode> {
    public AssignmentStatementNodeContext() {
        super(AssignmentStatementNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, AssignmentStatementNode node) throws LSCompletionException {
        if (this.cursorWithinLHS(context, node)) {
            return CompletionUtil.route(context, (Node)node.parent());
        }
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)node.expression())) {
            this.getQNameRefCompletions((QualifiedNameReferenceNode)node.expression(), context, completionItems);
        } else if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            this.getQNameRefCompletions((QualifiedNameReferenceNode)context.getNodeAtCursor(), context, completionItems);
        } else if (this.onSuggestionsAfterQualifiers(context, (Node)node.expression())) {
            completionItems.addAll(this.getCompletionItemsOnQualifiers((Node)node.expression(), context));
        } else {
            completionItems.addAll(this.actionKWCompletions(context));
            completionItems.addAll(this.expressionCompletions(context));
            completionItems.addAll(this.getNewExprCompletionItems(context, node));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    private void getQNameRefCompletions(QualifiedNameReferenceNode qNameRef, BallerinaCompletionContext context, List<LSCompletionItem> completionItems) {
        Predicate<Symbol> filter = symbol -> symbol instanceof VariableSymbol || symbol.kind() == SymbolKind.FUNCTION;
        List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, filter);
        completionItems.addAll(this.getCompletionItemList(moduleContent, context));
    }

    @Override
    protected List<LSCompletionItem> getCompletionItemsOnQualifiers(Node node, BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(super.getCompletionItemsOnQualifiers(node, context));
        List<Token> qualifiers = CommonUtil.getQualifiersOfNode(context, node);
        if (qualifiers.isEmpty()) {
            return completionItems;
        }
        Token lastQualifier = qualifiers.get(qualifiers.size() - 1);
        if (lastQualifier.kind() == SyntaxKind.ISOLATED_KEYWORD) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FUNCTION.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_OBJECT_TYPE_DESC_SNIPPET.get()));
        }
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, AssignmentStatementNode node) {
        return !node.equalsToken().isMissing();
    }

    @Override
    public void sort(BallerinaCompletionContext context, AssignmentStatementNode node, List<LSCompletionItem> completionItems) {
        Optional typeSymbolAtCursor = Optional.empty();
        if (context.currentSemanticModel().isPresent() && context.currentDocument().isPresent()) {
            LinePosition cursorPosition = LinePosition.from((int)context.getCursorPosition().getLine(), (int)context.getCursorPosition().getCharacter());
            typeSymbolAtCursor = ((SemanticModel)context.currentSemanticModel().get()).expectedType((Document)context.currentDocument().get(), cursorPosition);
        }
        if (typeSymbolAtCursor.isEmpty()) {
            super.sort(context, node, completionItems);
            return;
        }
        TypeSymbol symbol = (TypeSymbol)typeSymbolAtCursor.get();
        for (LSCompletionItem completionItem : completionItems) {
            completionItem.getCompletionItem().setSortText(SortingUtil.genSortTextByAssignability(context, completionItem, symbol));
        }
    }

    private List<LSCompletionItem> getNewExprCompletionItems(BallerinaCompletionContext context, AssignmentStatementNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Optional type = Optional.empty();
        if (context.currentSemanticModel().isPresent() && context.currentDocument().isPresent()) {
            LinePosition linePosition = node.expression().location().lineRange().startLine();
            type = ((SemanticModel)context.currentSemanticModel().get()).expectedType((Document)context.currentDocument().get(), linePosition);
        }
        if (type.isEmpty()) {
            return completionItems;
        }
        TypeSymbol rawType = CommonUtil.getRawType((TypeSymbol)type.get());
        if (rawType.kind() == SymbolKind.CLASS) {
            completionItems.add(this.getImplicitNewCItemForClass((ClassSymbol)rawType, context));
        }
        return completionItems;
    }

    private boolean cursorWithinLHS(BallerinaCompletionContext context, AssignmentStatementNode node) {
        int equalToken = node.equalsToken().textRange().endOffset();
        int cursor = context.getCursorPositionInTree();
        return cursor < equalToken;
    }
}

