/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.CollectClauseNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.providers.context.util.QueryExpressionUtil;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;

public class CollectClauseNodeContext
extends AbstractCompletionProvider<CollectClauseNode> {
    public CollectClauseNodeContext() {
        super(CollectClauseNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, CollectClauseNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (nodeAtCursor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> exprEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
            completionItems.addAll(this.getCompletionItemList(exprEntries, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
            List<FunctionSymbol> functionSymbols = QueryExpressionUtil.getLangLibMethods(context);
            functionSymbols.stream().filter(symbol -> symbol.typeDescriptor().restParam().isPresent()).filter(symbol -> symbol.getName().isPresent() && !((String)symbol.getName().get()).contains("$")).filter(symbol -> completionItems.addAll(this.populateBallerinaFunctionCompletionItems((FunctionSymbol)symbol, context))).toList();
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }
}

