/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.InvocationNodeContextProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;

public class ExplicitNewExpressionNodeContext
extends InvocationNodeContextProvider<ExplicitNewExpressionNode> {
    public ExplicitNewExpressionNodeContext() {
        super(ExplicitNewExpressionNode.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ExplicitNewExpressionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.withinArgs(context, node)) {
            completionItems.addAll(this.getCompletionsWithinArgs(context, node));
        } else if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            QualifiedNameReferenceNode referenceNode = (QualifiedNameReferenceNode)context.getNodeAtCursor();
            String moduleName = QNameRefCompletionUtil.getAlias(referenceNode);
            Optional<ModuleSymbol> module = ModuleUtil.searchModuleForAlias((PositionedOperationContext)context, moduleName);
            if (module.isEmpty()) {
                return completionItems;
            }
            module.get().allSymbols().stream().filter(this.getSymbolFilterPredicate(node)).forEach(symbol -> {
                Optional<LSCompletionItem> cItem = this.getExplicitNewCompletionItem((Symbol)symbol, context);
                cItem.ifPresent(completionItems::add);
            });
        } else {
            List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
            visibleSymbols.stream().filter(this.getSymbolFilterPredicate(node)).forEach(symbol -> {
                Optional<LSCompletionItem> cItem = this.getExplicitNewCompletionItem((Symbol)symbol, context);
                cItem.ifPresent(completionItems::add);
            });
            completionItems.addAll(this.getModuleCompletionItems(context));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    private Optional<ClassSymbol> getClassSymbol(BallerinaCompletionContext context) {
        Optional contextType = context.getContextType();
        if (contextType.isEmpty()) {
            return Optional.empty();
        }
        TypeSymbol rawType = CommonUtil.getRawType((TypeSymbol)contextType.get());
        if (rawType.kind() == SymbolKind.CLASS) {
            return Optional.of((ClassSymbol)rawType);
        }
        return Optional.empty();
    }

    private Predicate<Symbol> getSymbolFilterPredicate(ExplicitNewExpressionNode node) {
        if (node.parent().kind() == SyntaxKind.SERVICE_DECLARATION || node.parent().kind() == SyntaxKind.LISTENER_DECLARATION) {
            return symbol -> SymbolUtil.isClassDefinition(symbol) && SymbolUtil.isListener(symbol);
        }
        return symbol -> SymbolUtil.isClassDefinition(symbol) || SymbolUtil.isOfType(symbol, TypeDescKind.STREAM);
    }

    private boolean withinArgs(BallerinaCompletionContext context, ExplicitNewExpressionNode node) {
        ParenthesizedArgList parenthesizedArgList = node.parenthesizedArgList();
        int cursor = context.getCursorPositionInTree();
        return cursor > parenthesizedArgList.openParenToken().textRange().startOffset() && cursor < parenthesizedArgList.closeParenToken().textRange().endOffset();
    }

    private List<LSCompletionItem> getCompletionsWithinArgs(BallerinaCompletionContext ctx, ExplicitNewExpressionNode node) {
        NonTerminalNode nodeAtCursor = ctx.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)ctx, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            return this.getCompletionItemList(QNameRefCompletionUtil.getExpressionContextEntries(ctx, qNameRef), ctx);
        }
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.isNotInNamedArgOnlyContext(ctx, node.parenthesizedArgList().arguments().stream().toList())) {
            completionItems.addAll(this.expressionCompletions(ctx));
        }
        completionItems.addAll(this.getNamedArgExpressionCompletionItems(ctx, node));
        return completionItems;
    }

    private List<LSCompletionItem> getNamedArgExpressionCompletionItems(BallerinaCompletionContext context, ExplicitNewExpressionNode node) {
        ClassSymbol classSymbol;
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Optional semanticModel = context.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            return completionItems;
        }
        Optional symbol = ((SemanticModel)context.currentSemanticModel().get()).symbol((Node)node.typeDescriptor());
        if (symbol.isEmpty()) {
            return completionItems;
        }
        if (((Symbol)symbol.get()).kind() == SymbolKind.TYPE) {
            TypeSymbol typeSymbol = CommonUtil.getRawType(((TypeReferenceTypeSymbol)symbol.get()).typeDescriptor());
            if (typeSymbol.kind() != SymbolKind.CLASS) {
                return completionItems;
            }
            classSymbol = (ClassSymbol)typeSymbol;
        } else if (((Symbol)symbol.get()).kind() == SymbolKind.CLASS) {
            classSymbol = (ClassSymbol)symbol.get();
        } else {
            return completionItems;
        }
        Optional methodSymbol = classSymbol.initMethod();
        if (methodSymbol.isEmpty()) {
            return completionItems;
        }
        completionItems.addAll(this.getNamedArgCompletionItems(context, (FunctionSymbol)methodSymbol.get(), (SeparatedNodeList<FunctionArgumentNode>)node.parenthesizedArgList().arguments()));
        return completionItems;
    }
}

