/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.CompletionUtil;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class FunctionSignatureNodeContext
extends AbstractCompletionProvider<FunctionSignatureNode> {
    public FunctionSignatureNodeContext() {
        super(FunctionSignatureNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, FunctionSignatureNode node) throws LSCompletionException {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.withinReturnTypeDescContext(context, node)) {
            Optional returnTypeDesc = node.returnTypeDesc();
            if (returnTypeDesc.isEmpty() || ((ReturnTypeDescriptorNode)returnTypeDesc.get()).returnsKeyword().isMissing()) {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_RETURNS.get()));
            } else {
                completionItems.addAll(CompletionUtil.route(context, (Node)returnTypeDesc.get()));
            }
        } else if (this.withinParameterContext(context, node)) {
            NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
            if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
                QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
                completionItems.addAll(this.getCompletionItemList(QNameRefCompletionUtil.getTypesInModule(context, qNameRef), context));
            } else {
                completionItems.addAll(this.getTypeDescContextItems(context));
            }
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    private boolean withinReturnTypeDescContext(BallerinaCompletionContext context, FunctionSignatureNode node) {
        Token closeParenToken;
        int cursor = context.getCursorPositionInTree();
        return cursor > (closeParenToken = node.closeParenToken()).textRange().startOffset();
    }

    private boolean withinParameterContext(BallerinaCompletionContext context, FunctionSignatureNode node) {
        int cursor = context.getCursorPositionInTree();
        int openParan = node.openParenToken().textRange().endOffset();
        int closeParan = node.closeParenToken().textRange().startOffset();
        return openParan <= cursor && cursor <= closeParan;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, FunctionSignatureNode node) {
        return !node.openParenToken().isMissing() && !node.closeParenToken().isMissing() && node.parent().kind() != SyntaxKind.FUNCTION_TYPE_DESC;
    }

    @Override
    public void sort(BallerinaCompletionContext context, FunctionSignatureNode node, List<LSCompletionItem> completionItems) {
        if (this.withinParameterContext(context, node)) {
            completionItems.forEach(completionItem -> {
                String sortText = SortingUtil.genSortTextForTypeDescContext(context, completionItem);
                completionItem.getCompletionItem().setSortText(sortText);
            });
        }
    }
}

