/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.KeySpecifierNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxInfo;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TableTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.RawTypeSymbolWrapper;
import org.ballerinalang.langserver.common.utils.RecordUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.RecordFieldCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class KeySpecifierNodeContext
extends AbstractCompletionProvider<KeySpecifierNode> {
    public KeySpecifierNodeContext() {
        super(KeySpecifierNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, KeySpecifierNode node) {
        List<LSCompletionItem> completionItems = this.getKeyCompletionItems(context, node);
        this.sort(context, node, completionItems);
        return completionItems;
    }

    private List<LSCompletionItem> getKeyCompletionItems(BallerinaCompletionContext context, KeySpecifierNode node) {
        TypeSymbol rowTypeSymbol;
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (node.parent().kind() == SyntaxKind.TABLE_TYPE_DESC) {
            TableTypeDescriptorNode tableTypeDef = (TableTypeDescriptorNode)node.parent();
            if (tableTypeDef.rowTypeParameterNode().kind() != SyntaxKind.TYPE_PARAMETER) {
                return completionItems;
            }
            TypeParameterNode typeParameterNode = (TypeParameterNode)tableTypeDef.rowTypeParameterNode();
            Optional typeSymbol = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol((Node)typeParameterNode.typeNode())).flatMap(SymbolUtil::getTypeDescriptor);
            if (typeSymbol.isEmpty()) {
                return completionItems;
            }
            rowTypeSymbol = CommonUtil.getRawType((TypeSymbol)typeSymbol.get());
        } else {
            Optional typeSymbol = context.getContextType();
            if (typeSymbol.isEmpty()) {
                return completionItems;
            }
            rowTypeSymbol = CommonUtil.getRawType((TypeSymbol)typeSymbol.get());
        }
        Set fieldNames = node.fieldNames().stream().filter(identifierToken -> !identifierToken.isMissing()).map(Token::text).collect(Collectors.toSet());
        List<RawTypeSymbolWrapper<RecordTypeSymbol>> recordTypeSymbols = RecordUtil.getRecordTypeSymbols(rowTypeSymbol);
        List<RecordFieldSymbol> commonFields = recordTypeSymbols.stream().map(RawTypeSymbolWrapper::getRawType).map(RecordTypeSymbol::fieldDescriptors).reduce((map1, map2) -> map1.entrySet().stream().filter(e -> map2.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).stream().flatMap(map -> map.entrySet().stream()).filter(entry -> !fieldNames.contains(entry.getKey())).map(Map.Entry::getValue).filter(recordFieldSymbol -> recordFieldSymbol.getName().isPresent()).filter(recordFieldSymbol -> SyntaxInfo.isIdentifier((String)((String)recordFieldSymbol.getName().get()))).toList();
        completionItems.addAll(this.getCompletionItemList(commonFields, context));
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, KeySpecifierNode node, List<LSCompletionItem> completionItems) {
        for (LSCompletionItem completionItem : completionItems) {
            RecordFieldSymbol recordFieldSymbol;
            int rank = 2;
            if (completionItem.getType() == LSCompletionItem.CompletionItemType.RECORD_FIELD && (recordFieldSymbol = ((RecordFieldCompletionItem)completionItem).getFieldSymbol()).qualifiers().contains(Qualifier.READONLY)) {
                rank = 1;
            }
            completionItem.getCompletionItem().setSortText(SortingUtil.genSortText(rank) + SortingUtil.genSortText(SortingUtil.toRank(context, completionItem)));
        }
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, KeySpecifierNode node) {
        int cursor = context.getCursorPositionInTree();
        return !node.keyKeyword().isMissing() && node.openParenToken().textRange().startOffset() <= cursor && (node.closeParenToken().isMissing() || cursor < node.closeParenToken().textRange().endOffset());
    }
}

