/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.LetVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.CompleteExpressionValidator;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.providers.context.util.QueryExpressionUtil;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.CompletionItem;

public class LetVariableDeclarationNodeContext
extends AbstractCompletionProvider<LetVariableDeclarationNode> {
    public LetVariableDeclarationNodeContext() {
        super(LetVariableDeclarationNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, LetVariableDeclarationNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        int cursor = context.getCursorPositionInTree();
        TypeDescriptorNode typeDescriptor = node.typedBindingPattern().typeDescriptor();
        if (typeDescriptor.textRange().endOffset() >= cursor) {
            if (typeDescriptor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
                QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)typeDescriptor;
                List<Symbol> exprEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
                completionItems.addAll(this.getCompletionItemList(exprEntries, context));
                this.sort(context, node, (List<LSCompletionItem>)completionItems);
                return completionItems;
            }
            completionItems.addAll(this.getTypeDescContextItems(context));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_VAR.get()));
            for (LSCompletionItem lsCItem : completionItems) {
                CompletionItem completionItem = lsCItem.getCompletionItem();
                completionItem.setSortText(SortingUtil.genSortTextForTypeDescContext(context, lsCItem));
            }
            return completionItems;
        }
        if (this.cursorAtTheEndOfExpression(context, node)) {
            completionItems.addAll(QueryExpressionUtil.getCommonKeywordCompletions(context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, LetVariableDeclarationNode node) {
        int cursor = context.getCursorPositionInTree();
        Token equalsToken = node.equalsToken();
        ExpressionNode expression = node.expression();
        if (!expression.isMissing() && expression.kind() == SyntaxKind.BINARY_EXPRESSION && cursor > ((BinaryExpressionNode)expression).lhsExpr().textRange().endOffset() && ((BinaryExpressionNode)expression).operator().isMissing()) {
            return false;
        }
        if (node.typedBindingPattern().typeDescriptor().textRange().endOffset() >= cursor) {
            return true;
        }
        CompleteExpressionValidator expressionValidator = new CompleteExpressionValidator();
        boolean completeExpression = !this.isMissingExpression(expression) && (Boolean)expression.apply((NodeTransformer)expressionValidator) != false;
        return !equalsToken.isMissing() && equalsToken.textRange().startOffset() < cursor && (completeExpression && cursor <= expression.textRange().endOffset() || !completeExpression && (this.isMissingExpression(expression) || cursor >= expression.textRange().endOffset()));
    }

    @Override
    public void sort(BallerinaCompletionContext context, LetVariableDeclarationNode node, List<LSCompletionItem> completionItems) {
        Optional typeSymbolAtCursor = context.getContextType();
        if (typeSymbolAtCursor.isEmpty()) {
            super.sort(context, node, completionItems);
            return;
        }
        TypeSymbol symbol = (TypeSymbol)typeSymbolAtCursor.get();
        for (LSCompletionItem completionItem : completionItems) {
            completionItem.getCompletionItem().setSortText(SortingUtil.genSortTextByAssignability(context, completionItem, symbol));
        }
    }

    private boolean isMissingExpression(ExpressionNode expr) {
        return expr.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE && ((SimpleNameReferenceNode)expr).name().text().isEmpty();
    }

    private boolean cursorAtTheEndOfExpression(BallerinaCompletionContext context, LetVariableDeclarationNode node) {
        int cursorPosition = context.getCursorPositionInTree();
        return node.expression().kind() != SyntaxKind.BINARY_EXPRESSION && !PositionUtil.isWithInRange((Node)node, cursorPosition) && node.expression().textRange().startOffset() < cursorPosition;
    }
}

