/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.Snippet;

public abstract class MatchStatementContext<T extends Node>
extends AbstractCompletionProvider<T> {
    public MatchStatementContext(Class<T> attachmentPoint) {
        super(attachmentPoint);
    }

    protected List<LSCompletionItem> getPatternClauseCompletions(BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        List<Snippet> snippets = Arrays.asList(Snippet.KW_TRUE, Snippet.KW_FALSE, Snippet.KW_VAR);
        snippets.forEach(snippet -> completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, snippet.get())));
        List<Symbol> filteredConstants = visibleSymbols.stream().filter(this.constantFilter()).toList();
        completionItems.addAll(this.getCompletionItemList(filteredConstants, context));
        completionItems.addAll(this.getModuleCompletionItems(context));
        return completionItems;
    }

    protected Predicate<Symbol> constantFilter() {
        return symbol -> symbol.kind() == SymbolKind.CONSTANT || symbol.kind() == SymbolKind.ENUM_MEMBER;
    }
}

