/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.CompletionUtil;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class ObjectFieldNodeContext
extends AbstractCompletionProvider<ObjectFieldNode> {
    public ObjectFieldNodeContext() {
        super(ObjectFieldNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ObjectFieldNode node) throws LSCompletionException {
        if (this.onExpressionContext(context, node)) {
            List<LSCompletionItem> completionItems = this.getExpressionContextCompletions(context);
            this.sort(context, node, completionItems);
            return completionItems;
        }
        return CompletionUtil.route(context, node.typeName());
    }

    private List<LSCompletionItem> getExpressionContextCompletions(BallerinaCompletionContext ctx) {
        NonTerminalNode nodeAtCursor = ctx.getNodeAtCursor();
        if (nodeAtCursor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            return this.getCompletionItemList(QNameRefCompletionUtil.getExpressionContextEntries(ctx, qNameRef), ctx);
        }
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(this.expressionCompletions(ctx));
        List<Symbol> classFields = ctx.visibleSymbols(ctx.getCursorPosition()).stream().filter(symbol -> symbol.kind() == SymbolKind.CLASS_FIELD).toList();
        completionItems.addAll(this.getCompletionItemList(classFields, ctx));
        Optional contextType = ctx.getContextType();
        Optional<TypeSymbol> rawContextType = contextType.map(CommonUtil::getRawType);
        if (rawContextType.isPresent() && rawContextType.get().kind() == SymbolKind.CLASS) {
            LSCompletionItem implicitNewCompletionItem = this.getImplicitNewCItemForClass((ClassSymbol)rawContextType.get(), ctx);
            completionItems.add(implicitNewCompletionItem);
        }
        return completionItems;
    }

    private boolean onExpressionContext(BallerinaCompletionContext context, ObjectFieldNode node) {
        int cursor = context.getCursorPositionInTree();
        Optional equalsToken = node.equalsToken();
        return equalsToken.isPresent() && ((Token)equalsToken.get()).textRange().endOffset() <= cursor;
    }

    @Override
    public void sort(BallerinaCompletionContext context, ObjectFieldNode node, List<LSCompletionItem> completionItems) {
        Optional typeSymbolAtCursor = context.getContextType();
        if (typeSymbolAtCursor.isEmpty()) {
            super.sort(context, node, completionItems);
            return;
        }
        TypeSymbol symbol = (TypeSymbol)typeSymbolAtCursor.get();
        for (LSCompletionItem completionItem : completionItems) {
            completionItem.getCompletionItem().setSortText(SortingUtil.genSortTextByAssignability(context, completionItem, symbol));
        }
    }
}

