/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OnConflictClauseNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class OnConflictClauseNodeContext
extends AbstractCompletionProvider<OnConflictClauseNode> {
    public OnConflictClauseNodeContext() {
        super(OnConflictClauseNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, OnConflictClauseNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (nodeAtCursor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> exprEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
            completionItems.addAll(this.getCompletionItemList(exprEntries, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, OnConflictClauseNode node) {
        return !node.onKeyword().isMissing() && !node.conflictKeyword().isMissing();
    }

    @Override
    public void sort(BallerinaCompletionContext context, OnConflictClauseNode node, List<LSCompletionItem> lsCItems) {
        for (LSCompletionItem lsCItem : lsCItems) {
            Optional<Symbol> symbolWithErrorType = this.symbolWithErrorType(lsCItem);
            int rank = symbolWithErrorType.isEmpty() ? 3 : (symbolWithErrorType.get().kind() == SymbolKind.FUNCTION ? 2 : 1);
            String sortText = SortingUtil.genSortText(rank) + SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem));
            lsCItem.getCompletionItem().setSortText(sortText);
        }
    }

    private Optional<Symbol> symbolWithErrorType(LSCompletionItem lsCItem) {
        Optional typeSymbol;
        Predicate<Symbol> symbolPredicate = CommonUtil.getVariableFilterPredicate();
        if (lsCItem.getType() != LSCompletionItem.CompletionItemType.SYMBOL || ((SymbolCompletionItem)lsCItem).getSymbol().isEmpty()) {
            return Optional.empty();
        }
        Symbol symbol = ((SymbolCompletionItem)lsCItem).getSymbol().get();
        if (!symbolPredicate.test(symbol) && symbol.kind() != SymbolKind.FUNCTION) {
            return Optional.empty();
        }
        Optional optional = typeSymbol = symbol.kind() == SymbolKind.FUNCTION ? ((FunctionSymbol)symbol).typeDescriptor().returnTypeDescriptor() : SymbolUtil.getTypeDescriptor(symbol);
        if (typeSymbol.isPresent() && CommonUtil.getRawType((TypeSymbol)typeSymbol.get()).typeKind() == TypeDescKind.ERROR) {
            return Optional.of(symbol);
        }
        return Optional.empty();
    }
}

