/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.PanicStatementNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class PanicStatementNodeContext
extends AbstractCompletionProvider<PanicStatementNode> {
    public PanicStatementNodeContext() {
        super(PanicStatementNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, PanicStatementNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        List<Symbol> filteredList = visibleSymbols.stream().filter(SymbolUtil::isError).toList();
        completionItems.addAll(this.getCompletionItemList(filteredList, context));
        completionItems.addAll(this.expressionCompletions(context));
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, PanicStatementNode node, List<LSCompletionItem> completionItems) {
        Optional semanticModel = context.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            super.sort(context, node, completionItems);
            return;
        }
        TypeSymbol errorTypeSymbol = ((SemanticModel)semanticModel.get()).types().ERROR;
        for (LSCompletionItem completionItem : completionItems) {
            completionItem.getCompletionItem().setSortText(SortingUtil.genSortTextByAssignability(context, completionItem, errorTypeSymbol));
        }
    }
}

