/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.KeySpecifierNode;
import io.ballerina.compiler.syntax.tree.OnConflictClauseNode;
import io.ballerina.compiler.syntax.tree.QueryConstructTypeNode;
import io.ballerina.compiler.syntax.tree.QueryExpressionNode;
import io.ballerina.compiler.syntax.tree.QueryPipelineNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.Snippet;

public class QueryExpressionNodeContext
extends AbstractCompletionProvider<QueryExpressionNode> {
    private static final String TABLE_KW = "table";

    public QueryExpressionNodeContext() {
        super(QueryExpressionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, QueryExpressionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (node.queryConstructType().isPresent() && this.onQueryConstructType(context, (QueryConstructTypeNode)node.queryConstructType().get())) {
            QueryConstructTypeNode queryConstructType = (QueryConstructTypeNode)node.queryConstructType().get();
            int cursor = context.getCursorPositionInTree();
            if (TABLE_KW.equals(queryConstructType.keyword().text())) {
                if (queryConstructType.keySpecifier().isEmpty() || ((KeySpecifierNode)queryConstructType.keySpecifier().get()).keyKeyword().isMissing()) {
                    completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_KEY.get()));
                } else if (!this.withinKeySpecifierParenthesis(context, (KeySpecifierNode)queryConstructType.keySpecifier().get()) && cursor > ((KeySpecifierNode)queryConstructType.keySpecifier().get()).textRange().endOffset()) {
                    completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FROM.get()));
                    completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.CLAUSE_FROM.get()));
                }
            } else if (queryConstructType.keyword().textRange().endOffset() < cursor) {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FROM.get()));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.CLAUSE_FROM.get()));
            }
        } else if (this.onQueryPipeLine(context, node)) {
            completionItems.addAll(this.getKeywordCompletionItems(context, node));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    private boolean withinKeySpecifierParenthesis(BallerinaCompletionContext context, KeySpecifierNode keySpecifierNode) {
        int cursor = context.getCursorPositionInTree();
        return keySpecifierNode.openParenToken().textRange().endOffset() <= cursor && (keySpecifierNode.closeParenToken().isMissing() || cursor <= keySpecifierNode.closeParenToken().textRange().startOffset());
    }

    private boolean onQueryConstructType(BallerinaCompletionContext context, QueryConstructTypeNode node) {
        int cursor = context.getCursorPositionInTree();
        return !node.isMissing() && !node.keyword().isMissing() && node.textRangeWithMinutiae().endOffset() >= cursor;
    }

    private boolean onQueryPipeLine(BallerinaCompletionContext context, QueryExpressionNode node) {
        int cursor = context.getCursorPositionInTree();
        QueryPipelineNode queryPipeline = node.queryPipeline();
        Optional onConflictClause = node.onConflictClause();
        return !queryPipeline.isMissing() && queryPipeline.textRange().endOffset() < cursor && (onConflictClause.isEmpty() || ((OnConflictClauseNode)onConflictClause.get()).textRange().startOffset() > cursor);
    }

    private List<LSCompletionItem> getKeywordCompletionItems(BallerinaCompletionContext context, QueryExpressionNode node) {
        List<LSCompletionItem> completionItems = List.of(new LSCompletionItem[]{new SnippetCompletionItem(context, Snippet.KW_FROM.get()), new SnippetCompletionItem(context, Snippet.CLAUSE_FROM.get()), new SnippetCompletionItem(context, Snippet.KW_WHERE.get()), new SnippetCompletionItem(context, Snippet.KW_LET.get()), new SnippetCompletionItem(context, Snippet.CLAUSE_LET.get()), new SnippetCompletionItem(context, Snippet.KW_OUTER.get()), new SnippetCompletionItem(context, Snippet.KW_JOIN.get()), new SnippetCompletionItem(context, Snippet.CLAUSE_JOIN.get()), new SnippetCompletionItem(context, Snippet.KW_ORDERBY.get()), new SnippetCompletionItem(context, Snippet.KW_LIMIT.get()), new SnippetCompletionItem(context, Snippet.KW_GROUPBY.get()), new SnippetCompletionItem(context, Snippet.CLAUSE_GROUPBY.get())});
        if (!node.queryPipeline().fromClause().isMissing() && !node.queryPipeline().fromClause().fromKeyword().isMissing()) {
            completionItems = new ArrayList<LSCompletionItem>(completionItems);
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_SELECT.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_COLLECT.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.CLAUSE_DO.get()));
        }
        return completionItems;
    }
}

