/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.common.utils.TypeResolverUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.RightArrowActionNodeContext;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class RemoteMethodCallActionNodeContext
extends RightArrowActionNodeContext<RemoteMethodCallActionNode> {
    public RemoteMethodCallActionNodeContext() {
        super(RemoteMethodCallActionNode.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, RemoteMethodCallActionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.onSuggestClients(node, context)) {
            completionItems.addAll(this.expressionCompletions(context));
            this.sort(context, node, (List<LSCompletionItem>)completionItems);
            return completionItems;
        }
        Optional expressionType = Optional.empty();
        if (context.currentSemanticModel().isPresent() && context.currentDocument().isPresent()) {
            LinePosition linePosition = node.expression().location().lineRange().endLine();
            expressionType = ((SemanticModel)context.currentSemanticModel().get()).expectedType((Document)context.currentDocument().get(), linePosition);
        }
        if (expressionType.isEmpty() || !SymbolUtil.isClient((Symbol)expressionType.get())) {
            return Collections.emptyList();
        }
        if (this.onSuggestClientActions(node, context)) {
            List<MethodSymbol> clientActions = this.getClientActions((Symbol)expressionType.get());
            completionItems.addAll(this.getCompletionItemList(clientActions, context));
        } else if (TypeResolverUtil.isInMethodCallParameterContext(node, context.getCursorPositionInTree()).booleanValue()) {
            if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
                QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
                List<Symbol> exprEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
                List<LSCompletionItem> items = this.getCompletionItemList(exprEntries, context);
                completionItems.addAll(items);
            } else {
                if (this.isNotInNamedArgOnlyContext(context, node.arguments().stream().toList())) {
                    completionItems.addAll(this.actionKWCompletions(context));
                    completionItems.addAll(this.expressionCompletions(context));
                }
                completionItems.addAll(this.getNamedArgExpressionCompletionItems(context, node));
            }
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    private List<LSCompletionItem> getNamedArgExpressionCompletionItems(BallerinaCompletionContext context, RemoteMethodCallActionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Optional semanticModel = context.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            return completionItems;
        }
        Optional symbol = ((SemanticModel)semanticModel.get()).symbol((Node)node);
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.METHOD) {
            return completionItems;
        }
        FunctionSymbol functionSymbol = (FunctionSymbol)symbol.get();
        return this.getNamedArgCompletionItems(context, functionSymbol, (SeparatedNodeList<FunctionArgumentNode>)node.arguments());
    }

    private boolean onSuggestClientActions(RemoteMethodCallActionNode node, BallerinaCompletionContext context) {
        int cursor = context.getCursorPositionInTree();
        return node.rightArrowToken().textRange().endOffset() <= cursor && (node.openParenToken().isMissing() || cursor <= node.openParenToken().textRange().startOffset());
    }

    private boolean onSuggestClients(RemoteMethodCallActionNode node, BallerinaCompletionContext context) {
        int cursor = context.getCursorPositionInTree();
        return cursor <= node.rightArrowToken().textRange().startOffset();
    }

    @Override
    public void sort(BallerinaCompletionContext context, RemoteMethodCallActionNode node, List<LSCompletionItem> completionItems) {
        if (TypeResolverUtil.isInMethodCallParameterContext(node, context.getCursorPositionInTree()).booleanValue()) {
            super.sort(context, node, completionItems);
            return;
        }
        if (this.onSuggestClients(node, context)) {
            completionItems.forEach(completionItem -> {
                Optional<TypeSymbol> typeSymbol = SortingUtil.getSymbolFromCompletionItem(completionItem);
                Object sortText = typeSymbol.isPresent() && SymbolUtil.isClient((Symbol)typeSymbol.get()) ? SortingUtil.genSortText(1) : SortingUtil.genSortText(2);
                sortText = (String)sortText + SortingUtil.genSortText(SortingUtil.toRank(context, completionItem));
                completionItem.getCompletionItem().setSortText((String)sortText);
            });
            return;
        }
        for (LSCompletionItem item : completionItems) {
            this.sortByAssignability(context, item, SortingUtil.toRank(context, item));
        }
    }
}

