/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.FutureTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.StartActionNode;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class StartActionNodeContext
extends AbstractCompletionProvider<StartActionNode> {
    public StartActionNodeContext() {
        super(StartActionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, StartActionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        completionItems.addAll(this.expressionCompletions(context, node));
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    protected List<LSCompletionItem> expressionCompletions(BallerinaCompletionContext context, StartActionNode startActionNode) {
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> ctxEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
            return this.getCompletionItemList(ctxEntries, context);
        }
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(this.getTypeDescContextItems(context));
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        List<Symbol> filteredList = visibleSymbols.stream().filter(symbol -> symbol instanceof VariableSymbol || symbol.kind() == SymbolKind.FUNCTION).toList();
        completionItems.addAll(this.getCompletionItemList(filteredList, context));
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, StartActionNode node) {
        TextRange startKWRange = node.startKeyword().textRange();
        int cursorPosition = context.getCursorPositionInTree();
        return startKWRange.endOffset() < cursorPosition;
    }

    @Override
    public void sort(BallerinaCompletionContext context, StartActionNode node, List<LSCompletionItem> completionItems) {
        TypeSymbol typeSymbol;
        Optional typeSymbolAtCursor = context.getContextType();
        if (typeSymbolAtCursor.isEmpty()) {
            super.sort(context, node, completionItems);
            return;
        }
        if (((TypeSymbol)typeSymbolAtCursor.get()).typeKind() == TypeDescKind.FUTURE) {
            Optional optionalTypeSymbol = ((FutureTypeSymbol)typeSymbolAtCursor.get()).typeParameter();
            if (optionalTypeSymbol.isEmpty()) {
                super.sort(context, node, completionItems);
                return;
            }
            typeSymbol = (TypeSymbol)optionalTypeSymbol.get();
        } else {
            typeSymbol = (TypeSymbol)typeSymbolAtCursor.get();
        }
        completionItems.forEach(completionItem -> {
            Optional<Symbol> completionSymbol;
            if (completionItem.getType() == LSCompletionItem.CompletionItemType.SYMBOL && (completionSymbol = ((SymbolCompletionItem)((Object)completionItem)).getSymbol()).isPresent() && completionSymbol.get().kind() == SymbolKind.FUNCTION) {
                completionItem.getCompletionItem().setSortText(SortingUtil.genSortText(1) + SortingUtil.genSortTextByAssignability(context, completionItem, typeSymbol));
                return;
            }
            completionItem.getCompletionItem().setSortText(SortingUtil.genSortText(2) + SortingUtil.genSortText(SortingUtil.toRank(context, completionItem)));
        });
    }
}

