/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.CompletionItem;

public class TypeDefinitionNodeContext
extends AbstractCompletionProvider<TypeDefinitionNode> {
    public TypeDefinitionNodeContext() {
        super(TypeDefinitionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, TypeDefinitionNode node) {
        if (this.onTypeNameContext(context, node)) {
            return new ArrayList<LSCompletionItem>();
        }
        List<LSCompletionItem> completionItems = this.typeDescriptorCItems(context, node);
        this.sort(context, node, completionItems);
        return completionItems;
    }

    private List<LSCompletionItem> typeDescriptorCItems(BallerinaCompletionContext context, TypeDefinitionNode node) {
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            QualifiedNameReferenceNode nameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
            return this.getCompletionItemList(QNameRefCompletionUtil.getTypesInModule(context, nameRef), context);
        }
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.onSuggestionsAfterQualifiers(context, node.typeDescriptor())) {
            completionItems.addAll(this.getCompletionItemsOnQualifiers(node.typeDescriptor(), context));
        } else {
            completionItems.addAll(this.getTypeDescContextItems(context));
            completionItems.addAll(this.getTypeQualifierItems(context));
        }
        return completionItems;
    }

    @Override
    protected List<LSCompletionItem> getCompletionItemsOnQualifiers(Node node, BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(super.getCompletionItemsOnQualifiers(node, context));
        List<Token> qualifiers = CommonUtil.getQualifiersOfNode(context, node);
        if (qualifiers.isEmpty()) {
            return completionItems;
        }
        Token lastQualifier = qualifiers.get(qualifiers.size() - 1);
        if (lastQualifier.kind() == SyntaxKind.ISOLATED_KEYWORD) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FUNCTION.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_OBJECT_TYPE_DESC_SNIPPET.get()));
        }
        return completionItems;
    }

    private boolean onTypeNameContext(BallerinaCompletionContext context, TypeDefinitionNode node) {
        int cursor = context.getCursorPositionInTree();
        Token typeKeyword = node.typeKeyword();
        Token typeName = node.typeName();
        Node descriptor = node.typeDescriptor();
        if (typeKeyword.isMissing()) {
            return false;
        }
        return cursor > typeKeyword.textRange().endOffset() && (typeName.isMissing() && (descriptor.isMissing() || cursor < descriptor.textRange().startOffset()) || cursor <= typeName.textRange().endOffset());
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, TypeDefinitionNode node) {
        int cursor = context.getCursorPositionInTree();
        return node.typeKeyword().textRange().endOffset() < cursor && cursor <= node.semicolonToken().textRange().endOffset();
    }

    @Override
    public void sort(BallerinaCompletionContext context, TypeDefinitionNode node, List<LSCompletionItem> lsCItems) {
        for (LSCompletionItem lsCItem : lsCItems) {
            CompletionItem completionItem = lsCItem.getCompletionItem();
            completionItem.setSortText(SortingUtil.genSortTextForTypeDescContext(context, lsCItem));
        }
    }
}

