/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class TypeReferenceNodeContext
extends AbstractCompletionProvider<TypeReferenceNode> {
    public TypeReferenceNodeContext() {
        super(TypeReferenceNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, TypeReferenceNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Optional<Predicate<Symbol>> predicate = this.getTypeFilterPredicate(node);
        if (predicate.isEmpty()) {
            return completionItems;
        }
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
            List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, predicate.get());
            completionItems.addAll(this.getCompletionItemList(moduleContent, context));
        } else {
            List<Symbol> symbols = context.visibleSymbols(context.getCursorPosition()).stream().filter(predicate.get()).toList();
            completionItems.addAll(this.getCompletionItemList(symbols, context));
            completionItems.addAll(this.getModuleCompletionItems(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, TypeReferenceNode node, List<LSCompletionItem> completionItems) {
        for (LSCompletionItem lsCItem : completionItems) {
            String sortText = SortingUtil.genSortTextForTypeDescContext(context, lsCItem);
            lsCItem.getCompletionItem().setSortText(sortText);
        }
    }

    private Optional<Predicate<Symbol>> getTypeFilterPredicate(TypeReferenceNode node) {
        Predicate<Symbol> predicate = null;
        NonTerminalNode parent = node.parent();
        if (parent.kind() == SyntaxKind.CLASS_DEFINITION || parent.kind() == SyntaxKind.OBJECT_TYPE_DESC) {
            predicate = symbol -> symbol.kind() == SymbolKind.CLASS || symbol.kind() == SymbolKind.TYPE_DEFINITION && CommonUtil.getRawType(((TypeDefinitionSymbol)symbol).typeDescriptor()).typeKind() == TypeDescKind.OBJECT;
        } else if (parent.kind() == SyntaxKind.RECORD_TYPE_DESC) {
            predicate = symbol -> symbol.kind() == SymbolKind.TYPE_DEFINITION && CommonUtil.getRawType(((TypeDefinitionSymbol)symbol).typeDescriptor()).typeKind() == TypeDescKind.RECORD;
        }
        return Optional.ofNullable(predicate);
    }
}

