/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.QueryExpressionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.WhereClauseNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.CompleteExpressionValidator;
import org.ballerinalang.langserver.completions.providers.context.IntermediateClauseNodeContext;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class WhereClauseNodeContext
extends IntermediateClauseNodeContext<WhereClauseNode> {
    public WhereClauseNodeContext() {
        super(WhereClauseNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, WhereClauseNode node) {
        CompleteExpressionValidator expressionValidator;
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        ExpressionNode expression = node.expression();
        if (((Boolean)expression.apply((NodeTransformer)(expressionValidator = new CompleteExpressionValidator()))).booleanValue() && this.cursorAtTheEndOfClause(context, node)) {
            completionItems.addAll(this.getKeywordCompletions(context, node));
        } else if (nodeAtCursor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> exprEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
            completionItems.addAll(this.getCompletionItemList(exprEntries, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, WhereClauseNode node) {
        return !node.whereKeyword().isMissing();
    }

    @Override
    public void sort(BallerinaCompletionContext context, WhereClauseNode node, List<LSCompletionItem> completionItems) {
        Optional<QueryExpressionNode> queryExprNode = SortingUtil.getTheOutermostQueryExpressionNode((Node)node);
        if (queryExprNode.isEmpty()) {
            return;
        }
        completionItems.forEach(lsCItem -> {
            int rank = 2;
            if (SortingUtil.isSymbolCItemWithinNodeAndCursor(context, lsCItem, (Node)queryExprNode.get())) {
                rank = 1;
            }
            lsCItem.getCompletionItem().setSortText(SortingUtil.genSortText(rank) + SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem)));
        });
    }

    @Override
    protected Optional<Node> getLastNodeOfClause(WhereClauseNode node) {
        return Optional.of(node.expression());
    }
}

