/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.WhileStatementNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class WhileStatementNodeContext
extends AbstractCompletionProvider<WhileStatementNode> {
    public WhileStatementNodeContext() {
        super(WhileStatementNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, WhileStatementNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
            List<Symbol> symbols = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
            completionItems.addAll(this.getCompletionItemList(symbols, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, WhileStatementNode node) {
        int cursor = context.getCursorPositionInTree();
        BlockStatementNode whileBody = node.whileBody();
        Token whileKeyword = node.whileKeyword();
        return !whileKeyword.isMissing() && cursor >= whileKeyword.textRange().endOffset() + 1 && (whileBody.isMissing() || cursor < whileBody.openBraceToken().textRange().endOffset());
    }

    @Override
    public void sort(BallerinaCompletionContext context, WhileStatementNode node, List<LSCompletionItem> completionItems) {
        Optional semanticModel = context.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            super.sort(context, node, completionItems);
            return;
        }
        TypeSymbol booleanTypeSymbol = ((SemanticModel)semanticModel.get()).types().BOOLEAN;
        for (LSCompletionItem completionItem : completionItems) {
            completionItem.getCompletionItem().setSortText(SortingUtil.genSortTextByAssignability(context, completionItem, booleanTypeSymbol));
        }
    }
}

